/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.debug;

import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.FactoryBundledWithBinaryReader;
import ghidra.app.util.bin.format.pe.OffsetValidator;
import ghidra.app.util.bin.format.pe.debug.DebugDirectory;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StringDataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.data.UnicodeDataType;
import ghidra.util.Msg;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class DebugMisc
implements StructConverter {
    public static final String NAME = "IMAGE_DEBUG_MISC";
    private static final byte IMAGE_DEBUG_MISC_EXENAME = 1;
    private DebugDirectory debugDir;
    private int dataType;
    private int length;
    private boolean unicode;
    private byte[] reserved;
    private String actualData;

    static DebugMisc createDebugMisc(FactoryBundledWithBinaryReader reader, DebugDirectory debugDir, OffsetValidator validator) throws IOException {
        DebugMisc debugMisc = (DebugMisc)reader.getFactory().create(DebugMisc.class, new Object[0]);
        debugMisc.initDebugMisc(reader, debugDir, validator);
        return debugMisc;
    }

    private void initDebugMisc(FactoryBundledWithBinaryReader reader, DebugDirectory debugDir, OffsetValidator validator) throws IOException {
        this.debugDir = debugDir;
        long oldIndex = reader.getPointerIndex();
        long index = (long)debugDir.getPointerToRawData() & 0xFFFFFFFFL;
        if (!validator.checkPointer(index)) {
            Msg.error((Object)this, (Object)("Invalid file index " + Long.toHexString(index)));
            return;
        }
        reader.setPointerIndex(index);
        this.dataType = reader.readNextInt();
        this.length = reader.readNextInt();
        this.unicode = reader.readNextByte() == 1;
        this.reserved = reader.readNextByteArray(3);
        if (this.length > 0) {
            this.actualData = this.unicode ? reader.readNextUnicodeString(this.length) : reader.readNextAsciiString();
        } else {
            Msg.error((Object)this, (Object)("Bad string length " + Integer.toHexString(this.length)));
        }
        reader.setPointerIndex(oldIndex);
    }

    public int getDataType() {
        return this.dataType;
    }

    public int getLength() {
        return this.length;
    }

    public boolean isUnicode() {
        return this.unicode;
    }

    public byte[] getReserved() {
        return this.reserved;
    }

    public String getActualData() {
        return this.actualData;
    }

    public String toString() {
        if (this.getDataType() == 1) {
            return "Misc Debug Information: " + this.getActualData();
        }
        return "Unknown Misc Debug Information Type: " + this.getDataType();
    }

    public DebugDirectory getDebugDirectory() {
        return this.debugDir;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException {
        StructureDataType struct = new StructureDataType(NAME, 0);
        struct.add(DWORD, "DataType", "type of misc data, see defines");
        struct.add(DWORD, "Length", "total length of record, rounded to four byte multiple");
        struct.add(BYTE, "Unicode", "TRUE if data is unicode string");
        struct.add((DataType)new ArrayDataType(BYTE, 3, 1), "Reserved[3]", null);
        if (this.isUnicode()) {
            struct.add((DataType)new UnicodeDataType(), this.length - 12, "Data[]", "Actual data");
        } else {
            struct.add((DataType)new StringDataType(), this.length - 12, "Data[]", "Actual data");
        }
        return struct;
    }
}

