/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.resource;

import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.FactoryBundledWithBinaryReader;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class ResourceDataEntry
implements StructConverter {
    public static final String NAME = "IMAGE_RESOURCE_DATA_ENTRY";
    public static final int SIZEOF = 16;
    private int offsetToData;
    private int size;
    private int codePage;
    private int reserved;

    public ResourceDataEntry(FactoryBundledWithBinaryReader reader, int index) throws IOException {
        this.offsetToData = reader.readInt(index);
        this.size = reader.readInt(index += 4);
        this.codePage = reader.readInt(index += 4);
        this.reserved = reader.readInt(index += 4);
    }

    public int getOffsetToData() {
        return this.offsetToData;
    }

    public int getSize() {
        return this.size;
    }

    public int getCodePage() {
        return this.codePage;
    }

    public int getReserved() {
        return this.reserved;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(NAME, 0);
        struct.add(DWORD, "OffsetToData", null);
        struct.add(DWORD, "Size", null);
        struct.add(DWORD, "CodePage", null);
        struct.add(DWORD, "Reserved", null);
        struct.setCategoryPath(new CategoryPath("/PE"));
        return struct;
    }

    public String toString() {
        return "0x" + Integer.toHexString(this.offsetToData) + " - 0x" + Integer.toHexString(this.size);
    }
}

