/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.cparser.C;

import ghidra.app.util.cparser.C.ParseException;
import ghidra.program.model.data.AbstractIntegerDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.PointerDataType;

public class Declaration {
    private int qualifier;
    private DataType dt;
    private String name;
    private String comment;
    private int bitSize = -1;

    public Declaration() {
    }

    public Declaration(Declaration dec) {
        this();
        this.dt = dec.getDataType();
    }

    public Declaration(Declaration dec, String name) throws ParseException {
        this();
        if (dec == null) {
            throw new ParseException("Undefined data type \"" + name + "\"");
        }
        this.dt = dec.getDataType();
        this.name = name;
    }

    public Declaration(String name) {
        this.name = name;
    }

    public Declaration(DataType dt) {
        this();
        this.dt = dt;
    }

    public Declaration(Declaration subDecl, DataType dt) {
        this.dt = dt;
        if (subDecl == null) {
            return;
        }
        if (subDecl.dt != null && subDecl.dt instanceof PointerDataType) {
            this.dt = new PointerDataType(dt);
        }
        this.name = subDecl.name;
        this.comment = subDecl.comment;
    }

    public Declaration(DataType dt, String name) {
        this();
        this.dt = dt;
        this.name = name;
    }

    public Declaration(DataType dt, String name, String comment) {
        this();
        this.dt = dt;
        this.name = name;
        this.comment = comment;
    }

    public String getComment() {
        return this.comment;
    }

    public int getQualifier() {
        return this.qualifier;
    }

    public DataType getDataType() {
        return this.dt;
    }

    public String getName() {
        if (this.name == null) {
            return "";
        }
        return this.name;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public void setQualifier(int qualifier) {
        this.qualifier = qualifier;
    }

    public void setDataType(DataType type) {
        if (this.dt instanceof AbstractIntegerDataType && type instanceof AbstractIntegerDataType) {
            AbstractIntegerDataType primDT = (AbstractIntegerDataType)this.dt;
            AbstractIntegerDataType primNewDT = (AbstractIntegerDataType)type;
            if (!primDT.isSigned() && primNewDT.isSigned()) {
                type = primNewDT.getOppositeSignednessDataType();
            }
        }
        this.dt = type;
    }

    public void setName(String string) {
        this.name = string;
    }

    boolean isBitField() {
        return this.bitSize >= 0;
    }

    public int getBitFieldSize() {
        return this.bitSize;
    }

    void setBitFieldSize(int bits) throws ParseException {
        if (bits < 0) {
            throw new ParseException("Negative bitfield size not permitted: " + this.dt.getName());
        }
        this.bitSize = bits;
    }
}

