/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.util;

import docking.widgets.fieldpanel.support.AnchoredLayout;
import ghidra.app.util.viewer.listingpanel.VerticalPixelAddressMap;
import ghidra.app.util.viewer.util.AddressIndexMap;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import java.util.List;

public class VerticalPixelAddressMapImpl
implements VerticalPixelAddressMap {
    private List<AnchoredLayout> layouts;
    private final AddressIndexMap map;
    private AddressSetView viewedAddresses;

    public VerticalPixelAddressMapImpl(List<AnchoredLayout> layouts, AddressIndexMap map) {
        this.layouts = layouts;
        this.map = map;
    }

    @Override
    public Address getStartAddress() {
        return this.map.getAddress(this.layouts.get(0).getIndex());
    }

    @Override
    public Address getEndAddress() {
        return this.map.getAddress(this.layouts.get(this.layouts.size() - 1).getIndex());
    }

    @Override
    public int getNumLayouts() {
        return this.layouts.size();
    }

    @Override
    public Address getLayoutAddress(int i) {
        if (i < 0 || i >= this.layouts.size()) {
            return null;
        }
        return this.map.getAddress(this.layouts.get(i).getIndex());
    }

    @Override
    public Address getLayoutEndAddress(int i) {
        if (i < 0 || i >= this.layouts.size()) {
            return null;
        }
        Address addr = this.map.getAddress(this.layouts.get(i).getIndex());
        try {
            return addr.add((long)(this.layouts.get(i).getIndexSize() - 1));
        }
        catch (AddressOutOfBoundsException e) {
            return null;
        }
    }

    @Override
    public int getBeginPosition(int i) {
        if (i < 0 || i >= this.layouts.size()) {
            return 0;
        }
        return this.layouts.get(i).getYPos();
    }

    @Override
    public int getEndPosition(int i) {
        if (i < 0 || i >= this.layouts.size()) {
            return 0;
        }
        return this.layouts.get(i).getYPos() + this.layouts.get(i).getHeight() - 1;
    }

    @Override
    public int getMarkPosition(int i) {
        if (i < 0 || i >= this.layouts.size()) {
            return 0;
        }
        return this.getBeginPosition(i) + this.layouts.get(i).getPrimaryOffset();
    }

    @Override
    public boolean hasPrimaryField(int i) {
        if (i < 0 || i >= this.layouts.size()) {
            return false;
        }
        return this.layouts.get(i).getPrimaryOffset() >= 0;
    }

    @Override
    public int findLayoutAt(int y) {
        for (int i = 0; i < this.layouts.size(); ++i) {
            if (!this.layouts.get(i).contains(y)) continue;
            return i;
        }
        return -1;
    }

    public int getLayoutIndexSize(int i) {
        return this.layouts.get(i).getIndexSize();
    }

    @Override
    public AddressSetView getAddressSet() {
        if (this.layouts.isEmpty()) {
            return new AddressSet();
        }
        if (this.viewedAddresses == null) {
            this.viewedAddresses = this.map.getOriginalAddressSet().intersectRange(this.getStartAddress(), this.getEndAddress());
        }
        return this.viewedAddresses;
    }
}

