/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.table;

import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.GTableCellRenderingData;
import ghidra.app.plugin.core.navigation.locationreferences.ReferenceUtils;
import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.util.HTMLUtilities;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.table.AddressBasedTableModel;
import ghidra.util.table.column.AbstractGColumnRenderer;
import ghidra.util.table.column.GColumnRenderer;
import ghidra.util.table.field.AbstractProgramBasedDynamicTableColumn;
import ghidra.util.table.field.IncomingReferenceEndpoint;
import ghidra.util.table.field.ReferenceEndpoint;
import ghidra.util.task.TaskMonitor;
import java.awt.Color;
import java.awt.Component;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JLabel;

public class ReferencesFromTableModel
extends AddressBasedTableModel<ReferenceEndpoint> {
    private List<IncomingReferenceEndpoint> refs;

    public ReferencesFromTableModel(List<Reference> refs, ServiceProvider sp, Program program) {
        super("References", sp, program, null);
        this.refs = refs.stream().map(r -> {
            boolean offcut = ReferenceUtils.isOffcut(program, r.getToAddress());
            return new IncomingReferenceEndpoint((Reference)r, offcut);
        }).collect(Collectors.toList());
        this.addTableColumn((DynamicTableColumn)new ReferenceTypeTableColumn());
    }

    protected void doLoad(Accumulator<ReferenceEndpoint> accumulator, TaskMonitor monitor) throws CancelledException {
        this.refs.forEach(r -> accumulator.add(r));
    }

    @Override
    public Address getAddress(int row) {
        ReferenceEndpoint rowObject = (ReferenceEndpoint)this.getRowObject(row);
        return rowObject.getAddress();
    }

    private class ReferenceTypeTableCellRenderer
    extends AbstractGColumnRenderer<ReferenceEndpoint> {
        private static final String PLAIN_OFFCUT_TEXT = "<< OFFCUT >>";
        private static final String HTML_OFFCUT_TEXT = " &lt;&lt; OFFCUT &gt;&gt;";

        ReferenceTypeTableCellRenderer() {
            this.setHTMLRenderingEnabled(true);
        }

        public Component getTableCellRendererComponent(GTableCellRenderingData data) {
            JLabel label = (JLabel)super.getTableCellRendererComponent(data);
            ReferenceEndpoint rowObject = (ReferenceEndpoint)data.getValue();
            String text = this.asString(rowObject);
            label.setText(text);
            return label;
        }

        private String asString(ReferenceEndpoint t) {
            RefType refType = t.getReferenceType();
            Object text = refType.getName();
            if (t.isOffcut()) {
                text = "<html>" + HTMLUtilities.colorString((Color)Color.RED, (String)((String)text + HTML_OFFCUT_TEXT));
            }
            return text;
        }

        public String getFilterString(ReferenceEndpoint t, Settings settings) {
            RefType refType = t.getReferenceType();
            String text = refType.getName();
            if (t.isOffcut()) {
                return text + PLAIN_OFFCUT_TEXT;
            }
            return text;
        }
    }

    private class ReferenceTypeTableColumn
    extends AbstractProgramBasedDynamicTableColumn<ReferenceEndpoint, ReferenceEndpoint> {
        private ReferenceTypeTableCellRenderer renderer;

        private ReferenceTypeTableColumn() {
            this.renderer = new ReferenceTypeTableCellRenderer();
        }

        public ReferenceEndpoint getValue(ReferenceEndpoint rowObject, Settings settings, Program data, ServiceProvider sp) throws IllegalArgumentException {
            return rowObject;
        }

        public String getColumnName() {
            return "Ref Type";
        }

        public GColumnRenderer<ReferenceEndpoint> getColumnRenderer() {
            return this.renderer;
        }
    }
}

