/*
 * Decompiled with CFR 0.152.
 */
package mdemangler.datatype;

import mdemangler.MDException;
import mdemangler.MDMang;
import mdemangler.datatype.MDCharDataType;
import mdemangler.datatype.MDDataType;
import mdemangler.datatype.MDDoubleDataType;
import mdemangler.datatype.MDFloatDataType;
import mdemangler.datatype.MDIntDataType;
import mdemangler.datatype.MDLongDataType;
import mdemangler.datatype.MDLongDoubleDataType;
import mdemangler.datatype.MDShortDataType;
import mdemangler.datatype.MDVarArgsType;
import mdemangler.datatype.MDVoidDataType;
import mdemangler.datatype.complex.MDClassType;
import mdemangler.datatype.complex.MDCoclassType;
import mdemangler.datatype.complex.MDCointerfaceType;
import mdemangler.datatype.complex.MDComplexType;
import mdemangler.datatype.complex.MDEnumType;
import mdemangler.datatype.complex.MDStructType;
import mdemangler.datatype.complex.MDUnionType;
import mdemangler.datatype.extended.MDBoolDataType;
import mdemangler.datatype.extended.MDChar16DataType;
import mdemangler.datatype.extended.MDChar32DataType;
import mdemangler.datatype.extended.MDChar8DataType;
import mdemangler.datatype.extended.MDInt128DataType;
import mdemangler.datatype.extended.MDInt16DataType;
import mdemangler.datatype.extended.MDInt32DataType;
import mdemangler.datatype.extended.MDInt64DataType;
import mdemangler.datatype.extended.MDInt8DataType;
import mdemangler.datatype.extended.MDUnknownPExtendedDataType;
import mdemangler.datatype.extended.MDUnknownRExtendedDataType;
import mdemangler.datatype.extended.MDUnknownTExtendedDataType;
import mdemangler.datatype.extended.MDUnknownVExtendedDataType;
import mdemangler.datatype.extended.MDW64Type;
import mdemangler.datatype.extended.MDWcharDataType;
import mdemangler.datatype.modifier.MDArrayBasicType;
import mdemangler.datatype.modifier.MDDataRefRefType;
import mdemangler.datatype.modifier.MDDataReferenceType;
import mdemangler.datatype.modifier.MDFunctionIndirectType;
import mdemangler.datatype.modifier.MDModifierType;
import mdemangler.datatype.modifier.MDPointerRefDataType;
import mdemangler.datatype.modifier.MDPointerType;
import mdemangler.datatype.modifier.MDReferenceType;
import mdemangler.datatype.modifier.MDStdNullPtrType;
import mdemangler.object.MDObjectCPP;

public class MDDataTypeParser {
    public static MDDataType parseDataType(MDMang dmang, boolean isHighest) throws MDException {
        MDDataType dt;
        char code = dmang.peek();
        switch (code) {
            case '?': {
                dmang.increment();
                dt = new MDModifierType(dmang);
                break;
            }
            case 'X': {
                dmang.increment();
                dt = new MDVoidDataType(dmang);
                break;
            }
            case '\uffff': {
                throw new MDException("Type code not expected: " + code);
            }
            default: {
                dt = MDDataTypeParser.parsePrimaryDataType(dmang, isHighest);
            }
        }
        return dt;
    }

    public static MDDataType parsePrimaryDataType(MDMang dmang, boolean isHighest) throws MDException {
        MDDataType dt;
        char code = dmang.peek();
        switch (code) {
            case '$': {
                dmang.increment();
                dt = MDDataTypeParser.parseSpecialExtendedType(dmang, isHighest);
                break;
            }
            case 'A': 
            case 'B': {
                dmang.increment();
                MDReferenceType rt = new MDReferenceType(dmang);
                dt = rt;
                if (!isHighest) break;
                if (code == 'B') {
                    rt.clearConst();
                    rt.setVolatile();
                    break;
                }
                rt.clearConst();
                rt.clearVolatile();
                break;
            }
            case '\uffff': {
                throw new MDException("Type code not expected: " + code);
            }
            default: {
                dt = MDDataTypeParser.parseBasicDataType(dmang, isHighest);
            }
        }
        return dt;
    }

    public static MDDataType parseSpecialExtendedType(MDMang dmang, boolean isHighest) throws MDException {
        MDModifierType dt;
        char code = dmang.getAndIncrement();
        if (code != '$') {
            throw new MDException("ExtendedType invalid character: " + code);
        }
        code = dmang.getAndIncrement();
        switch (code) {
            case 'A': {
                dt = new MDFunctionIndirectType(dmang);
                break;
            }
            case 'B': {
                dt = new MDPointerRefDataType(dmang);
                break;
            }
            case 'C': {
                dt = new MDDataReferenceType(dmang);
                break;
            }
            case 'Q': 
            case 'R': {
                MDDataRefRefType drrt = new MDDataRefRefType(dmang);
                dt = drrt;
                if (!isHighest || code != 'R') break;
                drrt.clearConst();
                drrt.setVolatile();
                break;
            }
            case 'T': {
                dt = new MDStdNullPtrType(dmang);
                break;
            }
            default: {
                throw new MDException("TemplateParameterModifierType unrecognized code: " + code);
            }
        }
        return dt;
    }

    public static MDDataType parseBasicDataType(MDMang dmang, boolean isHighest) throws MDException {
        MDDataType dt;
        char code = dmang.getAndIncrement();
        block0 : switch (code) {
            case 'C': {
                dt = new MDCharDataType(dmang);
                dt.setSigned();
                break;
            }
            case 'D': {
                dt = new MDCharDataType(dmang);
                break;
            }
            case 'E': {
                dt = new MDCharDataType(dmang);
                dt.setUnsigned();
                break;
            }
            case 'F': {
                dt = new MDShortDataType(dmang);
                break;
            }
            case 'G': {
                dt = new MDShortDataType(dmang);
                dt.setUnsigned();
                break;
            }
            case 'H': {
                dt = new MDIntDataType(dmang);
                break;
            }
            case 'I': {
                dt = new MDIntDataType(dmang);
                dt.setUnsigned();
                break;
            }
            case 'J': {
                dt = new MDLongDataType(dmang);
                break;
            }
            case 'K': {
                dt = new MDLongDataType(dmang);
                dt.setUnsigned();
                break;
            }
            case 'L': {
                dt = new MDComplexType(dmang);
                break;
            }
            case 'M': {
                dt = new MDFloatDataType(dmang);
                break;
            }
            case 'N': {
                dt = new MDDoubleDataType(dmang);
                break;
            }
            case 'O': {
                dt = new MDLongDoubleDataType(dmang);
                break;
            }
            case 'P': 
            case 'Q': 
            case 'R': 
            case 'S': {
                MDPointerType pt = new MDPointerType(dmang);
                dt = pt;
                if (!isHighest) break;
                switch (code) {
                    case 'P': {
                        pt.clearConst();
                        pt.clearVolatile();
                        break;
                    }
                    case 'R': {
                        pt.clearConst();
                        pt.setVolatile();
                        break;
                    }
                    case 'Q': {
                        pt.setConst();
                        pt.clearVolatile();
                        break;
                    }
                    case 'S': {
                        pt.setConst();
                        pt.setVolatile();
                    }
                }
                break;
            }
            case 'T': {
                dt = new MDUnionType(dmang);
                break;
            }
            case 'U': {
                dt = new MDStructType(dmang);
                break;
            }
            case 'V': {
                dt = new MDClassType(dmang);
                break;
            }
            case 'W': {
                dt = new MDEnumType(dmang);
                break;
            }
            case 'X': {
                dt = new MDVoidDataType(dmang);
                break;
            }
            case 'Y': {
                dt = new MDCointerfaceType(dmang, 1);
                break;
            }
            case 'Z': {
                dt = new MDVarArgsType(dmang);
                break;
            }
            case '_': {
                code = dmang.getAndIncrement();
                switch (code) {
                    case '$': {
                        dt = new MDW64Type(dmang);
                        break block0;
                    }
                    case 'D': {
                        dt = new MDInt8DataType(dmang);
                        break block0;
                    }
                    case 'E': {
                        dt = new MDInt8DataType(dmang);
                        dt.setUnsigned();
                        break block0;
                    }
                    case 'F': {
                        dt = new MDInt16DataType(dmang);
                        break block0;
                    }
                    case 'G': {
                        dt = new MDInt16DataType(dmang);
                        dt.setUnsigned();
                        break block0;
                    }
                    case 'H': {
                        dt = new MDInt32DataType(dmang);
                        break block0;
                    }
                    case 'I': {
                        dt = new MDInt32DataType(dmang);
                        dt.setUnsigned();
                        break block0;
                    }
                    case 'J': {
                        dt = new MDInt64DataType(dmang);
                        break block0;
                    }
                    case 'K': {
                        dt = new MDInt64DataType(dmang);
                        dt.setUnsigned();
                        break block0;
                    }
                    case 'L': {
                        dt = new MDInt128DataType(dmang);
                        break block0;
                    }
                    case 'M': {
                        dt = new MDInt128DataType(dmang);
                        dt.setUnsigned();
                        break block0;
                    }
                    case 'N': {
                        dt = new MDBoolDataType(dmang);
                        break block0;
                    }
                    case 'O': {
                        dt = new MDArrayBasicType(dmang);
                        break block0;
                    }
                    case 'P': {
                        dt = new MDUnknownPExtendedDataType(dmang);
                        break block0;
                    }
                    case 'Q': {
                        dt = new MDChar8DataType(dmang);
                        break block0;
                    }
                    case 'R': {
                        dt = new MDUnknownRExtendedDataType(dmang);
                        break block0;
                    }
                    case 'S': {
                        dt = new MDChar16DataType(dmang);
                        break block0;
                    }
                    case 'T': {
                        dt = new MDUnknownTExtendedDataType(dmang);
                        break block0;
                    }
                    case 'U': {
                        dt = new MDChar32DataType(dmang);
                        break block0;
                    }
                    case 'V': {
                        dt = new MDUnknownVExtendedDataType(dmang);
                        break block0;
                    }
                    case 'W': {
                        dt = new MDWcharDataType(dmang);
                        break block0;
                    }
                    case 'X': {
                        dt = new MDCoclassType(dmang, 2);
                        break block0;
                    }
                    case 'Y': {
                        dt = new MDCointerfaceType(dmang, 2);
                        break block0;
                    }
                    case '_': {
                        MDObjectCPP object = new MDObjectCPP(dmang);
                        object.parse();
                        dt = new MDDataType(dmang);
                        dt.setName(object.toString());
                        break block0;
                    }
                    case '\uffff': {
                        throw new MDException("Type code not expected: " + code);
                    }
                }
                throw new MDException("Type code not expected: " + code);
            }
            case '@': {
                MDVoidDataType dtv = new MDVoidDataType(dmang);
                dtv.setNonPrinting();
                dt = dtv;
                break;
            }
            case '\uffff': {
                throw new MDException("Type code not expected: " + code);
            }
            default: {
                throw new MDException("Type code not expected: " + code);
            }
        }
        return dt;
    }
}

