/*
 * Decompiled with CFR 0.152.
 */
package mdemangler.datatype.extended;

import java.util.Objects;
import mdemangler.MDEncodedNumber;
import mdemangler.MDException;
import mdemangler.MDMang;
import mdemangler.datatype.MDDataTypeParser;
import mdemangler.datatype.modifier.MDModifierType;

public class MDArrayReferencedType
extends MDModifierType {
    private String arrayString = "";

    public MDArrayReferencedType(MDMang dmang) {
        super(dmang, 0);
        this.cvMod.clearProperties();
        this.cvMod.clearCV();
    }

    @Override
    public void setArrayString(String arrayString) {
        this.arrayString = Objects.requireNonNull(arrayString);
    }

    @Override
    public String getArrayString() {
        return this.arrayString;
    }

    @Override
    protected void parseInternal() throws MDException {
        if (this.dmang.peek() == 'Y') {
            this.dmang.increment();
            MDEncodedNumber n1 = new MDEncodedNumber(this.dmang);
            n1.parse();
            int num = n1.getValue().intValue();
            Object arrString = "";
            while (num-- > 0) {
                MDEncodedNumber n2 = new MDEncodedNumber(this.dmang);
                n2.parse();
                arrString = (String)arrString + "[" + n2 + "]";
            }
            this.setArrayString((String)arrString);
            this.refType = MDDataTypeParser.parsePrimaryDataType(this.dmang, false);
            this.refType.parse();
        }
    }

    @Override
    public void insert(StringBuilder builder) {
        if (!this.dmang.isEffectivelyEmpty(builder)) {
            this.dmang.insertString(builder, "(");
            this.dmang.appendString(builder, ")");
        }
        this.dmang.appendString(builder, this.getArrayString());
        this.refType.insert(builder);
    }
}

