/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.impl.dbgeng.registers;

import agent.dbgeng.dbgeng.COMUtilsExtra;
import agent.dbgeng.dbgeng.DbgEng;
import agent.dbgeng.dbgeng.DebugRegisters;
import agent.dbgeng.dbgeng.DebugValue;
import agent.dbgeng.impl.dbgeng.registers.DebugRegistersInternal;
import agent.dbgeng.jna.dbgeng.DbgEngNative;
import agent.dbgeng.jna.dbgeng.registers.IDebugRegisters;
import com.sun.jna.Native;
import com.sun.jna.platform.win32.COM.COMUtils;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import ghidra.comm.util.BitmaskSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class DebugRegistersImpl1
implements DebugRegistersInternal {
    private final DbgEng.OpaqueCleanable cleanable;
    private final IDebugRegisters jnaRegisters;

    public DebugRegistersImpl1(IDebugRegisters jnaRegisters) {
        this.cleanable = DbgEng.releaseWhenPhantom((Object)this, jnaRegisters);
        this.jnaRegisters = jnaRegisters;
    }

    @Override
    public int getNumberRegisters() {
        WinDef.ULONGByReference pulNumber = new WinDef.ULONGByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaRegisters.GetNumberRegisters(pulNumber));
        return pulNumber.getValue().intValue();
    }

    @Override
    public DebugRegisters.DebugRegisterDescription getDescription(int registerIndex) {
        WinDef.ULONG ulRegIdx = new WinDef.ULONG((long)registerIndex);
        WinDef.ULONGByReference pulNameSize = new WinDef.ULONGByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaRegisters.GetDescription(ulRegIdx, null, new WinDef.ULONG(0L), pulNameSize, null));
        byte[] name = new byte[pulNameSize.getValue().intValue()];
        DbgEngNative.DEBUG_REGISTER_DESCRIPTION.ByReference desc = new DbgEngNative.DEBUG_REGISTER_DESCRIPTION.ByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaRegisters.GetDescription(ulRegIdx, name, pulNameSize.getValue(), null, desc));
        return new DebugRegisters.DebugRegisterDescription(Native.toString((byte[])name), registerIndex, DebugValue.DebugValueType.values()[desc.Type.intValue()], (BitmaskSet<DebugRegisters.DebugRegisterFlags>)new BitmaskSet(DebugRegisters.DebugRegisterFlags.class, (long)desc.Flags.intValue()), desc.SubregMaster.intValue(), desc.SubregLength.intValue(), desc.SubregMask.longValue(), desc.SubregShift.intValue());
    }

    @Override
    public int getIndexByName(String name) {
        WinDef.ULONGByReference pulIndex = new WinDef.ULONGByReference();
        WinNT.HRESULT hr = this.jnaRegisters.GetIndexByName(name, pulIndex);
        if (hr.equals((Object)COMUtilsExtra.E_NOINTERFACE)) {
            return -1;
        }
        COMUtils.checkRC((WinNT.HRESULT)hr);
        return pulIndex.getValue().intValue();
    }

    @Override
    public DebugValue getValue(int index) {
        WinDef.ULONG ulIndex = new WinDef.ULONG((long)index);
        DbgEngNative.DEBUG_VALUE.ByReference dvVal = new DbgEngNative.DEBUG_VALUE.ByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaRegisters.GetValue(ulIndex, dvVal));
        return dvVal.convertTo(DebugValue.class);
    }

    protected void doGetValues(DebugRegisters.DebugRegisterSource source, WinDef.ULONG ulCount, WinDef.ULONG[] pulIndices, DbgEngNative.DEBUG_VALUE[] pValues) {
        if (source != DebugRegisters.DebugRegisterSource.DEBUG_REGSRC_DEBUGGEE) {
            throw new IllegalArgumentException("This interface only permits DEBUG_REGSRC_DEBUGGEE");
        }
        COMUtils.checkRC((WinNT.HRESULT)this.jnaRegisters.GetValues(ulCount, pulIndices, new WinDef.ULONG(0L), pValues));
    }

    @Override
    public Map<Integer, DebugValue> getValues(DebugRegisters.DebugRegisterSource source, Collection<Integer> indices) {
        if (source != DebugRegisters.DebugRegisterSource.DEBUG_REGSRC_DEBUGGEE) {
            throw new IllegalArgumentException("This interface only permits DEBUG_REGSRC_DEBUGGEE");
        }
        if (indices.isEmpty()) {
            return Collections.emptyMap();
        }
        ArrayList<Integer> li = new ArrayList<Integer>(indices);
        WinDef.ULONG ulCount = new WinDef.ULONG((long)li.size());
        WinDef.ULONG[] pulIndices = new WinDef.ULONG[li.size()];
        DbgEngNative.DEBUG_VALUE[] pValues = (DbgEngNative.DEBUG_VALUE[])new DbgEngNative.DEBUG_VALUE().toArray(li.size());
        for (int i = 0; i < indices.size(); ++i) {
            pulIndices[i] = new WinDef.ULONG((long)((Integer)li.get(i)).intValue());
        }
        this.doGetValues(source, ulCount, pulIndices, pValues);
        LinkedHashMap<Integer, DebugValue> result = new LinkedHashMap<Integer, DebugValue>();
        for (int i = 0; i < li.size(); ++i) {
            result.put((Integer)li.get(i), pValues[i].convertTo(DebugValue.class));
        }
        return result;
    }

    @Override
    public void setValue(int index, DebugValue value) {
        WinDef.ULONG ulIndex = new WinDef.ULONG((long)index);
        DbgEngNative.DEBUG_VALUE.ByReference dvVal = new DbgEngNative.DEBUG_VALUE.ByReference();
        DbgEngNative.DEBUG_VALUE.fromDebugValue(dvVal, value);
        COMUtils.checkRC((WinNT.HRESULT)this.jnaRegisters.SetValue(ulIndex, dvVal));
    }

    protected void doSetValues(DebugRegisters.DebugRegisterSource source, WinDef.ULONG ulCount, WinDef.ULONG[] pulIndices, DbgEngNative.DEBUG_VALUE[] pValues) {
        if (source != DebugRegisters.DebugRegisterSource.DEBUG_REGSRC_DEBUGGEE) {
            throw new IllegalArgumentException("This interface only permits DEBUG_REGSRC_DEBUGGEE");
        }
        COMUtils.checkRC((WinNT.HRESULT)this.jnaRegisters.SetValues(ulCount, pulIndices, new WinDef.ULONG(0L), pValues));
    }

    @Override
    public void setValues(DebugRegisters.DebugRegisterSource source, Map<Integer, DebugValue> values) {
        if (values.isEmpty()) {
            return;
        }
        WinDef.ULONG ulCount = new WinDef.ULONG((long)values.size());
        WinDef.ULONG[] pulIndices = new WinDef.ULONG[values.size()];
        DbgEngNative.DEBUG_VALUE[] pValues = (DbgEngNative.DEBUG_VALUE[])new DbgEngNative.DEBUG_VALUE().toArray(values.size());
        int i = 0;
        for (Map.Entry<Integer, DebugValue> ent : values.entrySet()) {
            pulIndices[i] = new WinDef.ULONG((long)ent.getKey().intValue());
            DbgEngNative.DEBUG_VALUE.fromDebugValue(pValues[i], ent.getValue());
            ++i;
        }
        this.doSetValues(source, ulCount, pulIndices, pValues);
    }
}

