/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.manager.cmd;

import agent.dbgeng.dbgeng.DebugControl;
import agent.dbgeng.dbgeng.DebugExceptionFilterInformation;
import agent.dbgeng.dbgeng.DebugFilterInformation;
import agent.dbgeng.jna.dbgeng.DbgEngNative;
import agent.dbgeng.manager.DbgExceptionFilter;
import agent.dbgeng.manager.cmd.AbstractDbgCommand;
import agent.dbgeng.manager.cmd.DbgPendingCommand;
import agent.dbgeng.manager.impl.DbgExceptionFilterImpl;
import agent.dbgeng.manager.impl.DbgManagerImpl;
import java.util.ArrayList;
import java.util.List;

public class DbgListExceptionFiltersCommand
extends AbstractDbgCommand<List<DbgExceptionFilter>> {
    private List<DbgExceptionFilter> result;

    public DbgListExceptionFiltersCommand(DbgManagerImpl manager) {
        super(manager);
    }

    @Override
    public List<DbgExceptionFilter> complete(DbgPendingCommand<?> pending) {
        return this.result;
    }

    @Override
    public void invoke() {
        this.result = new ArrayList<DbgExceptionFilter>();
        DebugControl control = this.manager.getControl();
        DebugFilterInformation info = control.getNumberEventFilters();
        int nEvents = info.getNumberEvents();
        int nExcs = info.getNumberSpecificExceptions();
        int nExcsA = info.getNumberArbitraryExceptions();
        DebugExceptionFilterInformation exc = control.getExceptionFilterParameters(nEvents, null, nExcs);
        for (int i = 0; i < exc.getParameters().length; ++i) {
            DbgEngNative.DEBUG_EXCEPTION_FILTER_PARAMETERS p = exc.getParameter(i);
            String text = control.getEventFilterText(nEvents + i, p.TextSize.intValue());
            String cmd = control.getEventFilterCommand(nEvents + i, p.CommandSize.intValue());
            String cmd2 = control.getExceptionFilterSecondCommand(nEvents + i, p.SecondCommandSize.intValue());
            DbgExceptionFilterImpl filter = new DbgExceptionFilterImpl(i, text, cmd, cmd2, p.ExecutionOption.intValue(), p.ContinueOption.intValue(), p.ExceptionCode.longValue());
            this.result.add(filter);
        }
        if (nExcsA > 0) {
            DebugExceptionFilterInformation excA = control.getExceptionFilterParameters(nEvents + nExcs, null, nExcsA);
            for (int i = 0; i < excA.getParameters().length; ++i) {
                DbgEngNative.DEBUG_EXCEPTION_FILTER_PARAMETERS p = excA.getParameter(i);
                String text = Long.toHexString(p.ExceptionCode.longValue());
                String cmd = control.getEventFilterCommand(nEvents + nExcs + i, p.CommandSize.intValue());
                String cmd2 = control.getExceptionFilterSecondCommand(nEvents + nExcs + i, p.SecondCommandSize.intValue());
                DbgExceptionFilterImpl filter = new DbgExceptionFilterImpl(i, text, cmd, cmd2, p.ExecutionOption.intValue(), p.ContinueOption.intValue(), p.ExceptionCode.longValue());
                this.result.add(filter);
            }
        }
    }
}

