/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.model.impl;

import agent.dbgeng.dbgeng.DebugThreadId;
import agent.dbgeng.manager.DbgCause;
import agent.dbgeng.manager.DbgProcess;
import agent.dbgeng.manager.DbgReason;
import agent.dbgeng.manager.DbgState;
import agent.dbgeng.manager.DbgThread;
import agent.dbgeng.manager.reason.DbgEndSteppingRangeReason;
import agent.dbgeng.manager.reason.DbgExitNormallyReason;
import agent.dbgeng.manager.reason.DbgExitedReason;
import agent.dbgeng.manager.reason.DbgSignalReceivedReason;
import agent.dbgeng.model.iface1.DbgModelTargetConfigurable;
import agent.dbgeng.model.iface2.DbgModelTargetProcess;
import agent.dbgeng.model.iface2.DbgModelTargetThread;
import agent.dbgeng.model.iface2.DbgModelTargetThreadContainer;
import agent.dbgeng.model.impl.DbgModelImpl;
import agent.dbgeng.model.impl.DbgModelTargetObjectImpl;
import agent.dbgeng.model.impl.DbgModelTargetProcessImpl;
import agent.dbgeng.model.impl.DbgModelTargetThreadImpl;
import ghidra.async.AsyncUtils;
import ghidra.dbg.DebuggerModelListener;
import ghidra.dbg.error.DebuggerIllegalArgumentException;
import ghidra.dbg.target.TargetEventScope;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.TargetThread;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

@TargetObjectSchemaInfo(name="ThreadContainer", elements={@TargetElementType(type=DbgModelTargetThreadImpl.class)}, attributes={@TargetAttributeType(name="_base", type=Integer.class), @TargetAttributeType(type=Void.class)}, canonicalContainer=true)
public class DbgModelTargetThreadContainerImpl
extends DbgModelTargetObjectImpl
implements DbgModelTargetThreadContainer,
DbgModelTargetConfigurable {
    protected final DbgProcess process;

    public DbgModelTargetThreadContainerImpl(DbgModelTargetProcessImpl process) {
        super(process.getModel(), (TargetObject)process, "Threads", "ThreadContainer");
        this.process = process.process;
        this.changeAttributes(List.of(), Map.of("_base", 16), "Initialized");
        this.getManager().addEventsListener(this);
        this.requestElements(false);
    }

    @Override
    public void threadCreated(DbgThread thread) {
        this.changeElements(List.of(), List.of(this.getTargetThread(thread)), Map.of(), "Created");
        DbgModelTargetThread targetThread = this.getTargetThread(thread);
        this.changeElements(List.of(), List.of(targetThread), Map.of(), "Created");
        targetThread.threadStateChangedSpecific(DbgState.STARTING, DbgReason.getReason(null));
        ((DebuggerModelListener)this.getListeners().fire).event((TargetObject)this.getProxy(), (TargetThread)targetThread, TargetEventScope.TargetEventType.THREAD_CREATED, "Thread " + thread.getId() + " started", List.of(targetThread));
    }

    @Override
    public void threadStateChanged(DbgThread thread, DbgState state, DbgCause cause, DbgReason reason) {
        DbgModelTargetThread targetThread = this.getTargetThread(thread);
        TargetEventScope.TargetEventType eventType = this.getEventType(state, cause, reason);
        ((DebuggerModelListener)this.getListeners().fire).event((TargetObject)this.getProxy(), (TargetThread)targetThread, eventType, "Thread " + thread.getId() + " state changed", List.of(targetThread));
        targetThread.threadStateChangedSpecific(state, reason);
    }

    @Override
    public void threadExited(DebugThreadId threadId) {
        DbgModelImpl impl = (DbgModelImpl)this.model;
        DbgModelTargetThread targetThread = (DbgModelTargetThread)impl.getModelObject(threadId);
        if (targetThread != null) {
            ((DebuggerModelListener)this.getListeners().fire).event((TargetObject)this.getProxy(), (TargetThread)targetThread, TargetEventScope.TargetEventType.THREAD_EXITED, "Thread " + threadId + " exited", List.of(targetThread));
        }
        this.changeElements(List.of(DbgModelTargetThreadImpl.indexThread(threadId)), List.of(), Map.of(), "Exited");
    }

    private TargetEventScope.TargetEventType getEventType(DbgState state, DbgCause cause, DbgReason reason) {
        switch (state) {
            case RUNNING: {
                return TargetEventScope.TargetEventType.RUNNING;
            }
            case STOPPED: 
            case EXIT: {
                if (reason instanceof DbgEndSteppingRangeReason) {
                    return TargetEventScope.TargetEventType.STEP_COMPLETED;
                }
                if (reason instanceof DbgSignalReceivedReason) {
                    return TargetEventScope.TargetEventType.SIGNAL;
                }
                if (reason instanceof DbgExitedReason) {
                    return TargetEventScope.TargetEventType.EXCEPTION;
                }
                if (reason instanceof DbgExitNormallyReason) {
                    return TargetEventScope.TargetEventType.THREAD_EXITED;
                }
                return TargetEventScope.TargetEventType.STOPPED;
            }
        }
        return null;
    }

    public CompletableFuture<Void> requestElements(boolean refresh) {
        return this.process.listThreads().thenAccept(byTID -> {
            List threads;
            DbgModelTargetThreadContainerImpl dbgModelTargetThreadContainerImpl = this;
            synchronized (dbgModelTargetThreadContainerImpl) {
                threads = byTID.values().stream().map(this::getTargetThread).collect(Collectors.toList());
            }
            this.setElements(threads, Map.of(), "Refreshed");
        });
    }

    @Override
    public synchronized DbgModelTargetThread getTargetThread(DbgThread thread) {
        DbgModelImpl impl = (DbgModelImpl)this.model;
        TargetObject modelObject = impl.getModelObject(thread);
        if (modelObject != null) {
            return (DbgModelTargetThread)modelObject;
        }
        return new DbgModelTargetThreadImpl(this, (DbgModelTargetProcess)this.parent, thread);
    }

    public CompletableFuture<Void> writeConfigurationOption(String key, Object value) {
        switch (key) {
            case "_base": {
                if (value instanceof Integer) {
                    this.changeAttributes(List.of(), Map.of("_base", value), "Modified");
                    for (TargetObject child : this.getCachedElements().values()) {
                        if (!(child instanceof DbgModelTargetThreadImpl)) continue;
                        DbgModelTargetThreadImpl targetThread = (DbgModelTargetThreadImpl)child;
                        targetThread.setBase(value);
                    }
                    break;
                }
                throw new DebuggerIllegalArgumentException("Base should be numeric");
            }
        }
        return AsyncUtils.NIL;
    }
}

