/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.projectdata.actions;

import docking.action.ContextSpecificAction;
import docking.action.MenuData;
import docking.widgets.tree.GTreeNode;
import ghidra.framework.main.datatable.ProjectTreeContext;
import ghidra.framework.main.datatree.DataTree;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.util.InvalidNameException;
import ghidra.util.Swing;
import ghidra.util.exception.AssertException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import resources.ResourceManager;

public class ProjectDataNewFolderAction<T extends ProjectTreeContext>
extends ContextSpecificAction<T> {
    private static Icon icon = ResourceManager.loadImage((String)"images/folder_add.png");

    public ProjectDataNewFolderAction(String owner, String group, Class<T> contextClass) {
        super("New Folder", owner, contextClass);
        this.setPopupMenuData(new MenuData(new String[]{"New Folder"}, icon, group));
        this.markHelpUnnecessary();
    }

    protected void actionPerformed(T context) {
        this.createNewFolder(context);
    }

    public boolean isAddToPopup(T context) {
        return context.getFolderCount() + context.getFileCount() == 1;
    }

    private void createNewFolder(T context) {
        DomainFolder parentFolder = this.getFolder(context);
        DomainFolder newFolder = this.createNewFolderWithDefaultName(parentFolder);
        DataTree tree = context.getTree();
        Swing.runLater(() -> {
            GTreeNode node = this.findNodeForFolder(tree, newFolder);
            if (node != null) {
                tree.setEditable(true);
                tree.startEditing(node.getParent(), node.getName());
            }
        });
    }

    private DomainFolder createNewFolderWithDefaultName(DomainFolder parentFolder) {
        String name = this.getNewFolderName(parentFolder);
        try {
            return parentFolder.createFolder(name);
        }
        catch (InvalidNameException | IOException e) {
            throw new AssertException("Unexpected Error creating new folder: " + name, e);
        }
    }

    private static final void getFolderPath(DomainFolder folder, List<String> folderPathList) {
        if (folder.getParent() != null) {
            ProjectDataNewFolderAction.getFolderPath(folder.getParent(), folderPathList);
            folderPathList.add(folder.getName());
        }
    }

    private GTreeNode findNodeForFolder(DataTree tree, DomainFolder newFolder) {
        ArrayList<String> folderPathList = new ArrayList<String>();
        ProjectDataNewFolderAction.getFolderPath(newFolder, folderPathList);
        GTreeNode node = tree.getModelRoot();
        for (int i = 0; node != null && i < folderPathList.size(); node = node.getChild((String)folderPathList.get(i)), ++i) {
        }
        return node;
    }

    private String getNewFolderName(DomainFolder parent) {
        String baseName = "NewFolder";
        Object name = baseName;
        int suffix = 1;
        while (parent.getFolder((String)name) != null) {
            name = baseName + ++suffix;
        }
        return name;
    }

    private DomainFolder getFolder(T context) {
        if (context.getFolderCount() > 0) {
            return context.getSelectedFolders().get(0);
        }
        DomainFile file = context.getSelectedFiles().get(0);
        return file.getParent();
    }
}

