/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.protocol.ghidra;

import ghidra.framework.client.NotConnectedException;
import ghidra.framework.client.RepositoryAdapter;
import ghidra.framework.model.ProjectLocator;
import ghidra.framework.protocol.ghidra.GhidraProtocolConnector;
import ghidra.framework.protocol.ghidra.GhidraURL;
import ghidra.framework.store.FileSystem;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

public class DefaultLocalGhidraProtocolConnector
extends GhidraProtocolConnector {
    private ProjectLocator localStorageLocator;
    private boolean readOnly;

    DefaultLocalGhidraProtocolConnector(URL ghidraURL) throws MalformedURLException {
        super(ghidraURL);
        try {
            this.localStorageLocator = GhidraURL.getProjectStorageLocator(ghidraURL);
        }
        catch (IllegalArgumentException e) {
            throw new MalformedURLException(e.getMessage());
        }
    }

    @Override
    protected void checkHostInfo() throws MalformedURLException {
        String host = this.url.getHost();
        if (host.length() != 0) {
            throw new MalformedURLException("unsupported host specification");
        }
    }

    @Override
    protected String parseRepositoryName() throws MalformedURLException {
        return null;
    }

    @Override
    protected String parseItemPath() throws MalformedURLException {
        this.folderPath = FileSystem.SEPARATOR;
        this.folderItemName = null;
        return this.folderPath;
    }

    @Override
    protected void connect(RepositoryAdapter repository) throws IOException {
        throw new UnsupportedOperationException("local project access only");
    }

    public ProjectLocator getLocalProjectLocator() {
        return this.localStorageLocator;
    }

    @Override
    protected URL getRepositoryRootGhidraURL() {
        return null;
    }

    @Override
    public boolean isReadOnly() throws NotConnectedException {
        if (this.responseCode == -1) {
            throw new NotConnectedException("not connected");
        }
        return this.readOnly;
    }

    @Override
    public int connect(boolean readOnlyAccess) throws IOException {
        this.readOnly = readOnlyAccess;
        this.responseCode = !this.localStorageLocator.exists() ? 404 : 200;
        return this.responseCode;
    }
}

