/*
 * Decompiled with CFR 0.152.
 */
package ghidra.xml;

import ghidra.xml.XmlElement;
import ghidra.xml.XmlException;
import java.util.LinkedHashMap;
import java.util.Map;

public class XmlElementImpl
implements XmlElement {
    private final String name;
    private final int level;
    private final LinkedHashMap<String, String> attributes;
    private final String text;
    private final boolean isStart;
    private final boolean isEnd;
    private final boolean isContent;
    private final int columnNumber;
    private final int lineNumber;

    public XmlElementImpl(boolean isStart, boolean isEnd, String name, int level, LinkedHashMap<String, String> attributes, String text, int columnNumber, int lineNumber) {
        if (isStart && isEnd) {
            throw new XmlException("empty elements must be split into separate start and end elements (see splitEmptyElement)");
        }
        this.name = name;
        this.level = level;
        this.attributes = attributes;
        this.text = text;
        this.isStart = isStart;
        this.isEnd = isEnd;
        this.isContent = !isStart && !isEnd;
        this.columnNumber = columnNumber;
        this.lineNumber = lineNumber;
    }

    @Override
    public int getColumnNumber() {
        return this.columnNumber;
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public boolean hasAttribute(String key) {
        if (this.attributes == null) {
            return false;
        }
        return this.attributes.containsKey(key);
    }

    @Override
    public String getAttribute(String key) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(key);
    }

    public LinkedHashMap<String, String> getAttributes() {
        return this.attributes == null ? null : new LinkedHashMap<String, String>(this.attributes);
    }

    @Override
    public void setAttribute(String key, String value) {
        this.attributes.put(key, value);
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public boolean isContent() {
        return this.isContent;
    }

    @Override
    public boolean isEnd() {
        return this.isEnd;
    }

    @Override
    public boolean isStart() {
        return this.isStart;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.isContent) {
            if (this.text == null) {
                sb.append("(null)");
            } else {
                sb.append(this.text.replaceAll("\\\n", "\\\\n"));
            }
        } else if (this.isStart) {
            sb.append('<');
            sb.append(this.name);
            sb.append('(');
            sb.append(this.level);
            sb.append(')');
            String sep = " ";
            if (this.attributes != null) {
                for (Map.Entry<String, String> attribute : this.attributes.entrySet()) {
                    sb.append(sep);
                    sb.append(attribute.getKey());
                    sb.append("=\"");
                    sb.append(attribute.getValue());
                    sb.append('\"');
                }
            }
            sb.append('>');
        } else if (this.isEnd) {
            if (this.text == null) {
                sb.append("(null)");
            } else {
                sb.append(this.text.replaceAll("\\\n", "\\\\n"));
            }
            sb.append("</");
            sb.append(this.name);
            sb.append('(');
            sb.append(this.level);
            sb.append(')');
            sb.append('>');
        }
        sb.append(" @(");
        sb.append(this.lineNumber);
        sb.append(":");
        sb.append(this.columnNumber);
        sb.append(")");
        return sb.toString();
    }

    public static XmlElement[] splitEmptyElement(XmlElementImpl element) {
        XmlElement[] result = element.isStart() && element.isEnd() ? new XmlElement[]{new XmlElementImpl(true, false, element.getName(), element.getLevel(), (LinkedHashMap<String, String>)element.getAttributes(), null, element.getColumnNumber(), element.getLineNumber()), new XmlElementImpl(false, true, element.getName(), element.getLevel(), null, "", element.getColumnNumber(), element.getLineNumber())} : new XmlElement[]{element};
        return result;
    }
}

