/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core;

import java.io.IOException;
import java.io.OutputStream;

public final class NoThrowOutputStream
extends OutputStream {
    private final OutputStream underlying;
    private long bytesWritten = 0L;

    public NoThrowOutputStream(OutputStream underlying) {
        this.underlying = underlying;
    }

    @Override
    public void close() {
        throw new UnsupportedOperationException("don't call close()");
    }

    @Override
    public void flush() {
        try {
            this.underlying.flush();
        }
        catch (IOException ex) {
            throw new HiddenException(ex);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) {
        try {
            this.bytesWritten += (long)len;
            this.underlying.write(b, off, len);
        }
        catch (IOException ex) {
            throw new HiddenException(ex);
        }
    }

    @Override
    public void write(byte[] b) {
        try {
            this.bytesWritten += (long)b.length;
            this.underlying.write(b);
        }
        catch (IOException ex) {
            throw new HiddenException(ex);
        }
    }

    @Override
    public void write(int b) {
        try {
            ++this.bytesWritten;
            this.underlying.write(b);
        }
        catch (IOException ex) {
            throw new HiddenException(ex);
        }
    }

    public long getBytesWritten() {
        return this.bytesWritten;
    }

    public static final class HiddenException
    extends RuntimeException {
        public final IOException underlying;
        public static final long serialVersionUID = 0L;

        public HiddenException(IOException underlying) {
            super(underlying);
            this.underlying = underlying;
        }
    }
}

