/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Code;

import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.Code.Opcode;
import org.jf.dexlib.Code.ReferenceType;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.FieldIdItem;
import org.jf.dexlib.Item;
import org.jf.dexlib.MethodIdItem;
import org.jf.dexlib.StringIdItem;
import org.jf.dexlib.TypeIdItem;
import org.jf.dexlib.Util.NumberUtils;

public abstract class InstructionWithReference
extends Instruction {
    private Item referencedItem;
    private ReferenceType referenceType;

    protected InstructionWithReference(Opcode opcode, Item referencedItem) {
        super(opcode);
        this.referencedItem = referencedItem;
        this.referenceType = opcode.referenceType;
        this.checkReferenceType();
    }

    protected InstructionWithReference(Opcode opcode, Item referencedItem, ReferenceType referenceType) {
        super(opcode);
        this.referencedItem = referencedItem;
        this.referenceType = referenceType;
        this.checkReferenceType();
    }

    protected InstructionWithReference(DexFile dexFile, Opcode opcode, byte[] buffer, int bufferIndex) {
        super(opcode);
        this.referenceType = this.readReferenceType(opcode, buffer, bufferIndex);
        int itemIndex = this.getReferencedItemIndex(buffer, bufferIndex);
        this.lookupReferencedItem(dexFile, opcode, itemIndex);
    }

    protected int getReferencedItemIndex(byte[] buffer, int bufferIndex) {
        return NumberUtils.decodeUnsignedShort(buffer, bufferIndex + 2);
    }

    public ReferenceType getReferenceType() {
        return this.referenceType;
    }

    public Item getReferencedItem() {
        return this.referencedItem;
    }

    protected ReferenceType readReferenceType(Opcode opcode, byte[] buffer, int bufferIndex) {
        return opcode.referenceType;
    }

    private void lookupReferencedItem(DexFile dexFile, Opcode opcode, int itemIndex) {
        switch (this.referenceType) {
            case field: {
                this.referencedItem = dexFile.FieldIdsSection.getItemByIndex(itemIndex);
                return;
            }
            case method: {
                this.referencedItem = dexFile.MethodIdsSection.getItemByIndex(itemIndex);
                return;
            }
            case type: {
                this.referencedItem = dexFile.TypeIdsSection.getItemByIndex(itemIndex);
                return;
            }
            case string: {
                this.referencedItem = dexFile.StringIdsSection.getItemByIndex(itemIndex);
            }
        }
    }

    private void checkReferenceType() {
        switch (this.referenceType) {
            case field: {
                if (!(this.referencedItem instanceof FieldIdItem)) {
                    throw new RuntimeException(this.referencedItem.getClass().getSimpleName() + " is the wrong item type for opcode " + this.opcode.name + ". Expecting FieldIdItem.");
                }
                return;
            }
            case method: {
                if (!(this.referencedItem instanceof MethodIdItem)) {
                    throw new RuntimeException(this.referencedItem.getClass().getSimpleName() + " is the wrong item type for opcode " + this.opcode.name + ". Expecting MethodIdItem.");
                }
                return;
            }
            case type: {
                if (!(this.referencedItem instanceof TypeIdItem)) {
                    throw new RuntimeException(this.referencedItem.getClass().getSimpleName() + " is the wrong item type for opcode " + this.opcode.name + ". Expecting TypeIdItem.");
                }
                return;
            }
            case string: {
                if (!(this.referencedItem instanceof StringIdItem)) {
                    throw new RuntimeException(this.referencedItem.getClass().getSimpleName() + " is the wrong item type for opcode " + this.opcode.name + ". Expecting StringIdItem.");
                }
                return;
            }
        }
        if (this.referencedItem != null) {
            throw new RuntimeException(this.referencedItem.getClass().getSimpleName() + " is invalid for opcode " + this.opcode.name + ". This opcode does not reference an item");
        }
    }
}

