/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functiongraph.graph.vertex;

import docking.widgets.fieldpanel.FieldPanel;
import docking.widgets.fieldpanel.Layout;
import docking.widgets.fieldpanel.LayoutModel;
import ghidra.app.plugin.core.functiongraph.FGColorProvider;
import ghidra.app.plugin.core.functiongraph.graph.vertex.FGVertexListingModel;
import ghidra.app.plugin.core.functiongraph.mvc.FGController;
import ghidra.app.plugin.core.functiongraph.mvc.FunctionGraphOptions;
import ghidra.app.util.viewer.format.FormatManager;
import ghidra.app.util.viewer.listingpanel.ListingModel;
import ghidra.app.util.viewer.listingpanel.ListingModelAdapter;
import ghidra.app.util.viewer.listingpanel.ListingModelListener;
import ghidra.app.util.viewer.listingpanel.ListingPanel;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import java.awt.Color;
import java.awt.Dimension;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class FGVertexListingPanel
extends ListingPanel {
    private ListingModelListener listener = new ListingModelListener(){

        public void dataChanged(boolean updateImmediately) {
            FGVertexListingPanel.this.getFieldPanel().invalidate();
            FGVertexListingPanel.this.controller.repaint();
        }

        public void modelSizeChanged() {
        }
    };
    private FGController controller;
    private AddressSetView addressSetView;
    private Dimension preferredSizeCache;
    private Dimension lastParentPreferredSize;

    FGVertexListingPanel(FGController controller, FormatManager formatManager, Program program, AddressSetView view) {
        super(formatManager);
        this.controller = controller;
        this.addressSetView = view;
        this.setNeverSroll();
        this.setProgram(program);
        ListingModel model = this.getListingModel();
        model.addListener(this.listener);
        FunctionGraphOptions options = controller.getFunctionGraphOptions();
        Color color = options.getDefaultVertexBackgroundColor();
        this.setTextBackgroundColor(color);
        FGColorProvider colorProvider = controller.getColorProvider();
        if (!colorProvider.isUsingCustomColors()) {
            this.enablePropertyBasedColorModel(true);
        }
    }

    public void setView(AddressSetView view) {
        this.addressSetView = view;
        super.setView(view);
    }

    protected ListingModel createListingModel(Program program) {
        return new FGVertexListingModel(program, this.getFormatManager());
    }

    protected ListingModelAdapter createLayoutModel(ListingModel model) {
        ListingModelAdapter adapter = super.createLayoutModel(model);
        if (model != null) {
            adapter.setAddressSet(this.addressSetView);
        }
        return adapter;
    }

    protected FieldPanel createFieldPanel(LayoutModel model) {
        return new FGVertexFieldPanel(model);
    }

    public Dimension getPreferredSize() {
        Dimension preferredSize = super.getPreferredSize();
        int maxWidth = this.getFormatManager().getMaxWidth();
        if (preferredSize.width < maxWidth) {
            preferredSize.width += 10;
        }
        return preferredSize;
    }

    protected int getNewWindowDefaultWidth() {
        return 0;
    }

    public void refreshModel() {
        FGVertexListingModel fgModel = (FGVertexListingModel)this.getListingModel();
        if (fgModel.refresh()) {
            this.preferredSizeCache = null;
        }
    }

    private class FGVertexFieldPanel
    extends FieldPanel {
        public FGVertexFieldPanel(LayoutModel model) {
            super(model);
        }

        public Dimension getPreferredSize() {
            Dimension preferredSize = super.getPreferredSize();
            if (preferredSize.equals(FGVertexListingPanel.this.lastParentPreferredSize) && FGVertexListingPanel.this.preferredSizeCache != null) {
                return FGVertexListingPanel.this.preferredSizeCache;
            }
            FGVertexListingPanel.this.lastParentPreferredSize = preferredSize;
            LayoutModel layoutModel = this.getLayoutModel();
            List<Layout> layouts = this.getAllLayouts(layoutModel);
            int largestWidth = 0;
            for (Layout layout : layouts) {
                int width = layout.getCompressableWidth();
                if (width <= largestWidth) continue;
                largestWidth = width;
            }
            preferredSize.width = largestWidth;
            FGVertexListingPanel.this.preferredSizeCache = preferredSize;
            return preferredSize;
        }

        private List<Layout> getAllLayouts(LayoutModel layoutModel) {
            ArrayList<Layout> list = new ArrayList<Layout>();
            BigInteger index = BigInteger.ZERO;
            Layout layout = layoutModel.getLayout(index);
            while (layout != null) {
                list.add(layout);
                index = layoutModel.getIndexAfter(index);
                layout = layoutModel.getLayout(index);
            }
            return list;
        }
    }
}

