/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.ssh2.transport;

import ch.ethz.ssh2.ConnectionInfo;
import ch.ethz.ssh2.auth.ServerAuthenticationManager;
import ch.ethz.ssh2.crypto.cipher.BlockCipher;
import ch.ethz.ssh2.crypto.cipher.BlockCipherFactory;
import ch.ethz.ssh2.crypto.dh.DhExchange;
import ch.ethz.ssh2.crypto.digest.MAC;
import ch.ethz.ssh2.packets.PacketKexDHInit;
import ch.ethz.ssh2.packets.PacketKexDHReply;
import ch.ethz.ssh2.packets.PacketKexInit;
import ch.ethz.ssh2.server.ServerConnectionState;
import ch.ethz.ssh2.signature.DSASHA1Verify;
import ch.ethz.ssh2.signature.DSASignature;
import ch.ethz.ssh2.signature.RSASHA1Verify;
import ch.ethz.ssh2.signature.RSASignature;
import ch.ethz.ssh2.transport.KexManager;
import ch.ethz.ssh2.transport.KexState;
import java.io.IOException;

public class ServerKexManager
extends KexManager {
    private final ServerConnectionState state;
    private boolean authenticationStarted = false;

    public ServerKexManager(ServerConnectionState state) {
        super(state.tm, state.csh, state.next_cryptoWishList, state.generator);
        this.state = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleMessage(byte[] msg, int msglen) throws IOException {
        if (msg == null) {
            Object object = this.accessLock;
            synchronized (object) {
                this.connectionClosed = true;
                this.accessLock.notifyAll();
                return;
            }
        }
        if (this.kxs == null && msg[0] != 20) {
            throw new IOException("Unexpected KEX message (type " + msg[0] + ")");
        }
        if (this.ignore_next_kex_packet) {
            this.ignore_next_kex_packet = false;
            return;
        }
        if (msg[0] == 20) {
            PacketKexInit kip;
            if (this.kxs != null && this.kxs.state != 0) {
                throw new IOException("Unexpected SSH_MSG_KEXINIT message during on-going kex exchange!");
            }
            if (this.kxs == null) {
                this.kxs = new KexState();
                this.kxs.local_dsa_key = this.nextKEXdsakey;
                this.kxs.local_rsa_key = this.nextKEXrsakey;
                this.kxs.dhgexParameters = this.nextKEXdhgexParameters;
                this.kxs.localKEX = kip = new PacketKexInit(this.nextKEXcryptoWishList, this.rnd);
                this.tm.sendKexMessage(kip.getPayload());
            }
            this.kxs.remoteKEX = kip = new PacketKexInit(msg, 0, msglen);
            this.kxs.np = this.mergeKexParameters(this.kxs.remoteKEX.getKexParameters(), this.kxs.localKEX.getKexParameters());
            if (this.kxs.np == null) {
                throw new IOException("Cannot negotiate, proposals do not match.");
            }
            if (this.kxs.remoteKEX.isFirst_kex_packet_follows() && !this.kxs.np.guessOK) {
                this.ignore_next_kex_packet = true;
            }
            if (this.kxs.np.kex_algo.equals("diffie-hellman-group1-sha1") || this.kxs.np.kex_algo.equals("diffie-hellman-group14-sha1")) {
                this.kxs.dhx = new DhExchange();
                if (this.kxs.np.kex_algo.equals("diffie-hellman-group1-sha1")) {
                    this.kxs.dhx.serverInit(1, this.rnd);
                } else {
                    this.kxs.dhx.serverInit(14, this.rnd);
                }
                this.kxs.state = 1;
                return;
            }
            throw new IllegalStateException("Unkown KEX method!");
        }
        if (msg[0] == 21) {
            MAC mac;
            BlockCipher cbc;
            if (this.km == null) {
                throw new IOException("Peer sent SSH_MSG_NEWKEYS, but I have no key material ready!");
            }
            try {
                cbc = BlockCipherFactory.createCipher(this.kxs.np.enc_algo_client_to_server, false, this.km.enc_key_client_to_server, this.km.initial_iv_client_to_server);
                mac = new MAC(this.kxs.np.mac_algo_client_to_server, this.km.integrity_key_client_to_server);
            }
            catch (IllegalArgumentException e1) {
                throw new IOException("Fatal error during MAC startup!");
            }
            this.tm.changeRecvCipher(cbc, mac);
            ConnectionInfo sci = new ConnectionInfo();
            ++this.kexCount;
            sci.keyExchangeAlgorithm = this.kxs.np.kex_algo;
            sci.keyExchangeCounter = this.kexCount;
            sci.clientToServerCryptoAlgorithm = this.kxs.np.enc_algo_client_to_server;
            sci.serverToClientCryptoAlgorithm = this.kxs.np.enc_algo_server_to_client;
            sci.clientToServerMACAlgorithm = this.kxs.np.mac_algo_client_to_server;
            sci.serverToClientMACAlgorithm = this.kxs.np.mac_algo_server_to_client;
            sci.serverHostKeyAlgorithm = this.kxs.np.server_host_key_algo;
            sci.serverHostKey = this.kxs.remote_hostkey;
            Object object = this.accessLock;
            synchronized (object) {
                this.lastConnInfo = sci;
                this.accessLock.notifyAll();
            }
            this.kxs = null;
            return;
        }
        if (this.kxs == null || this.kxs.state == 0) {
            throw new IOException("Unexpected Kex submessage!");
        }
        if ((this.kxs.np.kex_algo.equals("diffie-hellman-group1-sha1") || this.kxs.np.kex_algo.equals("diffie-hellman-group14-sha1")) && this.kxs.state == 1) {
            PacketKexDHInit dhi = new PacketKexDHInit(msg, 0, msglen);
            this.kxs.dhx.setE(dhi.getE());
            byte[] hostKey = null;
            if (this.kxs.np.server_host_key_algo.equals("ssh-rsa")) {
                hostKey = RSASHA1Verify.encodeSSHRSAPublicKey(this.kxs.local_rsa_key.getPublicKey());
            }
            if (this.kxs.np.server_host_key_algo.equals("ssh-dss")) {
                hostKey = DSASHA1Verify.encodeSSHDSAPublicKey(this.kxs.local_dsa_key.getPublicKey());
            }
            try {
                this.kxs.H = this.kxs.dhx.calculateH(this.csh.getClientString(), this.csh.getServerString(), this.kxs.remoteKEX.getPayload(), this.kxs.localKEX.getPayload(), hostKey);
            }
            catch (IllegalArgumentException e) {
                throw new IOException("KEX error.", e);
            }
            this.kxs.K = this.kxs.dhx.getK();
            byte[] signature = null;
            if (this.kxs.np.server_host_key_algo.equals("ssh-rsa")) {
                RSASignature rs = RSASHA1Verify.generateSignature(this.kxs.H, this.kxs.local_rsa_key);
                signature = RSASHA1Verify.encodeSSHRSASignature(rs);
            }
            if (this.kxs.np.server_host_key_algo.equals("ssh-dss")) {
                DSASignature ds = DSASHA1Verify.generateSignature(this.kxs.H, this.kxs.local_dsa_key, this.rnd);
                signature = DSASHA1Verify.encodeSSHDSASignature(ds);
            }
            PacketKexDHReply dhr = new PacketKexDHReply(hostKey, this.kxs.dhx.getF(), signature);
            this.tm.sendKexMessage(dhr.getPayload());
            this.finishKex(false);
            this.kxs.state = -1;
            if (!this.authenticationStarted) {
                this.authenticationStarted = true;
                this.state.am = new ServerAuthenticationManager(this.state);
            }
            return;
        }
        throw new IllegalStateException("Unkown KEX method! (" + this.kxs.np.kex_algo + ")");
    }
}

