/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.ssh2.transport;

import ch.ethz.ssh2.ConnectionInfo;
import ch.ethz.ssh2.ConnectionMonitor;
import ch.ethz.ssh2.DHGexParameters;
import ch.ethz.ssh2.crypto.CryptoWishList;
import ch.ethz.ssh2.crypto.cipher.BlockCipher;
import ch.ethz.ssh2.crypto.digest.MAC;
import ch.ethz.ssh2.log.Logger;
import ch.ethz.ssh2.packets.PacketDisconnect;
import ch.ethz.ssh2.packets.TypesReader;
import ch.ethz.ssh2.signature.DSAPrivateKey;
import ch.ethz.ssh2.signature.RSAPrivateKey;
import ch.ethz.ssh2.transport.KexManager;
import ch.ethz.ssh2.transport.MessageHandler;
import ch.ethz.ssh2.transport.TransportConnection;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.List;

public abstract class TransportManager {
    private static final Logger log = Logger.getLogger(TransportManager.class);
    private final List<AsynchronousEntry> asynchronousQueue = new ArrayList<AsynchronousEntry>();
    private Thread asynchronousThread = null;
    private boolean asynchronousPending = false;
    private final Object connectionSemaphore = new Object();
    private boolean flagKexOngoing = false;
    private boolean connectionClosed = false;
    private Throwable reasonClosedCause = null;
    private TransportConnection tc;
    private KexManager km;
    private final List<HandlerEntry> messageHandlers = new ArrayList<HandlerEntry>();
    private Thread receiveThread;
    private List<ConnectionMonitor> connectionMonitors = new ArrayList<ConnectionMonitor>();
    private boolean monitorsWereInformed = false;
    private boolean idle;

    protected void init(TransportConnection tc, KexManager km) {
        this.tc = tc;
        this.km = km;
    }

    public int getPacketOverheadEstimate() {
        return this.tc.getPacketOverheadEstimate();
    }

    public ConnectionInfo getConnectionInfo(int kexNumber) throws IOException {
        return this.km.getOrWaitForConnectionInfo(kexNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Throwable getReasonClosedCause() {
        Object object = this.connectionSemaphore;
        synchronized (object) {
            return this.reasonClosedCause;
        }
    }

    public byte[] getSessionIdentifier() {
        return this.km.sessionId;
    }

    public void close(Throwable cause) {
        this.close(cause, false);
    }

    public abstract void close(Throwable var1, boolean var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(Socket sock, Throwable cause, boolean useDisconnectPacket) {
        if (!useDisconnectPacket) {
            try {
                sock.close();
            }
            catch (IOException ignore) {
                // empty catch block
            }
        }
        Object ignore = this.connectionSemaphore;
        synchronized (ignore) {
            if (!this.connectionClosed) {
                if (useDisconnectPacket) {
                    try {
                        byte[] msg = new PacketDisconnect(11, cause.getMessage(), "").getPayload();
                        if (this.tc != null) {
                            this.tc.sendMessage(msg);
                        }
                    }
                    catch (IOException ignore2) {
                        // empty catch block
                    }
                    try {
                        sock.close();
                    }
                    catch (IOException ignore3) {
                        // empty catch block
                    }
                }
                this.connectionClosed = true;
                this.reasonClosedCause = cause;
            }
            this.connectionSemaphore.notifyAll();
        }
        ArrayList<ConnectionMonitor> monitors = new ArrayList<ConnectionMonitor>();
        TransportManager ignore3 = this;
        synchronized (ignore3) {
            if (!this.monitorsWereInformed) {
                this.monitorsWereInformed = true;
                monitors.addAll(this.connectionMonitors);
            }
        }
        for (ConnectionMonitor cmon : monitors) {
            try {
                cmon.connectionLost(this.reasonClosedCause);
            }
            catch (Exception ignore4) {}
        }
    }

    protected void startReceiver() throws IOException {
        this.receiveThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    TransportManager.this.receiveLoop();
                }
                catch (IOException e) {
                    TransportManager.this.close(e);
                    log.warning("Receive thread: error in receiveLoop: " + e.getMessage());
                }
                if (log.isDebugEnabled()) {
                    log.debug("Receive thread: back from receiveLoop");
                }
                if (TransportManager.this.km != null) {
                    try {
                        TransportManager.this.km.handleMessage(null, 0);
                    }
                    catch (IOException ignored) {
                        // empty catch block
                    }
                }
                for (HandlerEntry he : TransportManager.this.messageHandlers) {
                    try {
                        he.mh.handleMessage(null, 0);
                    }
                    catch (IOException iOException) {}
                }
            }
        });
        this.receiveThread.setDaemon(true);
        this.receiveThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerMessageHandler(MessageHandler mh, int low, int high) {
        HandlerEntry he = new HandlerEntry();
        he.mh = mh;
        he.low = low;
        he.high = high;
        List<HandlerEntry> list = this.messageHandlers;
        synchronized (list) {
            this.messageHandlers.add(he);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessageHandler(MessageHandler mh, int low, int high) {
        List<HandlerEntry> list = this.messageHandlers;
        synchronized (list) {
            for (int i = 0; i < this.messageHandlers.size(); ++i) {
                HandlerEntry he = this.messageHandlers.get(i);
                if (he.mh != mh || he.low != low || he.high != high) continue;
                this.messageHandlers.remove(i);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendKexMessage(byte[] msg) throws IOException {
        Object object = this.connectionSemaphore;
        synchronized (object) {
            if (this.connectionClosed) {
                throw new IOException("Sorry, this connection is closed.", this.reasonClosedCause);
            }
            this.flagKexOngoing = true;
            try {
                this.tc.sendMessage(msg);
            }
            catch (IOException e) {
                this.close(e);
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kexFinished() throws IOException {
        Object object = this.connectionSemaphore;
        synchronized (object) {
            this.flagKexOngoing = false;
            this.connectionSemaphore.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceKeyExchange(CryptoWishList cwl, DHGexParameters dhgex, DSAPrivateKey dsa, RSAPrivateKey rsa) throws IOException {
        Object object = this.connectionSemaphore;
        synchronized (object) {
            if (this.connectionClosed) {
                throw new IOException("Sorry, this connection is closed.", this.reasonClosedCause);
            }
        }
        this.km.initiateKEX(cwl, dhgex, dsa, rsa);
    }

    public void changeRecvCipher(BlockCipher bc, MAC mac) {
        this.tc.changeRecvCipher(bc, mac);
    }

    public void changeSendCipher(BlockCipher bc, MAC mac) {
        this.tc.changeSendCipher(bc, mac);
    }

    public void sendAsynchronousMessage(byte[] msg) throws IOException {
        this.sendAsynchronousMessage(msg, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendAsynchronousMessage(byte[] msg, Runnable run) throws IOException {
        List<AsynchronousEntry> list = this.asynchronousQueue;
        synchronized (list) {
            this.asynchronousQueue.add(new AsynchronousEntry(msg, run));
            this.asynchronousPending = true;
            if (this.asynchronousQueue.size() > 100) {
                throw new IOException("Error: the peer is not consuming our asynchronous replies.");
            }
            if (this.asynchronousThread == null) {
                this.asynchronousThread = new AsynchronousWorker();
                this.asynchronousThread.setDaemon(true);
                this.asynchronousThread.start();
            }
            this.asynchronousQueue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConnectionMonitors(List<ConnectionMonitor> monitors) {
        TransportManager transportManager = this;
        synchronized (transportManager) {
            this.connectionMonitors = new ArrayList<ConnectionMonitor>();
            this.connectionMonitors.addAll(monitors);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(byte[] msg) throws IOException {
        List<AsynchronousEntry> list = this.asynchronousQueue;
        synchronized (list) {
            while (this.asynchronousPending) {
                try {
                    this.asynchronousQueue.wait(1000L);
                }
                catch (InterruptedException e) {
                    throw new InterruptedIOException(e.getMessage());
                }
            }
        }
        this.sendMessageImmediate(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessageImmediate(byte[] msg) throws IOException {
        if (Thread.currentThread() == this.receiveThread) {
            throw new IOException("Assertion error: sendMessage may never be invoked by the receiver thread!");
        }
        Object object = this.connectionSemaphore;
        synchronized (object) {
            while (true) {
                if (this.connectionClosed) {
                    throw new IOException("Sorry, this connection is closed.", this.reasonClosedCause);
                }
                if (!this.flagKexOngoing) break;
                try {
                    this.connectionSemaphore.wait();
                }
                catch (InterruptedException e) {
                    throw new InterruptedIOException(e.getMessage());
                }
            }
            try {
                this.tc.sendMessage(msg);
                this.idle = false;
            }
            catch (IOException e) {
                this.close(e);
                throw e;
            }
        }
    }

    public void receiveLoop() throws IOException {
        byte[] msg = new byte[35000];
        while (true) {
            TypesReader tr;
            int msglen;
            try {
                msglen = this.tc.receiveMessage(msg, 0, msg.length);
            }
            catch (SocketTimeoutException e) {
                if (this.idle) {
                    log.debug("Ignoring socket timeout");
                    continue;
                }
                throw e;
            }
            this.idle = true;
            int type = msg[0] & 0xFF;
            if (type == 2) continue;
            if (type == 4) {
                if (!log.isDebugEnabled()) continue;
                tr = new TypesReader(msg, 0, msglen);
                tr.readByte();
                tr.readBoolean();
                StringBuilder debugMessageBuffer = new StringBuilder();
                debugMessageBuffer.append(tr.readString("UTF-8"));
                for (int i = 0; i < debugMessageBuffer.length(); ++i) {
                    char c = debugMessageBuffer.charAt(i);
                    if (c >= ' ' && c <= '~') continue;
                    debugMessageBuffer.setCharAt(i, '\ufffd');
                }
                log.debug("DEBUG Message from remote: '" + debugMessageBuffer.toString() + "'");
                continue;
            }
            if (type == 3) {
                throw new IOException("Peer sent UNIMPLEMENTED message, that should not happen.");
            }
            if (type == 1) {
                tr = new TypesReader(msg, 0, msglen);
                tr.readByte();
                int reason_code = tr.readUINT32();
                StringBuilder reasonBuffer = new StringBuilder();
                reasonBuffer.append(tr.readString("UTF-8"));
                if (reasonBuffer.length() > 255) {
                    reasonBuffer.setLength(255);
                    reasonBuffer.setCharAt(254, '.');
                    reasonBuffer.setCharAt(253, '.');
                    reasonBuffer.setCharAt(252, '.');
                }
                for (int i = 0; i < reasonBuffer.length(); ++i) {
                    char c = reasonBuffer.charAt(i);
                    if (c >= ' ' && c <= '~') continue;
                    reasonBuffer.setCharAt(i, '\ufffd');
                }
                throw new IOException("Peer sent DISCONNECT message (reason code " + reason_code + "): " + reasonBuffer.toString());
            }
            if (type == 20 || type == 21 || type >= 30 && type <= 49) {
                this.km.handleMessage(msg, msglen);
                continue;
            }
            MessageHandler mh = null;
            for (HandlerEntry he : this.messageHandlers) {
                if (he.low > type || type > he.high) continue;
                mh = he.mh;
                break;
            }
            if (mh == null) {
                throw new IOException("Unexpected SSH message (type " + type + ")");
            }
            mh.handleMessage(msg, msglen);
        }
    }

    private final class AsynchronousWorker
    extends Thread {
        private AsynchronousWorker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                AsynchronousEntry item;
                List list = TransportManager.this.asynchronousQueue;
                synchronized (list) {
                    if (TransportManager.this.asynchronousQueue.size() == 0) {
                        TransportManager.this.asynchronousPending = false;
                        TransportManager.this.asynchronousQueue.notifyAll();
                        try {
                            TransportManager.this.asynchronousQueue.wait(2000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (TransportManager.this.asynchronousQueue.size() == 0) {
                            TransportManager.this.asynchronousThread = null;
                            return;
                        }
                    }
                    item = (AsynchronousEntry)TransportManager.this.asynchronousQueue.remove(0);
                }
                try {
                    TransportManager.this.sendMessageImmediate(item.msg);
                }
                catch (IOException e) {
                    return;
                }
                if (item.run == null) continue;
                try {
                    item.run.run();
                }
                catch (Exception exception) {
                }
            }
        }
    }

    private static final class AsynchronousEntry {
        public byte[] msg;
        public Runnable run;

        public AsynchronousEntry(byte[] msg, Runnable run) {
            this.msg = msg;
            this.run = run;
        }
    }

    private static final class HandlerEntry {
        MessageHandler mh;
        int low;
        int high;

        private HandlerEntry() {
        }
    }
}

