/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.util.AddressIteratorAdapter;
import ghidra.util.AddressRangeIterators;
import ghidra.util.DifferenceAddressSetView;
import ghidra.util.IntersectionAddressSetView;
import ghidra.util.SymmetricDifferenceAddressSetView;
import ghidra.util.UnionAddressSetView;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractAddressSetView
implements AddressSetView {
    protected static Address fixStart(AddressRangeIterator rev, Address start, boolean forward) {
        if (!rev.hasNext()) {
            return start;
        }
        AddressRange rng = (AddressRange)rev.next();
        if (!rng.contains(start)) {
            return start;
        }
        return forward ? rng.getMinAddress() : rng.getMaxAddress();
    }

    public boolean isEmpty() {
        return !this.iterator().hasNext();
    }

    public boolean contains(Address start, Address end) {
        AddressRangeIterator dit = AddressRangeIterators.subtract(new AddressSet(start, end).iterator(), this.iterator(start, true), null, true);
        return !dit.hasNext();
    }

    public boolean contains(AddressSetView rangeSet) {
        AddressRangeIterator dit = AddressRangeIterators.subtract(rangeSet.iterator(), this.iterator(rangeSet.getMinAddress(), true), null, true);
        return !dit.hasNext();
    }

    public Address getMinAddress() {
        AddressRangeIterator it = this.getAddressRanges(true);
        return it.hasNext() ? ((AddressRange)it.next()).getMinAddress() : null;
    }

    public Address getMaxAddress() {
        AddressRangeIterator it = this.getAddressRanges(false);
        return it.hasNext() ? ((AddressRange)it.next()).getMaxAddress() : null;
    }

    public int getNumAddressRanges() {
        int count = 0;
        Iterator<AddressRange> iterator = this.iterator();
        while (iterator.hasNext()) {
            AddressRange r = iterator.next();
            ++count;
        }
        return count;
    }

    public Iterator<AddressRange> iterator() {
        return this.getAddressRanges();
    }

    public Iterator<AddressRange> iterator(boolean forward) {
        return this.getAddressRanges(forward);
    }

    public Iterator<AddressRange> iterator(Address start, boolean forward) {
        return this.getAddressRanges(start, forward);
    }

    public long getNumAddresses() {
        long count = 0L;
        Iterator<AddressRange> iterator = this.iterator();
        while (iterator.hasNext()) {
            AddressRange r = iterator.next();
            count += r.getLength();
        }
        return count;
    }

    public AddressIterator getAddresses(boolean forward) {
        return new AddressIteratorAdapter(this.iterator(forward), forward);
    }

    public AddressIterator getAddresses(Address start, boolean forward) {
        return new AddressIteratorAdapter(this.iterator(start, forward), start, forward);
    }

    public boolean hasSameAddresses(AddressSetView view) {
        AddressRangeIterator ait = this.getAddressRanges();
        AddressRangeIterator bit = view.getAddressRanges();
        while (ait.hasNext() && bit.hasNext()) {
            AddressRange br;
            AddressRange ar = (AddressRange)ait.next();
            if (ar.equals(br = (AddressRange)bit.next())) continue;
            return false;
        }
        return !ait.hasNext() && !bit.hasNext();
    }

    public AddressRange getFirstRange() {
        Iterator<AddressRange> it = this.iterator(true);
        return it.hasNext() ? it.next() : null;
    }

    public AddressRange getLastRange() {
        Iterator<AddressRange> it = this.iterator(false);
        return it.hasNext() ? it.next() : null;
    }

    public boolean intersects(AddressSetView addrSet) {
        AddressRangeIterator iit = AddressRangeIterators.intersect(this.iterator(addrSet.getMinAddress(), true), addrSet.iterator(this.getMinAddress(), true), true);
        return iit.hasNext();
    }

    public boolean intersects(Address start, Address end) {
        AddressRangeIterator iit = AddressRangeIterators.intersect(this.iterator(start, true), List.of(new AddressRangeImpl(start, end)).iterator(), true);
        return iit.hasNext();
    }

    public AddressSet intersect(AddressSetView view) {
        return new AddressSet((AddressSetView)new IntersectionAddressSetView(this, view));
    }

    public AddressSet intersectRange(Address start, Address end) {
        return this.intersect((AddressSetView)new AddressSet(start, end));
    }

    public AddressSet union(AddressSetView addrSet) {
        return new AddressSet((AddressSetView)new UnionAddressSetView(this, addrSet));
    }

    public AddressSet subtract(AddressSetView addrSet) {
        return new AddressSet((AddressSetView)new DifferenceAddressSetView(this, addrSet));
    }

    public AddressSet xor(AddressSetView addrSet) {
        return new AddressSet((AddressSetView)new SymmetricDifferenceAddressSetView(this, addrSet));
    }

    public Address findFirstAddressInCommon(AddressSetView set) {
        AddressRangeIterator iit = AddressRangeIterators.intersect(this.iterator(), set.iterator(), true);
        return iit.hasNext() ? ((AddressRange)iit.next()).getMinAddress() : null;
    }

    public AddressRange getRangeContaining(Address address) {
        AddressRangeIterator it = this.getAddressRanges(address, true);
        if (!it.hasNext()) {
            return null;
        }
        AddressRange rng = (AddressRange)it.next();
        if (!rng.contains(address)) {
            return null;
        }
        return rng;
    }
}

