/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util;

import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.util.TwoWayBreakdownAddressRangeIterator;
import ghidra.util.UnionAddressRangeIterator;
import java.util.Collection;
import java.util.Iterator;

public enum AddressRangeIterators {


    public static AddressRangeIterator castOrWrap(Iterator<AddressRange> it) {
        if (it instanceof AddressRangeIterator) {
            return (AddressRangeIterator)it;
        }
        return new WrappingAddressRangeIterator(it);
    }

    public static AddressRangeIterator union(Collection<Iterator<AddressRange>> iterators, boolean forward) {
        return new UnionAddressRangeIterator(iterators, forward);
    }

    protected static boolean doCheckStart(AddressRange range, Address start, boolean forward) {
        if (start == null) {
            return true;
        }
        return forward ? range.getMaxAddress().compareTo((Object)start) >= 0 : range.getMinAddress().compareTo((Object)start) <= 0;
    }

    public static AddressRangeIterator subtract(Iterator<AddressRange> a, Iterator<AddressRange> b, Address start, boolean forward) {
        return new WrappingAddressRangeIterator(Iterators.transform((Iterator)Iterators.filter((Iterator)((Object)new TwoWayBreakdownAddressRangeIterator(a, b, forward)), e -> AddressRangeIterators.doCheckStart((AddressRange)e.getKey(), start, forward) && ((TwoWayBreakdownAddressRangeIterator.Which)((Object)((Object)e.getValue()))).inSubtract()), e -> (AddressRange)e.getKey()));
    }

    public static AddressRangeIterator xor(Iterator<AddressRange> a, Iterator<AddressRange> b, Address start, boolean forward) {
        TwoWayBreakdownAddressRangeIterator eit = new TwoWayBreakdownAddressRangeIterator(a, b, forward);
        UnmodifiableIterator fit = Iterators.filter((Iterator)((Object)eit), e -> ((TwoWayBreakdownAddressRangeIterator.Which)((Object)((Object)e.getValue()))).inXor());
        Iterator rit = Iterators.transform((Iterator)fit, e -> (AddressRange)e.getKey());
        UnionAddressRangeIterator uit = new UnionAddressRangeIterator(rit, forward);
        UnmodifiableIterator result = Iterators.filter((Iterator)((Object)uit), r -> AddressRangeIterators.doCheckStart(r, start, forward));
        return new WrappingAddressRangeIterator((Iterator<AddressRange>)result);
    }

    public static AddressRangeIterator intersect(Iterator<AddressRange> a, Iterator<AddressRange> b, boolean forward) {
        return new WrappingAddressRangeIterator(Iterators.transform((Iterator)Iterators.filter((Iterator)((Object)new TwoWayBreakdownAddressRangeIterator(a, b, forward)), e -> ((TwoWayBreakdownAddressRangeIterator.Which)((Object)((Object)e.getValue()))).inIntersect()), e -> (AddressRange)e.getKey()));
    }

    private static class WrappingAddressRangeIterator
    implements AddressRangeIterator {
        private final Iterator<AddressRange> it;

        public WrappingAddressRangeIterator(Iterator<AddressRange> it) {
            this.it = it;
        }

        public boolean hasNext() {
            return this.it.hasNext();
        }

        public AddressRange next() {
            return this.it.next();
        }

        public Iterator<AddressRange> iterator() {
            return this;
        }
    }
}

