/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.navigation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelException;
import org.netbeans.modules.web.beans.api.model.BeansModel;
import org.netbeans.modules.web.beans.api.model.WebBeansModel;
import org.netbeans.modules.web.beans.navigation.JavaHierarchyModel;
import org.netbeans.modules.web.beans.navigation.TypeTreeNode;
import org.netbeans.modules.web.beans.navigation.actions.WebBeansActionHelper;
import org.openide.filesystems.FileObject;

public final class DecoratorsModel
extends DefaultTreeModel
implements JavaHierarchyModel {
    private static final long serialVersionUID = 5096971301097791384L;
    private static final Logger LOG = Logger.getLogger(DecoratorsModel.class.getName());
    private MetadataModel<WebBeansModel> myModel;
    private List<ElementHandle<TypeElement>> myHandles;
    private LinkedHashSet<ElementHandle<TypeElement>> myEnabledDecorators;

    public DecoratorsModel(Collection<TypeElement> decorators, BeansModel beansModel, CompilationController controller, MetadataModel<WebBeansModel> model) {
        super(null);
        this.myModel = model;
        this.myHandles = new ArrayList<ElementHandle<TypeElement>>(decorators.size());
        this.myEnabledDecorators = new LinkedHashSet();
        LinkedHashSet<TypeElement> enabled = WebBeansActionHelper.getEnabledDecorators(decorators, beansModel, this.myEnabledDecorators, controller);
        for (TypeElement decorator : decorators) {
            this.myHandles.add((ElementHandle<TypeElement>)ElementHandle.create((Element)decorator));
        }
        this.update(decorators, enabled, controller);
    }

    @Override
    public void fireTreeNodesChanged() {
        super.fireTreeNodesChanged(this, this.getPathToRoot((TreeNode)this.getRoot()), null, null);
    }

    @Override
    public void update() {
        this.updateHandles(this.myHandles, this.myEnabledDecorators);
    }

    private void updateHandles(final List<ElementHandle<TypeElement>> handles, final LinkedHashSet<ElementHandle<TypeElement>> enabled) {
        try {
            this.getModel().runReadAction((MetadataModelAction)new MetadataModelAction<WebBeansModel, Void>(){

                public Void run(WebBeansModel model) {
                    ArrayList<TypeElement> list = new ArrayList<TypeElement>(handles.size());
                    LinkedHashSet<TypeElement> set = new LinkedHashSet<TypeElement>();
                    for (ElementHandle handle : handles) {
                        TypeElement type = (TypeElement)handle.resolve((CompilationInfo)model.getCompilationController());
                        if (type != null) {
                            list.add(type);
                        }
                        if (!enabled.contains(handle)) continue;
                        set.add(type);
                    }
                    DecoratorsModel.this.update(list, set, model.getCompilationController());
                    return null;
                }
            });
            return;
        }
        catch (MetadataModelException e) {
            LOG.log(Level.WARNING, e.getMessage(), e);
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, e.getMessage(), e);
        }
    }

    private void update(Collection<TypeElement> foundDecorators, LinkedHashSet<TypeElement> enabled, CompilationController controller) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        LinkedHashSet<TypeElement> allDecorators = new LinkedHashSet<TypeElement>();
        allDecorators.addAll(enabled);
        allDecorators.addAll(foundDecorators);
        for (TypeElement type : allDecorators) {
            FileObject fileObject = SourceUtils.getFile((ElementHandle)ElementHandle.create((Element)type), (ClasspathInfo)controller.getClasspathInfo());
            TypeTreeNode node = new TypeTreeNode(fileObject, type, !enabled.contains(type), (CompilationInfo)controller);
            root.add(node);
        }
        this.setRoot(root);
    }

    private MetadataModel<WebBeansModel> getModel() {
        return this.myModel;
    }
}

