/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.navigation.actions;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.VariableElement;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.web.beans.api.model.DependencyInjectionResult;
import org.netbeans.modules.web.beans.api.model.InjectionPointDefinitionError;
import org.netbeans.modules.web.beans.api.model.Result;
import org.netbeans.modules.web.beans.api.model.WebBeansModel;
import org.netbeans.modules.web.beans.navigation.InjectablesModel;
import org.netbeans.modules.web.beans.navigation.actions.GoToInjectableAtCaretAction;
import org.netbeans.modules.web.beans.navigation.actions.ModelActionStrategy;
import org.netbeans.modules.web.beans.navigation.actions.WebBeansActionHelper;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public final class InjectablesActionStrategy
implements ModelActionStrategy {
    @Override
    public boolean isApplicable(ModelActionStrategy.InspectActionId id) {
        return id == ModelActionStrategy.InspectActionId.INJECTABLES_CONTEXT;
    }

    @Override
    public boolean isApplicable(WebBeansModel model, Object[] context) {
        VariableElement var = WebBeansActionHelper.findVariable(model, context);
        if (var == null) {
            return false;
        }
        try {
            if (model.isEventInjectionPoint(var)) {
                return false;
            }
            if (!model.isInjectionPoint(var)) {
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(GoToInjectableAtCaretAction.class, (String)"LBL_NotInjectionPoint"), 700);
                return false;
            }
        }
        catch (InjectionPointDefinitionError e) {
            StatusDisplayer.getDefault().setStatusText(e.getMessage(), 700);
        }
        return true;
    }

    @Override
    public void invokeModelAction(WebBeansModel model, final MetadataModel<WebBeansModel> metaModel, final Object[] subject, JTextComponent component, FileObject fileObject) {
        Result res;
        DependencyInjectionResult result;
        VariableElement var = WebBeansActionHelper.findVariable(model, subject);
        DependencyInjectionResult dependencyInjectionResult = result = var == null ? null : model.lookupInjectables(var, null, new AtomicBoolean(false));
        if (result == null) {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(GoToInjectableAtCaretAction.class, (String)"LBL_InjectableNotFound"), 700);
            return;
        }
        if (result instanceof DependencyInjectionResult.Error) {
            StatusDisplayer.getDefault().setStatusText(((DependencyInjectionResult.Error)result).getMessage(), 700);
        }
        if (result.getKind() == DependencyInjectionResult.ResultKind.DEFINITION_ERROR) {
            return;
        }
        CompilationController controller = model.getCompilationController();
        final InjectablesModel uiModel = new InjectablesModel(result, controller, metaModel);
        final String name = var.getSimpleName().toString();
        Result result2 = res = result instanceof Result ? (Result)((Object)result) : null;
        if (SwingUtilities.isEventDispatchThread()) {
            WebBeansActionHelper.showInjectablesDialog(metaModel, model, subject, uiModel, name, res);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WebBeansActionHelper.showInjectablesDialog((MetadataModel<WebBeansModel>)metaModel, null, subject, uiModel, name, res);
                }
            });
        }
    }
}

