/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.uddi.infomodel;

import com.sun.xml.registry.uddi.infomodel.RegistryObjectImpl;
import com.sun.xml.registry.uddi.infomodel.SpecificationLinkImpl;
import com.sun.xml.registry.uddi.infomodel.URIValidatorImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.ResourceBundle;
import javax.xml.registry.InvalidRequestException;
import javax.xml.registry.JAXRException;
import javax.xml.registry.UnexpectedObjectException;
import javax.xml.registry.infomodel.Service;
import javax.xml.registry.infomodel.ServiceBinding;
import javax.xml.registry.infomodel.SpecificationLink;

public class ServiceBindingImpl
extends RegistryObjectImpl
implements ServiceBinding,
Serializable {
    private String accessURI;
    private ServiceBinding targetBinding;
    private Service parentService;
    private ArrayList specificationLinks;
    private URIValidatorImpl validator = new URIValidatorImpl();

    public ServiceBindingImpl() {
        this.specificationLinks = new ArrayList();
    }

    public String getAccessURI() throws JAXRException {
        if (this.accessURI == null) {
            this.getObject();
        }
        return this.accessURI;
    }

    public void setAccessURI(String uri) throws JAXRException {
        if (this.targetBinding != null) {
            throw new InvalidRequestException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("ServiceBindingImpl:TargetBinding_already_set"));
        }
        this.getObject();
        this.validator.validate(uri);
        this.accessURI = uri;
        this.setIsModified(true);
    }

    public ServiceBinding getTargetBinding() throws JAXRException {
        if (this.targetBinding == null) {
            this.getObject();
        }
        return this.targetBinding;
    }

    public void setTargetBinding(ServiceBinding binding) throws JAXRException {
        if (this.accessURI != null) {
            throw new InvalidRequestException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("ServiceBindingImpl:AccessURI_already_set"));
        }
        this.getObject();
        this.targetBinding = binding;
        this.setIsModified(true);
    }

    public Service getService() throws JAXRException {
        if (this.parentService == null) {
            this.getObject();
        }
        return this.parentService;
    }

    public void setService(Service service) {
        this.parentService = service;
    }

    public Collection getSpecificationLinks() throws JAXRException {
        if (this.specificationLinks.size() == 0) {
            this.getObject();
        }
        return (Collection)this.specificationLinks.clone();
    }

    public void addSpecificationLink(SpecificationLink link) throws JAXRException {
        if (link != null) {
            this.getObject();
            ((SpecificationLinkImpl)link).setServiceBinding(this);
            this.specificationLinks.add(link);
            this.setIsModified(true);
        }
    }

    public void addSpecificationLinks(Collection specificationLinks) throws JAXRException {
        if (specificationLinks == null) {
            return;
        }
        this.getObject();
        Iterator iter = specificationLinks.iterator();
        try {
            while (iter.hasNext()) {
                ((SpecificationLinkImpl)iter.next()).setServiceBinding(this);
            }
        }
        catch (ClassCastException cce) {
            throw new UnexpectedObjectException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("ServiceBindingImpl:Objects_in_collection_must_be_SpecificationLinks"), (Throwable)cce);
        }
        this.specificationLinks.addAll(specificationLinks);
        this.setIsModified(true);
    }

    public void removeSpecificationLink(SpecificationLink specificationLink) throws JAXRException {
        if (specificationLink != null) {
            this.getObject();
            this.specificationLinks.remove(specificationLink);
            this.setIsModified(true);
        }
    }

    public void removeSpecificationLinks(Collection specificationLinks) throws JAXRException {
        if (specificationLinks != null) {
            this.getObject();
            this.specificationLinks.removeAll(specificationLinks);
            this.setIsModified(true);
        }
    }

    public void setSpecificationLinks(Collection links) throws JAXRException {
        if (links == null) {
            this.specificationLinks = new ArrayList();
        } else {
            this.getObject();
            this.specificationLinks = new ArrayList(links);
        }
    }

    public void setValidateURI(boolean validate) {
        this.validator.setValidateURI(validate);
    }

    public boolean getValidateURI() {
        return this.validator.getValidateURI();
    }

    int getSequenceId(SpecificationLink link) {
        return this.specificationLinks.indexOf(link);
    }
}

