/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.provider.wsit;

import com.sun.xml.ws.api.message.Message;
import com.sun.xml.wss.provider.wsit.logging.LogStringsMessages;
import java.security.Principal;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.AuthStatus;
import javax.security.auth.message.MessageInfo;
import javax.security.auth.message.MessagePolicy;
import javax.security.auth.message.module.ServerAuthModule;
import javax.xml.soap.SOAPMessage;

public class WSITServerAuthModule
implements ServerAuthModule {
    private static final Logger log = Logger.getLogger("com.sun.xml.wss.provider.wsit", "com.sun.xml.wss.provider.wsit.logging.LogStrings");
    Class[] supported = new Class[2];
    boolean debug = false;
    protected static final String DEBUG = "debug";

    public WSITServerAuthModule() {
        this.supported[0] = SOAPMessage.class;
        this.supported[1] = Message.class;
    }

    @Override
    public void initialize(MessagePolicy requestPolicy, MessagePolicy responsePolicy, CallbackHandler handler, Map options) throws AuthException {
        String bg = (String)options.get(DEBUG);
        if (bg != null && bg.equals("true")) {
            this.debug = true;
        }
    }

    @Override
    public Class[] getSupportedMessageTypes() {
        return this.supported;
    }

    @Override
    public AuthStatus validateRequest(MessageInfo messageInfo, Subject clientSubject, Subject serviceSubject) throws AuthException {
        return AuthStatus.SUCCESS;
    }

    @Override
    public AuthStatus secureResponse(MessageInfo messageInfo, Subject serviceSubject) throws AuthException {
        return AuthStatus.SUCCESS;
    }

    @Override
    public void cleanSubject(MessageInfo messageInfo, Subject subject) throws AuthException {
        if (subject == null) {
            log.log(Level.SEVERE, LogStringsMessages.WSITPVD_0037_NULL_SUBJECT());
            throw new AuthException(LogStringsMessages.WSITPVD_0037_NULL_SUBJECT());
        }
        if (!subject.isReadOnly()) {
            return;
        }
        Set<Principal> principals = subject.getPrincipals();
        Set<Object> privateCredentials = subject.getPrivateCredentials();
        Set<Object> publicCredentials = subject.getPublicCredentials();
        try {
            principals.clear();
        }
        catch (UnsupportedOperationException uoe) {
            log.log(Level.SEVERE, LogStringsMessages.WSITPVD_0064_ERROR_CLEAN_SUBJECT(), uoe);
        }
        Iterator<Object> pi = privateCredentials.iterator();
        while (pi.hasNext()) {
            try {
                Destroyable dstroyable = (Destroyable)pi.next();
                dstroyable.destroy();
            }
            catch (DestroyFailedException dfe) {
                log.log(Level.SEVERE, LogStringsMessages.WSITPVD_0064_ERROR_CLEAN_SUBJECT(), dfe);
            }
            catch (ClassCastException cce) {
                log.log(Level.SEVERE, LogStringsMessages.WSITPVD_0064_ERROR_CLEAN_SUBJECT(), cce);
            }
        }
        Iterator<Object> qi = publicCredentials.iterator();
        while (qi.hasNext()) {
            try {
                Destroyable dstroyable = (Destroyable)qi.next();
                dstroyable.destroy();
            }
            catch (DestroyFailedException dfe) {
                log.log(Level.SEVERE, LogStringsMessages.WSITPVD_0064_ERROR_CLEAN_SUBJECT(), dfe);
            }
            catch (ClassCastException cce) {
                log.log(Level.SEVERE, LogStringsMessages.WSITPVD_0064_ERROR_CLEAN_SUBJECT(), cce);
            }
        }
    }
}

