/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.v8debug.vars;

import java.util.Objects;
import org.netbeans.lib.v8debug.V8Scope;
import org.netbeans.lib.v8debug.vars.V8Value;
import org.netbeans.modules.javascript.v8debug.vars.EvaluationError;

public class Variable {
    private final Kind kind;
    private final String name;
    private final long ref;
    private V8Value value;
    private final V8Scope scope;
    private String valueLoadError;
    private boolean hasIncompleteValue;

    public Variable(Kind kind, String name, long ref, V8Value value, boolean incompleteValue) {
        this(kind, name, ref, value, incompleteValue, null);
    }

    public Variable(Kind kind, String name, long ref, V8Value value, boolean incompleteValue, V8Scope scope) {
        this.kind = kind;
        this.name = name;
        this.ref = ref;
        this.value = value;
        this.scope = scope;
        this.hasIncompleteValue = incompleteValue;
    }

    public boolean hasIncompleteValue() {
        return this.hasIncompleteValue;
    }

    public Kind getKind() {
        return this.kind;
    }

    public String getName() {
        return this.name;
    }

    public long getRef() {
        return this.ref;
    }

    public V8Value getValue() throws EvaluationError {
        if (this.valueLoadError != null) {
            throw new EvaluationError(this.valueLoadError);
        }
        return this.value;
    }

    void setValue(V8Value value) {
        this.value = value;
        this.hasIncompleteValue = false;
    }

    void setValueLoadError(String valueLoadError) {
        this.valueLoadError = valueLoadError;
    }

    public V8Scope getScope() {
        return this.scope;
    }

    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + Objects.hashCode(this.name);
        hash = 67 * hash + (int)(this.ref ^ this.ref >>> 32);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Variable other = (Variable)obj;
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        return this.ref == other.ref;
    }

    public static enum Kind {
        ARGUMENT,
        LOCAL,
        PROPERTY,
        ARRAY_ELEMENT;

    }
}

