/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xdm.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.xml.spi.dom.NodeListImpl;
import org.netbeans.modules.xml.xdm.XDMModel;
import org.netbeans.modules.xml.xdm.nodes.Attribute;
import org.netbeans.modules.xml.xdm.nodes.Document;
import org.netbeans.modules.xml.xdm.nodes.NamedNodeMapImpl;
import org.netbeans.modules.xml.xdm.nodes.Node;
import org.netbeans.modules.xml.xdm.nodes.Token;
import org.netbeans.modules.xml.xdm.visitor.PathFromRootVisitor;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.w3c.dom.UserDataHandler;

public abstract class NodeImpl
implements Node,
Cloneable {
    public static final String XMLNS = "xmlns";
    private boolean inTree = false;
    private XDMModel model = null;
    private int id = -1;
    private List<Token> tokens;
    private List<Node> children;
    private List<Attribute> attributes = null;

    NodeImpl() {
    }

    @Override
    public final int getId() {
        return this.id;
    }

    private void setId(int nodeId) {
        this.id = nodeId;
    }

    public int hashCode() {
        return this.getId();
    }

    @Override
    public final boolean isInTree() {
        return this.inTree && this.getModel() != null;
    }

    @Override
    public void addedToTree(XDMModel model) {
        if (!this.isInTree()) {
            this.inTree = true;
            if (this.getModel() != model) {
                this.setModel(model);
                this.setId(model.getNextNodeId());
            } else if (this.getId() == -1) {
                this.setId(model.getNextNodeId());
            }
            for (Node node : this.getChildren()) {
                node.addedToTree(model);
            }
            for (Node node : this.getAttributesForRead()) {
                node.addedToTree(model);
            }
        }
    }

    private UniqueId createUniqueId() {
        return new UniqueId(){
            private int lastId = -1;

            @Override
            public int nextId() {
                return ++this.lastId;
            }
        };
    }

    public void assignNodeIdRecursively() {
        this.assignNodeId(this.createUniqueId());
    }

    void assignNodeId(UniqueId id) {
        assert (!this.isInTree());
        this.setId(id.nextId());
        for (Node node : this.getChildren()) {
            ((NodeImpl)node).assignNodeId(id);
        }
        for (Node node : this.getAttributesForRead()) {
            ((NodeImpl)node).assignNodeId(id);
        }
    }

    public void assignNodeId(int id) {
        assert (!this.isInTree());
        this.setId(id);
        for (Node node : this.getChildren()) {
            ((NodeImpl)node).assignNodeId(id);
        }
        for (Node node : this.getAttributesForRead()) {
            ((NodeImpl)node).assignNodeId(id);
        }
    }

    protected XDMModel getModel() {
        return this.model;
    }

    private void setModel(XDMModel xdmModel) {
        assert (xdmModel != null);
        this.model = xdmModel;
    }

    @Override
    public boolean isEquivalentNode(Node node) {
        return this == node || this.getClass().isInstance(node) && this.getModel() != null && this.getModel() == ((NodeImpl)node).getModel() && this.getId() != -1 && this.getId() == node.getId();
    }

    final void checkNotInTree() {
        if (this.isInTree()) {
            throw new IllegalStateException("mutations cannot occur on nodes already added to a tree");
        }
    }

    @Override
    public boolean isSupported(String feature, String version) {
        return "1.0".equals(version);
    }

    @Override
    public Node clone(boolean cloneContent, boolean cloneAttributes, boolean cloneChildren) {
        try {
            NodeImpl clone = (NodeImpl)super.clone();
            clone.inTree = false;
            if (cloneContent) {
                clone.setTokens(new ArrayList<Token>(this.getTokens()));
            } else {
                clone.setTokens(this.getTokens());
            }
            if (cloneAttributes) {
                clone.setAttributes(new ArrayList<Attribute>(this.getAttributesForRead()));
            } else {
                clone.setAttributes(this.getAttributesForRead());
            }
            if (cloneChildren) {
                clone.setChildren(new ArrayList<Node>(this.getChildren()));
            } else {
                clone.setChildren(this.getChildren());
            }
            return clone;
        }
        catch (CloneNotSupportedException cne) {
            throw new RuntimeException(cne);
        }
    }

    @Override
    public Node cloneNode(boolean deep) {
        return this.cloneNode(deep, true);
    }

    public Node cloneNode(boolean deep, boolean cloneNamespacePrefix) {
        Document root = this.isInTree() ? (Document)this.getOwnerDocument() : null;
        Map<Integer, String> allNamespaces = null;
        if (cloneNamespacePrefix && root != null) {
            allNamespaces = root.getNamespaceMap();
        }
        HashMap<String, String> clonePrefixes = new HashMap<String, String>();
        return this.cloneNode(deep, allNamespaces, clonePrefixes);
    }

    public Node cloneNode(boolean deep, Map<Integer, String> allNS, Map<String, String> clonePrefixes) {
        try {
            NodeImpl clone = (NodeImpl)super.clone();
            clone.inTree = false;
            clone.model = null;
            clone.setTokens(new ArrayList<Token>(this.getTokens()));
            if (deep) {
                ArrayList<Node> cloneChildren = new ArrayList<Node>(this.getChildren().size());
                for (Node c : this.getChildren()) {
                    NodeImpl child = (NodeImpl)c;
                    NodeImpl cloneChild = (NodeImpl)child.cloneNode(deep, allNS, clonePrefixes);
                    cloneChildren.add(cloneChild);
                }
                clone.setChildren(cloneChildren);
            }
            ArrayList<Attribute> cloneAttributes = new ArrayList<Attribute>(this.getAttributesForRead().size());
            for (Attribute attribute : this.getAttributesForRead()) {
                cloneAttributes.add((Attribute)attribute.cloneNode(deep, allNS, clonePrefixes));
            }
            clone.setAttributes(cloneAttributes);
            this.cloneNamespacePrefixes(allNS, clonePrefixes);
            return clone;
        }
        catch (CloneNotSupportedException cne) {
            throw new RuntimeException(cne);
        }
    }

    protected void cloneNamespacePrefixes(Map<Integer, String> allNS, Map<String, String> prefixes) {
        if (allNS == null) {
            return;
        }
        String namespace = allNS.get(this.getId());
        if (namespace != null) {
            String prefix = this.getPrefix();
            if (prefix != null) {
                prefixes.put(prefix, namespace);
            } else {
                prefixes.put("", namespace);
            }
        }
    }

    public Node cloneShallowWithModelContext() {
        try {
            NodeImpl clone = (NodeImpl)super.clone();
            clone.inTree = false;
            clone.setTokens(new ArrayList<Token>(this.getTokens()));
            if (this.hasChildNodes()) {
                clone.setChildren(new ArrayList<Node>(this.getChildren()));
            }
            if (this.hasAttributes()) {
                clone.setAttributes(new ArrayList<Attribute>(this.getAttributesForRead()));
            }
            return clone;
        }
        catch (CloneNotSupportedException cne) {
            throw new RuntimeException(cne);
        }
    }

    @Override
    public boolean hasChildNodes() {
        return !this.getChildren().isEmpty();
    }

    @Override
    public NodeList getChildNodes() {
        if (!this.hasChildNodes()) {
            return NodeListImpl.EMPTY;
        }
        return new NodeListImpl(this.getChildren());
    }

    @Override
    public Node getFirstChild() {
        if (!this.hasChildNodes()) {
            return null;
        }
        return this.getChildren().get(0);
    }

    @Override
    public Node getLastChild() {
        if (!this.hasChildNodes()) {
            return null;
        }
        return this.getChildren().get(this.getChildren().size() - 1);
    }

    @Override
    public int getIndexOfChild(Node n) {
        if (n == null) {
            return -1;
        }
        List<Node> childs = this.getChildren();
        for (int i = 0; i < childs.size(); ++i) {
            if (childs.get(i) != n && (childs.get(i).getId() != n.getId() || n.getId() == -1)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Node appendChild(org.w3c.dom.Node node) {
        this.checkNotInTree();
        if (node instanceof Node) {
            NodeImpl nodeImpl = (NodeImpl)node;
            nodeImpl.checkNotInTree();
            this.getChildrenForWrite().add(nodeImpl);
            return nodeImpl;
        }
        throw new DOMException(17, node.getClass().getName());
    }

    @Override
    public Node replaceChild(org.w3c.dom.Node newNode, org.w3c.dom.Node oldNode) {
        this.checkNotInTree();
        if (newNode instanceof Node && oldNode instanceof Node) {
            NodeImpl newNodeImpl = (NodeImpl)newNode;
            NodeImpl oldNodeImpl = (NodeImpl)oldNode;
            newNodeImpl.checkNotInTree();
            int oldIndex = this.getIndexOfChild(oldNodeImpl);
            if (oldIndex != -1) {
                return this.getChildrenForWrite().set(oldIndex, newNodeImpl);
            }
            throw new DOMException(8, null);
        }
        throw new DOMException(17, null);
    }

    public Node reorderChild(org.w3c.dom.Node child, int index) {
        this.checkNotInTree();
        if (child instanceof Node) {
            NodeImpl n = (NodeImpl)child;
            if (!n.isInTree()) {
                throw new IllegalArgumentException("Node is not in tree");
            }
            int currentIndex = this.getIndexOfChild(n);
            if (index == currentIndex) {
                return n;
            }
            if (!this.getChildrenForWrite().remove(n)) {
                throw new IllegalArgumentException("Node is not in children");
            }
            index = index > currentIndex ? index - 1 : index;
            this.getChildrenForWrite().add(index, n);
            return n;
        }
        throw new DOMException(17, null);
    }

    public void reorderChildren(int[] permutation) {
        this.checkNotInTree();
        ArrayList<Node> copy = new ArrayList<Node>(this.getChildren());
        if (permutation.length != copy.size()) {
            throw new IllegalArgumentException("Permutation length: " + permutation.length + " is different than children size: " + copy.size());
        }
        List<Node> writableChildren = this.getChildrenForWrite();
        for (int i = 0; i < copy.size(); ++i) {
            Node child = (Node)copy.get(i);
            writableChildren.set(permutation[i], child);
        }
    }

    @Override
    public Node removeChild(org.w3c.dom.Node node) {
        this.checkNotInTree();
        if (node instanceof Attribute ? this.getAttributesForWrite().remove(node) : node instanceof Node && this.getChildrenForWrite().remove(node)) {
            return (Node)node;
        }
        throw new DOMException(17, null);
    }

    @Override
    public Node insertBefore(org.w3c.dom.Node newChild, org.w3c.dom.Node refChild) throws DOMException {
        if (refChild == null) {
            return this.appendChild(newChild);
        }
        this.checkNotInTree();
        if (newChild instanceof Node && refChild instanceof Node) {
            NodeImpl newChildImpl = (NodeImpl)newChild;
            newChildImpl.checkNotInTree();
            int index = this.getIndexOfChild((NodeImpl)refChild);
            if (index < 0) {
                throw new DOMException(8, null);
            }
            this.getChildrenForWrite().add(index, newChildImpl);
            return newChildImpl;
        }
        throw new DOMException(17, null);
    }

    @Override
    public boolean hasAttributes() {
        return !this.getAttributesForRead().isEmpty();
    }

    @Override
    public NamedNodeMap getAttributes() {
        if (this.attributes == null || this.attributes.isEmpty()) {
            return NamedNodeMapImpl.EMPTY;
        }
        return new NamedNodeMapImpl(this.attributes);
    }

    @Override
    public org.w3c.dom.Document getOwnerDocument() {
        return this.getModel().getDocument();
    }

    @Override
    public Node getParentNode() {
        if (!this.isInTree()) {
            return null;
        }
        PathFromRootVisitor pfrv = new PathFromRootVisitor();
        List<Node> path = pfrv.findPath(this.getModel().getDocument(), this);
        if (path == null || path.size() < 2) {
            return null;
        }
        return path.get(1);
    }

    @Override
    public Node getNextSibling() {
        NodeImpl node;
        if (!this.isInTree()) {
            return null;
        }
        PathFromRootVisitor pfrv = new PathFromRootVisitor();
        List<Node> path = pfrv.findPath(this.getModel().getDocument(), this);
        if (path == null || path.size() < 2) {
            return null;
        }
        NodeImpl parent = (NodeImpl)path.get(1);
        int nextIndex = parent.getIndexOfChild(node = (NodeImpl)path.get(0)) + 1;
        if (nextIndex >= parent.getChildren().size()) {
            return null;
        }
        return parent.getChildren().get(nextIndex);
    }

    @Override
    public Node getPreviousSibling() {
        NodeImpl node;
        if (!this.isInTree()) {
            return null;
        }
        PathFromRootVisitor pfrv = new PathFromRootVisitor();
        List<Node> path = pfrv.findPath(this.getModel().getDocument(), this);
        if (path == null || path.size() < 2) {
            return null;
        }
        NodeImpl parent = (NodeImpl)path.get(1);
        int prevIndex = parent.getIndexOfChild(node = (NodeImpl)path.get(0)) - 1;
        if (prevIndex < 0) {
            return null;
        }
        return parent.getChildren().get(prevIndex);
    }

    @Override
    public abstract short getNodeType();

    @Override
    public abstract String getNodeName();

    @Override
    public String getNodeValue() throws DOMException {
        return null;
    }

    @Override
    public void setNodeValue(String str) throws DOMException {
    }

    @Override
    public String getLocalName() {
        return null;
    }

    @Override
    public String getNamespaceURI(Document document) {
        assert (document != null);
        return document.getNamespaceURI(this);
    }

    @Override
    public String getNamespaceURI() {
        String namespace = this.lookupNamespaceLocally(this.getPrefix());
        if (namespace != null) {
            return namespace;
        }
        if (this.isInTree()) {
            return this.getModel().getDocument().getNamespaceURI(this);
        }
        return this.lookupNamespaceURI(this.getPrefix());
    }

    @Override
    public String lookupNamespaceURI(String prefix) {
        String namespace;
        if (prefix == null) {
            prefix = "";
        }
        if ((namespace = this.lookupNamespaceLocally(prefix)) == null && this.isInTree()) {
            List<Node> pathToRoot = new PathFromRootVisitor().findPath(this.getModel().getDocument(), this);
            namespace = NodeImpl.lookupNamespace(prefix, pathToRoot);
        }
        return namespace;
    }

    public static String lookupNamespace(Node current, List<Node> ancestors) {
        String namespace = current.getNamespaceURI();
        if (namespace == null) {
            namespace = NodeImpl.lookupNamespace(current.getPrefix(), ancestors);
        }
        return namespace;
    }

    public static String lookupNamespace(String prefix, List<Node> path) {
        if (path == null) {
            return null;
        }
        if (prefix == null) {
            prefix = "";
        }
        for (Node node : path) {
            String namespace = ((NodeImpl)node).lookupNamespaceLocally(prefix);
            if (namespace == null) continue;
            return namespace;
        }
        return null;
    }

    String lookupNamespaceLocally(String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        if (this.hasAttributes()) {
            for (Attribute attribute : this.getAttributesForRead()) {
                String key;
                if (!attribute.isXmlnsAttribute() || !(key = attribute.getPrefix() == null ? "" : attribute.getLocalName()).equals(prefix)) continue;
                return attribute.getValue();
            }
        }
        return null;
    }

    String lookupPrefixLocally(String uri) {
        if (this.hasAttributes()) {
            String defaultNamespace = null;
            for (Attribute attribute : this.getAttributesForRead()) {
                String attrName = attribute.getName();
                if (!attrName.startsWith(XMLNS)) continue;
                if (attrName.length() == 5) {
                    defaultNamespace = attribute.getValue();
                    continue;
                }
                if (attrName.charAt(5) != ':' || !uri.equals(attribute.getValue())) continue;
                return attrName.substring(6);
            }
            if (uri.equals(defaultNamespace)) {
                return "";
            }
        }
        return null;
    }

    @Override
    public String lookupPrefix(String uri) {
        PathFromRootVisitor pfrv;
        List<Node> path;
        if (uri == null) {
            return null;
        }
        if (this.isInTree() && (path = (pfrv = new PathFromRootVisitor()).findPath(this.getModel().getDocument(), this)) != null && !path.isEmpty()) {
            return NodeImpl.lookupPrefix(uri, path);
        }
        return this.lookupPrefixLocally(uri);
    }

    public static String lookupPrefix(String uri, List<Node> path) {
        if (path == null) {
            return null;
        }
        for (Node node : path) {
            NodeImpl n = (NodeImpl)node;
            String prefix = n.lookupPrefixLocally(uri);
            if (prefix == null) continue;
            return prefix;
        }
        return null;
    }

    @Override
    public String getPrefix() {
        return null;
    }

    @Override
    public void setPrefix(String str) throws DOMException {
    }

    @Override
    public void normalize() {
    }

    @Override
    public short compareDocumentPosition(org.w3c.dom.Node a) {
        throw new DOMException(9, "This read-only implementation supports DOM level 1 Core and XML module.");
    }

    @Override
    public String getBaseURI() {
        throw new DOMException(9, "This read-only implementation supports DOM level 1 Core and XML module.");
    }

    @Override
    public Object getFeature(String a, String b) {
        throw new DOMException(9, "This read-only implementation supports DOM level 1 Core and XML module.");
    }

    @Override
    public String getTextContent() {
        throw new DOMException(9, "This read-only implementation supports DOM level 1 Core and XML module.");
    }

    @Override
    public Object getUserData(String a) {
        throw new DOMException(9, "This read-only implementation supports DOM level 1 Core and XML module.");
    }

    @Override
    public boolean isDefaultNamespace(String a) {
        throw new DOMException(9, "This read-only implementation supports DOM level 1 Core and XML module.");
    }

    @Override
    public boolean isEqualNode(org.w3c.dom.Node a) {
        throw new DOMException(9, "This read-only implementation supports DOM level 1 Core and XML module.");
    }

    @Override
    public boolean isSameNode(org.w3c.dom.Node a) {
        throw new DOMException(9, "This read-only implementation supports DOM level 1 Core and XML module.");
    }

    @Override
    public void setTextContent(String a) {
        throw new DOMException(9, "This read-only implementation supports DOM level 1 Core and XML module.");
    }

    @Override
    public Object setUserData(String a, Object b, UserDataHandler c) {
        throw new DOMException(9, "This read-only implementation supports DOM level 1 Core and XML module.");
    }

    public void copyTokens(Node newNode) {
        this.checkNotInTree();
        this.setTokens(((NodeImpl)newNode).getTokens());
    }

    private List<Node> getChildren() {
        return this.createUnmodifiableListIfNeeded(this.children);
    }

    private List<Node> getChildrenForWrite() {
        this.checkNotInTree();
        if (this.children == null) {
            this.children = new ArrayList<Node>(0);
        }
        return this.children;
    }

    private void setChildren(List<Node> newChildren) {
        this.checkNotInTree();
        this.children = newChildren;
    }

    protected List<Attribute> getAttributesForRead() {
        return this.createUnmodifiableListIfNeeded(this.attributes);
    }

    protected List<Attribute> getAttributesForWrite() {
        this.checkNotInTree();
        if (this.attributes == null) {
            this.attributes = new ArrayList<Attribute>(0);
        }
        return this.attributes;
    }

    private void setAttributes(List<Attribute> newAttributes) {
        this.checkNotInTree();
        this.attributes = newAttributes;
    }

    public List<Token> getTokens() {
        return this.createUnmodifiableListIfNeeded(this.tokens);
    }

    List<Token> getTokensForWrite() {
        this.checkNotInTree();
        if (this.tokens == null) {
            this.tokens = new ArrayList<Token>(0);
        }
        return this.tokens;
    }

    void setTokens(List<Token> newTokens) {
        this.tokens = newTokens;
    }

    public Node copy() {
        NodeImpl clone = (NodeImpl)this.cloneNode(true);
        clone.assignNodeId(-1);
        return clone;
    }

    private <E> List<E> createUnmodifiableListIfNeeded(List<E> objects) {
        List<Object> unmodifiableObjects = objects;
        if (objects == null) {
            unmodifiableObjects = Collections.emptyList();
        } else if (objects instanceof ArrayList) {
            unmodifiableObjects = Collections.unmodifiableList(objects);
        }
        return unmodifiableObjects;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "<" + this.getNodeName() + ">";
    }

    private static interface UniqueId {
        public int nextId();
    }
}

