/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.codegen;

import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.maven.codegen.Bundle;
import org.netbeans.modules.maven.codegen.ProfileGenerator;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentModel;
import org.netbeans.modules.xml.xam.dom.DocumentComponent;
import org.netbeans.spi.editor.codegen.CodeGenerator;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Exceptions;

public abstract class AbstractGenerator<T extends AbstractDocumentModel<? extends DocumentComponent<?>>>
implements CodeGenerator {
    protected final JTextComponent component;
    protected final T model;

    protected AbstractGenerator(T model, JTextComponent component) {
        this.model = model;
        this.component = component;
    }

    protected abstract void doInvoke();

    public final void invoke() {
        try {
            this.model.sync();
        }
        catch (IOException ex) {
            Logger.getLogger(ProfileGenerator.class.getName()).log(Level.INFO, "Error while syncing the editor document with model for pom.xml file", ex);
        }
        if (!this.model.getState().equals((Object)Model.State.VALID)) {
            StatusDisplayer.getDefault().setStatusText(Bundle.MSG_Cannot_Parse());
            return;
        }
        this.doInvoke();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void writeModel(ModelWriter writer) {
        int newPos = -1;
        try {
            if (this.model.startTransaction()) {
                newPos = writer.write();
            }
        }
        finally {
            try {
                this.model.endTransaction();
            }
            catch (IllegalStateException ex) {
                StatusDisplayer.getDefault().setStatusText(Bundle.ERR_CannotWriteModel(Exceptions.findLocalizedMessage((Throwable)ex)), 700);
            }
        }
        if (newPos != -1) {
            this.component.setCaretPosition(newPos);
        }
    }

    protected <C extends DocumentComponent> boolean addAtPosition(String parentTagName, ChildrenListProvider<C> childrenListProvider, C newChild) {
        return this.addAtPosition(null, parentTagName, childrenListProvider, newChild);
    }

    protected <C extends DocumentComponent> boolean addAtPosition(DocumentComponent componentAtCarret, String parentTagName, ChildrenListProvider<C> childrenListProvider, C newChild) {
        int pos = this.component.getCaretPosition();
        if (componentAtCarret == null) {
            componentAtCarret = this.model.findComponent(pos);
        }
        if (componentAtCarret != null) {
            DocumentComponent c = null;
            if (componentAtCarret.getPeer().getTagName().equals(parentTagName)) {
                c = componentAtCarret;
            } else if (componentAtCarret.getClass() == newChild.getClass() && componentAtCarret.findPosition() == pos) {
                c = componentAtCarret.getParent();
            }
            if (c != null) {
                List<C> list = childrenListProvider.get();
                for (int i = 0; i < list.size(); ++i) {
                    DocumentComponent l = (DocumentComponent)list.get(i);
                    if (pos > l.findPosition()) continue;
                    this.model.addChildComponent((Component)c, newChild, i);
                    return true;
                }
            }
        }
        return false;
    }

    protected static interface ChildrenListProvider<C extends DocumentComponent> {
        public List<C> get();
    }

    public static interface ModelWriter {
        public int write();
    }
}

