/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http;

import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.tuple.Pair;

public class ApacheConnectionPoolConfig {
    private final int totalOpenConnections;
    private final int defaultMaxConnectionsPerRoute;
    private final Pair<Integer, TimeUnit> ttl;

    public static ApacheConnectionPoolConfig newDefault() {
        return ApacheConnectionPoolConfig.builder().defaultMaxConnectionsPerRoute(50).totalOpenConnections(50).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private ApacheConnectionPoolConfig(Builder builder) {
        this.totalOpenConnections = builder.totalOpenConnections;
        this.defaultMaxConnectionsPerRoute = builder.defaultMaxConnectionsPerRoute;
        this.ttl = builder.ttl;
    }

    public int getTotalOpenConnections() {
        return this.totalOpenConnections;
    }

    public int getDefaultMaxConnectionsPerRoute() {
        return this.defaultMaxConnectionsPerRoute;
    }

    public Pair<Integer, TimeUnit> getTtl() {
        return this.ttl;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApacheConnectionPoolConfig)) {
            return false;
        }
        ApacheConnectionPoolConfig other = (ApacheConnectionPoolConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTotalOpenConnections() != other.getTotalOpenConnections()) {
            return false;
        }
        if (this.getDefaultMaxConnectionsPerRoute() != other.getDefaultMaxConnectionsPerRoute()) {
            return false;
        }
        Pair<Integer, TimeUnit> this$ttl = this.getTtl();
        Pair<Integer, TimeUnit> other$ttl = other.getTtl();
        return !(this$ttl == null ? other$ttl != null : !this$ttl.equals(other$ttl));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ApacheConnectionPoolConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTotalOpenConnections();
        result = result * 59 + this.getDefaultMaxConnectionsPerRoute();
        Pair<Integer, TimeUnit> $ttl = this.getTtl();
        result = result * 59 + ($ttl == null ? 43 : $ttl.hashCode());
        return result;
    }

    public String toString() {
        return "ApacheConnectionPoolConfig(totalOpenConnections=" + this.getTotalOpenConnections() + ", defaultMaxConnectionsPerRoute=" + this.getDefaultMaxConnectionsPerRoute() + ", ttl=" + this.getTtl() + ")";
    }

    public static final class Builder {
        private int totalOpenConnections;
        private int defaultMaxConnectionsPerRoute;
        private Pair<Integer, TimeUnit> ttl;

        public Builder totalOpenConnections(int totalOpenConnections) {
            this.totalOpenConnections = totalOpenConnections;
            return this;
        }

        public Builder defaultMaxConnectionsPerRoute(int defaultMaxConnectionsPerRoute) {
            this.defaultMaxConnectionsPerRoute = defaultMaxConnectionsPerRoute;
            return this;
        }

        public Builder ttlInMillis(int ttlInMillis) {
            this.ttl = Pair.of((Object)ttlInMillis, (Object)((Object)TimeUnit.MILLISECONDS));
            return this;
        }

        public Builder ttl(int ttl, TimeUnit ttlTimeUnit) {
            this.ttl = Pair.of((Object)ttl, (Object)((Object)ttlTimeUnit));
            return this;
        }

        public ApacheConnectionPoolConfig build() {
            return new ApacheConnectionPoolConfig(this);
        }
    }
}

