/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http.internal;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.PropertyWriter;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.google.common.base.CaseFormat;
import java.lang.reflect.Field;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExplicitlySetFilter
extends SimpleBeanPropertyFilter {
    private static final Logger LOG = LoggerFactory.getLogger(ExplicitlySetFilter.class);
    public static final ExplicitlySetFilter INSTANCE = new ExplicitlySetFilter();
    public static final String NAME = "explicitlySetFilter";
    public static final String FIELD_NAME = "__explicitlySet__";

    private ExplicitlySetFilter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void serializeAsField(Object pojo, JsonGenerator jgen, SerializerProvider provider, PropertyWriter writer) throws Exception {
        if (this.include(writer)) {
            Field field = ExplicitlySetFilter.getMatchingDeclaredField(pojo.getClass(), writer.getName());
            boolean accessible = field.isAccessible();
            try {
                field.setAccessible(true);
                Object fieldValue = field.get(pojo);
                if (fieldValue != null) {
                    writer.serializeAsField(pojo, jgen, provider);
                    return;
                }
                Field explicitField = pojo.getClass().getDeclaredField(FIELD_NAME);
                boolean explicitAccessible = explicitField.isAccessible();
                try {
                    explicitField.setAccessible(true);
                    Set explicitlySet = (Set)explicitField.get(pojo);
                    if (!explicitlySet.contains(writer.getName())) return;
                    writer.serializeAsField(pojo, jgen, provider);
                    return;
                }
                finally {
                    explicitField.setAccessible(explicitAccessible);
                }
            }
            finally {
                field.setAccessible(accessible);
            }
        } else {
            if (jgen.canOmitFields()) return;
            writer.serializeAsOmittedField(pojo, jgen, provider);
        }
    }

    private static Field getDeclaredField(Class<?> pojoClass, String fieldName) throws NoSuchFieldException {
        try {
            return pojoClass.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException nsfe) {
            Class<?> superclass = pojoClass.getSuperclass();
            if (superclass != null) {
                return ExplicitlySetFilter.getDeclaredField(superclass, fieldName);
            }
            throw nsfe;
        }
    }

    private static Field getMatchingDeclaredField(Class<?> pojoClass, String fieldName) throws NoSuchFieldException {
        try {
            return ExplicitlySetFilter.getDeclaredField(pojoClass, fieldName);
        }
        catch (NoSuchFieldException nsfe) {
            LOG.debug("Exact field name match failed for {}", (Object)fieldName);
            return ExplicitlySetFilter.getDeclaredField(pojoClass, CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, fieldName));
        }
    }

    protected boolean include(BeanPropertyWriter writer) {
        return !FIELD_NAME.equals(writer.getName());
    }

    protected boolean include(PropertyWriter writer) {
        return !FIELD_NAME.equals(writer.getName());
    }
}

