/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http.signing.internal;

import com.google.common.base.Preconditions;
import com.oracle.bmc.http.signing.internal.SignedRequestException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAPrivateKey;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public class SignatureSigner {
    private static final Logger LOG = LoggerFactory.getLogger(SignatureSigner.class);

    @Nonnull
    public byte[] sign(@Nonnull RSAPrivateKey privateKey, @Nonnull byte[] message, @Nonnull String algorithm) {
        Preconditions.checkArgument((null != privateKey ? 1 : 0) != 0, (Object)"privateKey must not be null");
        Preconditions.checkArgument((null != message && 0 < message.length ? 1 : 0) != 0, (Object)"message must not be null or empty");
        Preconditions.checkArgument((!StringUtils.isBlank((CharSequence)algorithm) ? 1 : 0) != 0);
        try {
            Signature signature = Signature.getInstance(algorithm);
            signature.initSign(privateKey);
            signature.update(message);
            return signature.sign();
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            LOG.debug("Error signing message", (Throwable)e);
            throw new SignedRequestException(e);
        }
    }
}

