/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.anchor;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import org.netbeans.api.visual.anchor.AnchorShape;

public class TriangleAnchorShape
implements AnchorShape {
    public static final Stroke STROKE = new BasicStroke(1.0f, 1, 1);
    private int size;
    private boolean filled;
    private boolean hollow;
    private double cutDistance;
    private GeneralPath generalPath;

    public TriangleAnchorShape(int size, boolean filled, boolean output, boolean hollow, double cutDistance) {
        this.size = size;
        this.filled = filled;
        this.hollow = hollow;
        this.cutDistance = cutDistance;
        float side = (float)size * 0.3f;
        this.generalPath = new GeneralPath();
        if (output) {
            this.generalPath.moveTo(size, 0.0f);
            this.generalPath.lineTo(0.0f, -side);
            this.generalPath.lineTo(0.0f, side);
            if (hollow) {
                this.generalPath.lineTo(size, 0.0f);
            }
        } else {
            this.generalPath.moveTo(0.0f, 0.0f);
            this.generalPath.lineTo(size, -side);
            this.generalPath.lineTo(size, side);
            if (hollow) {
                this.generalPath.lineTo(0.0f, 0.0f);
            }
        }
    }

    @Override
    public boolean isLineOriented() {
        return true;
    }

    @Override
    public int getRadius() {
        return (int)Math.ceil(1.5f * (float)this.size);
    }

    @Override
    public double getCutDistance() {
        return this.cutDistance;
    }

    @Override
    public void paint(Graphics2D graphics, boolean source) {
        if (this.filled) {
            graphics.fill(this.generalPath);
        } else {
            Stroke stroke = graphics.getStroke();
            graphics.setStroke(STROKE);
            graphics.draw(this.generalPath);
            graphics.setStroke(stroke);
        }
    }
}

