/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.java.api;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.gradle.api.GradleBaseProject;
import org.netbeans.modules.gradle.java.api.GradleJavaProject;
import org.netbeans.modules.gradle.java.api.GradleJavaSourceSet;
import org.netbeans.modules.gradle.spi.GradleFiles;
import org.netbeans.modules.gradle.spi.ProjectInfoExtractor;
import org.openide.filesystems.FileUtil;

final class GradleJavaProjectBuilder
implements ProjectInfoExtractor.Result {
    public static final String JAVA_BASE_PLUGIN = "java-base";
    final Map<String, Object> info;
    final GradleJavaProject prj = new GradleJavaProject();

    GradleJavaProjectBuilder(Map<String, Object> info) {
        this.info = info;
    }

    GradleJavaProjectBuilder build() {
        this.processTests();
        this.processSourceSets();
        this.processArtifacts();
        return this;
    }

    void processSourceSets() {
        Set sourceSetNames = (Set)this.info.get("sourcesets");
        if (sourceSetNames != null) {
            for (String name : sourceSetNames) {
                GradleJavaSourceSet sourceSet = this.prj.createSourceSet(name);
                for (GradleJavaSourceSet.SourceType type : GradleJavaSourceSet.SourceType.values()) {
                    Set dirs = (Set)this.info.get("sourceset_" + name + "_" + type.name());
                    if (dirs == null) continue;
                    LinkedHashSet<File> normalizedDirs = new LinkedHashSet<File>();
                    for (File dir : dirs) {
                        normalizedDirs.add(FileUtil.normalizeFile((File)dir));
                    }
                    sourceSet.sources.put(type, normalizedDirs);
                }
                sourceSet.compileClassPath = (Set)this.info.get("sourceset_" + name + "_classpath_compile");
                sourceSet.runtimeClassPath = (Set)this.info.get("sourceset_" + name + "_classpath_runtime");
                sourceSet.annotationProcessorPath = (Set)this.info.get("sourceset_" + name + "_classpath_annotation");
                sourceSet.compileConfigurationName = (String)this.info.get("sourceset_" + name + "_configuration_compile");
                sourceSet.runtimeConfigurationName = (String)this.info.get("sourceset_" + name + "_configuration_runtime");
                sourceSet.annotationProcessorConfigurationName = (String)this.info.get("sourceset_" + name + "_configuration_annotation");
                sourceSet.outputClassDirs = (Set)this.info.get("sourceset_" + name + "_output_classes");
                sourceSet.outputResources = (File)this.info.get("sourceset_" + name + "_output_resources");
                EnumMap<GradleJavaSourceSet.SourceType, String> sourceComp = new EnumMap<GradleJavaSourceSet.SourceType, String>(GradleJavaSourceSet.SourceType.class);
                EnumMap<GradleJavaSourceSet.SourceType, String> targetComp = new EnumMap<GradleJavaSourceSet.SourceType, String>(GradleJavaSourceSet.SourceType.class);
                EnumMap compilerArgs = new EnumMap(GradleJavaSourceSet.SourceType.class);
                for (GradleJavaSourceSet.SourceType lang : Arrays.asList(GradleJavaSourceSet.SourceType.JAVA, GradleJavaSourceSet.SourceType.GROOVY, GradleJavaSourceSet.SourceType.SCALA, GradleJavaSourceSet.SourceType.KOTLIN)) {
                    List compArgs;
                    String sc = (String)this.info.get("sourceset_" + name + "_" + lang.name() + "_source_compatibility");
                    String tc = (String)this.info.get("sourceset_" + name + "_" + lang.name() + "_target_compatibility");
                    if (sc != null) {
                        sourceComp.put(lang, sc);
                    }
                    if (tc != null) {
                        targetComp.put(lang, tc);
                    }
                    if ((compArgs = (List)this.info.get("sourceset_" + name + "_" + lang.name() + "_compiler_args")) == null) continue;
                    compilerArgs.put(lang, Collections.unmodifiableList(compArgs));
                }
                sourceSet.sourcesCompatibility = Collections.unmodifiableMap(sourceComp);
                sourceSet.targetCompatibility = Collections.unmodifiableMap(targetComp);
                sourceSet.compilerArgs = Collections.unmodifiableMap(compilerArgs);
                for (File out : sourceSet.getOutputClassDirs()) {
                    if (!this.prj.getTestClassesRoots().contains(out)) continue;
                    sourceSet.testSourceSet = true;
                    break;
                }
                if (!"main".equals(name)) continue;
                sourceSet.webApp = (File)this.info.get("webapp_dir");
            }
        }
        this.prj.resolveSourceSetDependencies();
    }

    void processArtifacts() {
        this.prj.mainJar = (File)this.info.get("main_jar");
        this.prj.archives = (Map)this.info.get("archives");
    }

    void processTests() {
        this.prj.testClassesRoots = (Set)this.info.get("test_classes_dirs");
        this.prj.testClassesRoots = this.prj.testClassesRoots != null ? Collections.unmodifiableSet(this.prj.testClassesRoots) : Collections.emptySet();
        this.prj.coverageData = (Set)this.info.get("jacoco_coverage_files");
        this.prj.coverageData = this.prj.coverageData != null ? Collections.unmodifiableSet(this.prj.coverageData) : Collections.emptySet();
    }

    public Set getExtract() {
        return Collections.singleton(this.prj);
    }

    public Set<String> getProblems() {
        return Collections.emptySet();
    }

    public static final class Extractor
    implements ProjectInfoExtractor {
        public ProjectInfoExtractor.Result extract(Map<String, Object> props, Map<Class, Object> otherInfo) {
            GradleBaseProject gp = (GradleBaseProject)otherInfo.get(GradleBaseProject.class);
            assert (gp != null) : "GradleProject should have been evaluated first, check the position of this extractor!";
            return gp.getPlugins().contains(GradleJavaProjectBuilder.JAVA_BASE_PLUGIN) ? new GradleJavaProjectBuilder(props).build() : ProjectInfoExtractor.Result.NONE;
        }

        public ProjectInfoExtractor.Result fallback(GradleFiles files) {
            File srcDir = new File(files.getProjectDir(), "src");
            if (!srcDir.isDirectory()) {
                return ProjectInfoExtractor.Result.NONE;
            }
            GradleJavaProject prj = new GradleJavaProject();
            File[] sourceSets = srcDir.listFiles();
            boolean isJava = false;
            for (File dir : sourceSets) {
                File kotlinDir;
                File scalaDir;
                File groovyDir;
                File resourcesDir;
                String name;
                if (!dir.isDirectory() || "dist".equals(name = dir.getName())) continue;
                GradleJavaSourceSet gss = prj.createSourceSet(name);
                File javaDir = new File(dir, "java");
                if (javaDir.isDirectory()) {
                    gss.sources.put(GradleJavaSourceSet.SourceType.JAVA, Collections.singleton(javaDir));
                    isJava = true;
                }
                if ((resourcesDir = new File(dir, "resources")).isDirectory()) {
                    gss.sources.put(GradleJavaSourceSet.SourceType.RESOURCES, Collections.singleton(resourcesDir));
                    isJava = true;
                }
                if ((groovyDir = new File(dir, "groovy")).isDirectory()) {
                    gss.sources.put(GradleJavaSourceSet.SourceType.GROOVY, Collections.singleton(groovyDir));
                    isJava = true;
                }
                if ((scalaDir = new File(dir, "scala")).isDirectory()) {
                    gss.sources.put(GradleJavaSourceSet.SourceType.SCALA, Collections.singleton(scalaDir));
                    isJava = true;
                }
                if (!(kotlinDir = new File(dir, "kotlin")).isDirectory()) continue;
                gss.sources.put(GradleJavaSourceSet.SourceType.KOTLIN, Collections.singleton(kotlinDir));
                isJava = true;
            }
            return isJava ? new ProjectInfoExtractor.DefaultResult((Object)prj, new String[0]) : ProjectInfoExtractor.Result.NONE;
        }
    }
}

