/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.docker.ui.build2;

import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.docker.api.DockerAction;
import org.netbeans.modules.docker.api.DockerInstance;
import org.netbeans.modules.docker.api.DockerfileDetail;
import org.netbeans.modules.docker.ui.build2.BuildOptionsVisual;
import org.netbeans.modules.docker.ui.build2.Bundle;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;
import org.openide.util.RequestProcessor;

public class BuildOptionsPanel
implements WizardDescriptor.Panel<WizardDescriptor>,
ChangeListener {
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private final RequestProcessor RP = new RequestProcessor("Parsing Dockerfile", 1);
    private BuildOptionsVisual component;
    private WizardDescriptor wizard;
    private static final Pattern MACRO_PATTERN = Pattern.compile("(?<!\\\\)\\$");

    public BuildOptionsVisual getComponent() {
        if (this.component == null) {
            this.component = new BuildOptionsVisual();
            this.component.addChangeListener(this);
        }
        return this.component;
    }

    public HelpCtx getHelp() {
        return HelpCtx.DEFAULT_HELP;
    }

    public boolean isValid() {
        this.wizard.putProperty("WizardPanel_errorMessage", null);
        this.wizard.putProperty("WizardPanel_infoMessage", null);
        this.wizard.putProperty("WizardPanel_warningMessage", null);
        String buildContext = (String)this.wizard.getProperty("buildContext");
        String dockerfile = this.component.getDockerfile();
        dockerfile = dockerfile == null ? buildContext + "/" + "Dockerfile" : buildContext + "/" + dockerfile;
        FileSystem fs = (FileSystem)this.wizard.getProperty("filesystem");
        FileObject fo = fs.getRoot().getFileObject(dockerfile);
        if (fo == null || !fo.isData() || !dockerfile.endsWith(fo.getNameExt())) {
            this.wizard.putProperty("WizardPanel_errorMessage", (Object)Bundle.MSG_NonExistingDockerfile());
            return false;
        }
        FileObject build = fs.getRoot().getFileObject(buildContext);
        if (build == null || !FileUtil.isParentOf((FileObject)build, (FileObject)fo)) {
            this.wizard.putProperty("WizardPanel_errorMessage", (Object)Bundle.MSG_NonRelativeDockerfile());
            return false;
        }
        Map buildArguments = (Map)this.wizard.getProperty("buildArguments");
        if (buildArguments == null) {
            this.RP.submit((Runnable)new BuildArgsUpdaterTask(fo));
        }
        return true;
    }

    public void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }

    public void readSettings(WizardDescriptor wiz) {
        if (this.wizard == null) {
            this.wizard = wiz;
        }
        this.component.setBuildContext((String)wiz.getProperty("buildContext"));
        String dockerfile = (String)wiz.getProperty("dockerfile");
        if (dockerfile == null) {
            dockerfile = "Dockerfile";
        }
        this.component.setDockerfile(dockerfile);
        Boolean pull = (Boolean)wiz.getProperty("pull");
        this.component.setPull(pull != null ? pull : false);
        Boolean noCache = (Boolean)wiz.getProperty("noCache");
        this.component.setPull(noCache != null ? noCache : false);
        this.changeSupport.fireChange();
    }

    public void storeSettings(WizardDescriptor wiz) {
        wiz.putProperty("dockerfile", (Object)this.component.getDockerfile());
        wiz.putProperty("pull", (Object)this.component.isPull());
        wiz.putProperty("noCache", (Object)this.component.isNoCache());
        wiz.putProperty("buildArguments", this.component.getBuildArgs());
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.changeSupport.fireChange();
    }

    private Map<String, String> filterMacros(Map<String, String> map) {
        return map.entrySet().stream().filter(entry -> !MACRO_PATTERN.matcher((CharSequence)entry.getValue()).find()).collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> (String)entry.getValue()));
    }

    private class BuildArgsUpdaterTask
    implements Runnable {
        private final FileObject fo;
        private DockerfileDetail dockerfileDetail;

        public BuildArgsUpdaterTask(FileObject fo) {
            this.fo = fo;
        }

        @Override
        public void run() {
            if (SwingUtilities.isEventDispatchThread()) {
                Map<String, String> userDefinedBuildArgs = BuildOptionsPanel.this.component.getBuildArgs();
                if (userDefinedBuildArgs == null || userDefinedBuildArgs.isEmpty()) {
                    Map filtered = BuildOptionsPanel.this.filterMacros(this.dockerfileDetail.getBuildArgs());
                    BuildOptionsPanel.this.component.setBuildArgs(filtered);
                    BuildOptionsPanel.this.wizard.putProperty("buildArguments", (Object)filtered);
                }
            } else {
                try {
                    DockerInstance instance = (DockerInstance)BuildOptionsPanel.this.wizard.getProperty("instance");
                    this.dockerfileDetail = new DockerAction(instance).getDetail(this.fo);
                    SwingUtilities.invokeLater(this);
                }
                catch (IOException ex) {
                    Logger.getLogger(BuildOptionsPanel.class.getName()).log(Level.INFO, "Can't parse dockerfile: {0}", ex.toString());
                }
            }
        }
    }
}

