/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common.registration;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.glassfish.spi.GlassfishModule;
import org.netbeans.modules.glassfish.tooling.data.GlassFishVersion;
import org.netbeans.modules.glassfish.tooling.utils.ServerUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class AutomaticRegistration {
    private static final Logger LOGGER = Logger.getLogger(AutomaticRegistration.class.getName());

    public static void main(String[] args) throws IOException {
        if (args.length < 2) {
            System.out.println("Parameters: <ide clusterDir> <GlassFishHome> <Java 7 or later home>");
            System.exit(-1);
        }
        String javaExe = args.length == 3 ? args[2] : "";
        int status = AutomaticRegistration.autoregisterGlassFishInstance(args[0], args[1], javaExe);
        System.exit(status);
    }

    private static int autoregisterGlassFishInstance(String clusterDirValue, String glassfishRoot, String jdk7orLaterPath) throws IOException {
        String displayName;
        boolean ok;
        System.setProperty("netbeans.user", clusterDirValue);
        File glassfishHome = new File(glassfishRoot);
        if (!glassfishHome.exists()) {
            LOGGER.log(Level.INFO, "Cannot register the default GlassFish server. The GlassFish Root directory {0} does not exist.", glassfishRoot);
            return 3;
        }
        String config = "GlassFishEE6/Instances";
        String deployer = "deployer:gfv3ee6";
        String defaultDisplayNamePrefix = "GlassFish Server ";
        GlassFishVersion version = ServerUtils.getServerVersion((String)glassfishRoot);
        if (GlassFishVersion.ge((Enum)version, (Enum)GlassFishVersion.GF_3_1)) {
            deployer = "deployer:gfv3ee6wc";
        } else if (GlassFishVersion.ge((Enum)version, (Enum)GlassFishVersion.GF_5)) {
            deployer = "deployer:gfv5ee8";
            config = "GlassFishEE8/Instances";
        } else if (GlassFishVersion.ge((Enum)version, (Enum)GlassFishVersion.GF_5_1_0)) {
            deployer = "deployer:gfv510ee8";
            config = "GlassFishJakartaEE8/Instances";
        } else if (GlassFishVersion.ge((Enum)version, (Enum)GlassFishVersion.GF_6)) {
            deployer = "deployer:gfv6ee9";
            config = "GlassFishJakartaEE9/Instances";
        } else if (GlassFishVersion.ge((Enum)version, (Enum)GlassFishVersion.GF_6_1_0)) {
            deployer = "deployer:gfv610ee9";
            config = "GlassFishJakartaEE9/Instances";
        }
        StringBuilder sb = new StringBuilder(defaultDisplayNamePrefix.length() + 12);
        if (version == null) {
            LOGGER.log(Level.INFO, "Cannot register the default GlassFish server. The GlassFish Root directory {0} is of unknown version.", glassfishRoot);
            return 4;
        }
        sb.append(defaultDisplayNamePrefix);
        sb.append(version.toString());
        String defaultDisplayName = sb.toString();
        FileObject serverInstanceDir = FileUtil.getConfigFile((String)config);
        if (serverInstanceDir == null && (serverInstanceDir = FileUtil.createFolder((FileObject)FileUtil.getConfigRoot(), (String)config)) == null) {
            LOGGER.log(Level.INFO, "Cannot register the default GlassFish server. The config/{0} folder cannot be created.", config);
            return 2;
        }
        glassfishRoot = new File(glassfishRoot).getAbsolutePath();
        String url = "[" + glassfishRoot + File.pathSeparator + glassfishRoot + File.separator + "domains" + File.separator + "domain1]" + deployer + ":localhost:4848";
        for (FileObject fo : serverInstanceDir.getChildren()) {
            if (!url.equals(fo.getAttribute("url"))) continue;
            return 0;
        }
        File jdk7orLaterExecutable = new File(jdk7orLaterPath);
        if (!jdk7orLaterExecutable.exists()) {
            jdk7orLaterExecutable = null;
        }
        if (ok = AutomaticRegistration.registerServerInstanceFO(serverInstanceDir, url, displayName = AutomaticRegistration.generateUniqueDisplayName(serverInstanceDir, defaultDisplayName), glassfishHome, jdk7orLaterExecutable)) {
            return 0;
        }
        return 6;
    }

    private static String generateUniqueDisplayName(FileObject serverInstanceDir, String defaultDisplayName) {
        String displayName = defaultDisplayName;
        boolean unique = true;
        int i = 1;
        while (true) {
            for (FileObject fo : serverInstanceDir.getChildren()) {
                if (!displayName.equals(fo.getAttribute("displayName"))) continue;
                unique = false;
                break;
            }
            if (unique) break;
            displayName = defaultDisplayName + " " + i++;
            unique = true;
        }
        return displayName;
    }

    private static boolean registerServerInstanceFO(FileObject serverInstanceDir, String url, String displayName, File glassfishRoot, File java7orLaterExecutable) {
        String name = FileUtil.findFreeFileName((FileObject)serverInstanceDir, (String)"glassfish_autoregistered_instance", null);
        try {
            FileObject instanceFO = serverInstanceDir.createData(name);
            instanceFO.setAttribute("url", (Object)url);
            instanceFO.setAttribute("username", (Object)"admin");
            instanceFO.setAttribute("password", (Object)"");
            instanceFO.setAttribute("displayName", (Object)displayName);
            instanceFO.setAttribute("adminPort", (Object)"4848");
            instanceFO.setAttribute("installfolder", (Object)glassfishRoot.getParent());
            instanceFO.setAttribute("debugPort", (Object)"");
            instanceFO.setAttribute("domainname", (Object)"domain1");
            instanceFO.setAttribute("domainsfolder", (Object)new File(glassfishRoot, "domains").getAbsolutePath());
            instanceFO.setAttribute("driverDeployOn", (Object)"true");
            instanceFO.setAttribute("installfolder", (Object)glassfishRoot.getParent());
            instanceFO.setAttribute("host", (Object)"localhost");
            instanceFO.setAttribute("homefolder", (Object)glassfishRoot.getAbsolutePath());
            instanceFO.setAttribute("java.platform", (Object)(java7orLaterExecutable == null ? "" : java7orLaterExecutable.getAbsolutePath()));
            instanceFO.setAttribute("httpportnumber", (Object)"8080");
            instanceFO.setAttribute("httphostname", (Object)"localhost");
            instanceFO.setAttribute("jvmMode", (Object)GlassfishModule.NORMAL_MODE);
            instanceFO.setAttribute("preserveSessionsOn", (Object)true);
            instanceFO.setAttribute("derbyStartOn", (Object)true);
            instanceFO.setAttribute("useIDEProxyOn", (Object)true);
            instanceFO.setAttribute("use.shared.mem", (Object)false);
            return true;
        }
        catch (IOException e) {
            LOGGER.log(Level.INFO, "Cannot register the default GlassFish server.");
            LOGGER.log(Level.INFO, null, e);
            return false;
        }
    }
}

