/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.js.parser.ir;

import com.oracle.js.parser.ir.Expression;
import com.oracle.js.parser.ir.LexicalContext;
import com.oracle.js.parser.ir.Node;
import com.oracle.js.parser.ir.PropertyNode;
import com.oracle.js.parser.ir.visitor.NodeVisitor;
import com.oracle.js.parser.ir.visitor.TranslatorNodeVisitor;
import java.util.Collections;
import java.util.List;

public final class ObjectNode
extends Expression {
    private final List<PropertyNode> elements;

    public ObjectNode(long l, int n, List<PropertyNode> list) {
        super(l, n);
        this.elements = list;
    }

    private ObjectNode(ObjectNode objectNode, List<PropertyNode> list) {
        super(objectNode);
        this.elements = list;
    }

    @Override
    public Node accept(NodeVisitor<? extends LexicalContext> nodeVisitor) {
        if (nodeVisitor.enterObjectNode(this)) {
            return nodeVisitor.leaveObjectNode(this.setElements(Node.accept(nodeVisitor, this.elements)));
        }
        return this;
    }

    @Override
    public <R> R accept(TranslatorNodeVisitor<? extends LexicalContext, R> translatorNodeVisitor) {
        return translatorNodeVisitor.enterObjectNode(this);
    }

    @Override
    public void toString(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append('{');
        if (!this.elements.isEmpty()) {
            stringBuilder.append(' ');
            boolean bl2 = true;
            for (Node node : this.elements) {
                if (!bl2) {
                    stringBuilder.append(", ");
                }
                bl2 = false;
                node.toString(stringBuilder, bl);
            }
            stringBuilder.append(' ');
        }
        stringBuilder.append('}');
    }

    public List<PropertyNode> getElements() {
        return Collections.unmodifiableList(this.elements);
    }

    private ObjectNode setElements(List<PropertyNode> list) {
        if (this.elements == list) {
            return this;
        }
        return new ObjectNode(this, list);
    }
}

