/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.debug;

import com.sun.jdi.Bootstrap;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.ListeningConnector;
import com.sun.jdi.connect.Transport;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.jpda.DebuggerStartException;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.MethodBreakpoint;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.execute.RunUtils;
import org.netbeans.modules.maven.debug.Utils;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.RequestProcessor;
import org.openide.windows.InputOutput;

public final class MavenJPDAStart {
    private static final RequestProcessor RP = new RequestProcessor(MavenJPDAStart.class.getName(), 1, true);
    private String transport = "dt_socket";
    private String name;
    private String stopClassName;
    private String stopMethod;
    private ClassPath additionalSourcePath;
    private final Project project;
    private volatile Future<?> lastFuture;

    private MavenJPDAStart(Project p) {
        this.project = p;
    }

    public static MavenJPDAStart create(Project p) {
        return new MavenJPDAStart(p);
    }

    public String execute(InputOutput io) throws Throwable {
        Future future;
        Future<?> prev = this.lastFuture;
        if (prev != null && !prev.isDone()) {
            io.getOut().print("Cancelling previous JPDA listening...");
            if (prev.cancel(true)) {
                io.getOut().println("done");
            } else {
                io.getOut().println("failed");
            }
        }
        io.getOut().println("JPDA Listening Start...");
        this.lastFuture = future = RP.submit(() -> this.startDebugger(io));
        return (String)future.get();
    }

    private String startDebugger(InputOutput io) throws IOException, IllegalConnectorArgumentsException {
        String portOrAddress;
        Transport t;
        ListeningConnector lc = null;
        Iterator<ListeningConnector> i = Bootstrap.virtualMachineManager().listeningConnectors().iterator();
        while (i.hasNext() && ((t = (lc = i.next()).transport()) == null || !t.name().equals(this.getTransport()))) {
        }
        if (lc == null) {
            throw new RuntimeException("No trasports named " + this.getTransport() + " found!");
        }
        Map<String, Connector.Argument> args = lc.defaultArguments();
        String address = lc.startListening(args);
        try {
            int port = Integer.parseInt(address.substring(address.indexOf(58) + 1));
            Connector.IntegerArgument portArg = (Connector.IntegerArgument)args.get("port");
            portArg.setValue(port);
            portOrAddress = Integer.toString(port);
        }
        catch (NumberFormatException e) {
            portOrAddress = address;
        }
        io.getOut().println("JPDA Address: " + address);
        io.getOut().println("Port:" + portOrAddress);
        ClassPath sourcePath = Utils.createSourcePath(this.project);
        if (this.getAdditionalSourcePath() != null) {
            sourcePath = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{sourcePath, this.getAdditionalSourcePath()});
        }
        ClassPath jdkSourcePath = Utils.createJDKSourcePath(this.project);
        if (this.getStopClassName() != null && this.getStopClassName().length() > 0) {
            final MethodBreakpoint b = this.getStopMethod() != null ? Utils.createBreakpoint(this.getStopClassName(), this.getStopMethod()) : Utils.createBreakpoint(this.getStopClassName());
            final Listener list = new Listener(b);
            b.addPropertyChangeListener("validity", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent pce) {
                    if (Breakpoint.VALIDITY.INVALID.equals((Object)b.getValidity()) && MavenJPDAStart.this.getStopMethod() != null) {
                        DebuggerManager.getDebuggerManager().removeBreakpoint((Breakpoint)b);
                        MethodBreakpoint b2 = Utils.createBreakpoint(MavenJPDAStart.this.getStopClassName());
                        list.replaceBreakpoint(b2);
                    }
                }
            });
            DebuggerManager.getDebuggerManager().addDebuggerListener("debuggerEngines", (DebuggerManagerListener)list);
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("sourcepath", sourcePath);
        properties.put("name", this.getName());
        properties.put("jdksources", jdkSourcePath);
        properties.put("baseDir", FileUtil.toFile((FileObject)this.project.getProjectDirectory()));
        if (RunUtils.isCompileOnSaveEnabled(this.project)) {
            properties.put("listeningCP", "sourcepath");
        }
        ListeningConnector flc = lc;
        this.lastFuture = RP.submit(() -> {
            try {
                JPDADebugger.startListening((ListeningConnector)flc, (Map)args, (Object[])new Object[]{properties, this.project});
            }
            catch (DebuggerStartException ex) {
                io.getErr().println("Debugger Start Error.");
                Logger.getLogger(MavenJPDAStart.class.getName()).log(Level.INFO, "Debugger Start Error.", ex);
            }
        });
        return portOrAddress;
    }

    public String getTransport() {
        return this.transport;
    }

    public void setTransport(String transport) {
        this.transport = transport;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getStopClassName() {
        return this.stopClassName;
    }

    public void setStopClassName(String stopClassName) {
        this.stopClassName = stopClassName;
    }

    public String getStopMethod() {
        return this.stopMethod;
    }

    public void setStopMethod(String stopMethod) {
        this.stopMethod = stopMethod;
    }

    public ClassPath getAdditionalSourcePath() {
        return this.additionalSourcePath;
    }

    public void setAdditionalSourcePath(ClassPath additionalSourcePath) {
        this.additionalSourcePath = additionalSourcePath;
    }

    private static class Listener
    extends DebuggerManagerAdapter {
        private MethodBreakpoint breakpoint;
        private final Set debuggers = new HashSet();

        Listener(MethodBreakpoint breakpoint) {
            this.breakpoint = breakpoint;
        }

        public void propertyChange(PropertyChangeEvent e) {
            int state;
            if ("state".equals(e.getPropertyName()) && ((state = ((Integer)e.getNewValue()).intValue()) == 4 || state == 3)) {
                if (this.breakpoint != null) {
                    DebuggerManager.getDebuggerManager().removeBreakpoint((Breakpoint)this.breakpoint);
                    this.breakpoint = null;
                }
                this.dispose();
            }
        }

        private void dispose() {
            DebuggerManager.getDebuggerManager().removeDebuggerListener("debuggerEngines", (DebuggerManagerListener)this);
            for (JPDADebugger d : this.debuggers) {
                d.removePropertyChangeListener("state", (PropertyChangeListener)((Object)this));
            }
        }

        public void engineAdded(DebuggerEngine engine) {
            JPDADebugger debugger = (JPDADebugger)engine.lookupFirst(null, JPDADebugger.class);
            if (debugger == null) {
                return;
            }
            debugger.addPropertyChangeListener("state", (PropertyChangeListener)((Object)this));
            this.debuggers.add(debugger);
        }

        public void engineRemoved(DebuggerEngine engine) {
            JPDADebugger debugger = (JPDADebugger)engine.lookupFirst(null, JPDADebugger.class);
            if (debugger == null) {
                return;
            }
            debugger.removePropertyChangeListener("state", (PropertyChangeListener)((Object)this));
            this.debuggers.remove(debugger);
        }

        private void replaceBreakpoint(MethodBreakpoint b2) {
            this.breakpoint = b2;
        }
    }
}

