/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.binary;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.Truncatable;
import com.oracle.truffle.js.nodes.access.JSConstantNode;
import com.oracle.truffle.js.nodes.binary.JSBinaryNode;
import com.oracle.truffle.js.nodes.binary.JSBitwiseXorConstantNode;
import com.oracle.truffle.js.nodes.binary.JSBitwiseXorNodeGen;
import com.oracle.truffle.js.nodes.cast.JSToInt32Node;
import com.oracle.truffle.js.nodes.cast.JSToNumericNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.SafeInteger;
import java.util.Set;

@NodeInfo(shortName="^")
public abstract class JSBitwiseXorNode
extends JSBinaryNode {
    protected JSBitwiseXorNode(JavaScriptNode left, JavaScriptNode right) {
        super(left, right);
    }

    public static JavaScriptNode create(JavaScriptNode left, JavaScriptNode right) {
        Truncatable.truncate(left);
        if (right instanceof JSConstantNode.JSConstantIntegerNode) {
            int rightValue = ((JSConstantNode.JSConstantIntegerNode)right).executeInt(null);
            return JSBitwiseXorConstantNode.create(left, rightValue);
        }
        Truncatable.truncate(right);
        return JSBitwiseXorNodeGen.create(left, right);
    }

    public abstract Object executeObject(Object var1, Object var2);

    @Specialization
    protected int doInteger(int a, int b) {
        return a ^ b;
    }

    @Specialization
    protected int doSafeIntegerInt(SafeInteger a, int b) {
        return this.doInteger(a.intValue(), b);
    }

    @Specialization
    protected int doIntSafeInteger(int a, SafeInteger b) {
        return this.doInteger(a, b.intValue());
    }

    @Specialization
    protected int doSafeInteger(SafeInteger a, SafeInteger b) {
        return this.doInteger(a.intValue(), b.intValue());
    }

    @Specialization
    protected int doDouble(double a, double b, @Cached(value="create()") JSToInt32Node leftInt32, @Cached(value="create()") JSToInt32Node rightInt32) {
        return this.doInteger(leftInt32.executeInt(a), rightInt32.executeInt(b));
    }

    @Specialization
    protected BigInt doBigInt(BigInt a, BigInt b) {
        return a.xor(b);
    }

    @Specialization(replaces={"doInteger", "doIntSafeInteger", "doSafeIntegerInt", "doSafeInteger", "doDouble", "doBigInt"})
    protected Object doGeneric(Object a, Object b, @Cached(value="create()") JSToNumericNode leftNumeric, @Cached(value="create()") JSToNumericNode rightNumeric, @Cached(value="createInner()") JSBitwiseXorNode xor, @Cached(value="create()") BranchProfile mixedNumericTypes) {
        Object left = leftNumeric.execute(a);
        Object right = rightNumeric.execute(b);
        this.ensureBothSameNumericType(left, right, mixedNumericTypes);
        return xor.executeObject(left, right);
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return JSBitwiseXorNodeGen.create(JSBitwiseXorNode.cloneUninitialized(this.getLeft(), materializedTags), JSBitwiseXorNode.cloneUninitialized(this.getRight(), materializedTags));
    }

    public static final JSBitwiseXorNode createInner() {
        return JSBitwiseXorNodeGen.create(null, null);
    }
}

