/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.array;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.js.runtime.array.ByteArrayAccess;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.misc.Unsafe;

final class SunMiscUnsafeNativeOrderByteArrayAccess
extends ByteArrayAccess {
    static final ByteArrayAccess INSTANCE = new SunMiscUnsafeNativeOrderByteArrayAccess();
    private static final Unsafe UNSAFE = AccessController.doPrivileged(new PrivilegedAction<Unsafe>(){

        @Override
        public Unsafe run() {
            try {
                Field theUnsafeInstance = Unsafe.class.getDeclaredField("theUnsafe");
                theUnsafeInstance.setAccessible(true);
                return (Unsafe)theUnsafeInstance.get(Unsafe.class);
            }
            catch (Exception e) {
                throw new RuntimeException("exception while trying to get Unsafe.theUnsafe via reflection:", e);
            }
        }
    });

    SunMiscUnsafeNativeOrderByteArrayAccess() {
    }

    @Override
    public int getInt16(byte[] buffer, int byteIndex) {
        return UNSAFE.getShort(buffer, SunMiscUnsafeNativeOrderByteArrayAccess.offset(byteIndex, buffer, 2));
    }

    @Override
    public int getInt32(byte[] buffer, int byteIndex) {
        return UNSAFE.getInt(buffer, SunMiscUnsafeNativeOrderByteArrayAccess.offset(byteIndex, buffer, 4));
    }

    @Override
    public long getInt64(byte[] buffer, int byteIndex) {
        return UNSAFE.getLong(buffer, SunMiscUnsafeNativeOrderByteArrayAccess.offset(byteIndex, buffer, 8));
    }

    @Override
    public float getFloat(byte[] buffer, int byteIndex) {
        return UNSAFE.getFloat(buffer, SunMiscUnsafeNativeOrderByteArrayAccess.offset(byteIndex, buffer, 4));
    }

    @Override
    public double getDouble(byte[] buffer, int byteIndex) {
        return UNSAFE.getDouble(buffer, SunMiscUnsafeNativeOrderByteArrayAccess.offset(byteIndex, buffer, 8));
    }

    @Override
    public void putInt16(byte[] buffer, int byteIndex, int value) {
        UNSAFE.putShort(buffer, SunMiscUnsafeNativeOrderByteArrayAccess.offset(byteIndex, buffer, 2), (short)value);
    }

    @Override
    public void putInt32(byte[] buffer, int byteIndex, int value) {
        UNSAFE.putInt(buffer, SunMiscUnsafeNativeOrderByteArrayAccess.offset(byteIndex, buffer, 4), value);
    }

    @Override
    public void putInt64(byte[] buffer, int byteIndex, long value) {
        UNSAFE.putLong(buffer, SunMiscUnsafeNativeOrderByteArrayAccess.offset(byteIndex, buffer, 8), value);
    }

    @Override
    public void putFloat(byte[] buffer, int byteIndex, float value) {
        UNSAFE.putFloat(buffer, SunMiscUnsafeNativeOrderByteArrayAccess.offset(byteIndex, buffer, 4), value);
    }

    @Override
    public void putDouble(byte[] buffer, int byteIndex, double value) {
        UNSAFE.putDouble(buffer, SunMiscUnsafeNativeOrderByteArrayAccess.offset(byteIndex, buffer, 8), value);
    }

    private static long offset(int byteIndex, byte[] buffer, int elementSize) {
        if (byteIndex < 0 || byteIndex > buffer.length - elementSize) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IndexOutOfBoundsException();
        }
        return (long)byteIndex * (long)Unsafe.ARRAY_BYTE_INDEX_SCALE + (long)Unsafe.ARRAY_BYTE_BASE_OFFSET;
    }
}

