/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.builtins.ArrayBufferFunctionBuiltins;
import com.oracle.truffle.js.builtins.ArrayBufferPrototypeBuiltins;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JavaScriptRootNode;
import com.oracle.truffle.js.runtime.builtins.JSAbstractBuffer;
import com.oracle.truffle.js.runtime.builtins.JSArrayBufferObject;
import com.oracle.truffle.js.runtime.builtins.JSConstructor;
import com.oracle.truffle.js.runtime.builtins.JSConstructorFactory;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import com.oracle.truffle.js.runtime.builtins.JSObjectFactory;
import com.oracle.truffle.js.runtime.builtins.JSSharedArrayBuffer;
import com.oracle.truffle.js.runtime.builtins.PrototypeSupplier;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.JSShape;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.DirectByteBufferHelper;
import java.nio.ByteBuffer;

public final class JSArrayBuffer
extends JSAbstractBuffer
implements JSConstructorFactory.WithFunctionsAndSpecies,
PrototypeSupplier {
    public static final String CLASS_NAME = "ArrayBuffer";
    public static final String PROTOTYPE_NAME = "ArrayBuffer.prototype";
    public static final JSArrayBuffer HEAP_INSTANCE = new JSArrayBuffer();
    public static final JSArrayBuffer DIRECT_INSTANCE = new JSArrayBuffer();

    private JSArrayBuffer() {
    }

    public static DynamicObject createArrayBuffer(JSContext context, int length) {
        return JSArrayBuffer.createArrayBuffer(context, new byte[length]);
    }

    public static DynamicObject createArrayBuffer(JSContext context, byte[] byteArray) {
        JSRealm realm = context.getRealm();
        JSObjectFactory factory = context.getArrayBufferFactory();
        DynamicObject obj = JSArrayBufferObject.createHeapArrayBuffer(factory.getShape(realm), byteArray);
        factory.initProto(obj, realm);
        assert (JSArrayBuffer.isJSHeapArrayBuffer(obj));
        return context.trackAllocation(obj);
    }

    public static int getDirectByteLength(DynamicObject thisObj) {
        return JSArrayBuffer.getDirectByteBuffer(thisObj).capacity();
    }

    public static ByteBuffer getDirectByteBuffer(DynamicObject thisObj) {
        assert (JSArrayBuffer.isJSDirectArrayBuffer(thisObj) || JSSharedArrayBuffer.isJSSharedArrayBuffer(thisObj));
        return JSArrayBufferObject.getDirectByteBuffer(thisObj);
    }

    public static DynamicObject createDirectArrayBuffer(JSContext context, int length) {
        return JSArrayBuffer.createDirectArrayBuffer(context, DirectByteBufferHelper.allocateDirect(length));
    }

    public static DynamicObject createDirectArrayBuffer(JSContext context, ByteBuffer buffer) {
        JSRealm realm = context.getRealm();
        JSObjectFactory factory = context.getDirectArrayBufferFactory();
        DynamicObject obj = JSArrayBufferObject.createDirectArrayBuffer(factory.getShape(realm), buffer);
        factory.initProto(obj, realm);
        assert (JSArrayBuffer.isJSDirectArrayBuffer(obj));
        return context.trackAllocation(obj);
    }

    @Override
    public DynamicObject createPrototype(JSRealm realm, DynamicObject ctor) {
        DynamicObject arrayBufferPrototype;
        JSContext context = realm.getContext();
        if (context.getEcmaScriptVersion() < 6) {
            Shape protoShape = JSShape.createPrototypeShape(context, HEAP_INSTANCE, realm.getObjectPrototype());
            arrayBufferPrototype = JSArrayBufferObject.createHeapArrayBuffer(protoShape, new byte[0]);
            JSObjectUtil.setOrVerifyPrototype(context, arrayBufferPrototype, realm.getObjectPrototype());
        } else {
            arrayBufferPrototype = JSObjectUtil.createOrdinaryPrototypeObject(realm);
        }
        JSObjectUtil.putConstructorProperty(context, arrayBufferPrototype, ctor);
        JSObjectUtil.putFunctionsFromContainer(realm, arrayBufferPrototype, ArrayBufferPrototypeBuiltins.BUILTINS);
        JSFunctionData byteLengthGetterData = realm.getContext().getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.ArrayBufferByteLength, c -> JSFunctionData.createCallOnly(context, JSArrayBuffer.createByteLengthGetterCallTarget(c), 0, "get byteLength"));
        DynamicObject byteLengthGetter = JSFunction.create(realm, byteLengthGetterData);
        JSObjectUtil.putBuiltinAccessorProperty(arrayBufferPrototype, (Object)"byteLength", byteLengthGetter, Undefined.instance);
        JSObjectUtil.putToStringTag(arrayBufferPrototype, CLASS_NAME);
        return arrayBufferPrototype;
    }

    private static CallTarget createByteLengthGetterCallTarget(final JSContext context) {
        return Truffle.getRuntime().createCallTarget((RootNode)new JavaScriptRootNode(context.getLanguage(), null, null){
            private final ConditionProfile isArrayBuffer;
            private final ConditionProfile isDirectByteBuffer;
            private final BranchProfile errorBranch;
            {
                super(lang, sourceSection, frameDescriptor);
                this.isArrayBuffer = ConditionProfile.createBinaryProfile();
                this.isDirectByteBuffer = ConditionProfile.createBinaryProfile();
                this.errorBranch = BranchProfile.create();
            }

            public Object execute(VirtualFrame frame) {
                Object obj = JSArguments.getThisObject(frame.getArguments());
                if (JSDynamicObject.isJSDynamicObject(obj)) {
                    DynamicObject buffer = (DynamicObject)obj;
                    if (this.isArrayBuffer.profile(JSArrayBuffer.isJSHeapArrayBuffer(buffer))) {
                        if (!context.getTypedArrayNotDetachedAssumption().isValid() && JSArrayBuffer.isDetachedBuffer(buffer)) {
                            return this.handleDetachedBuffer();
                        }
                        return JSAbstractBuffer.getByteLength(buffer);
                    }
                    if (this.isDirectByteBuffer.profile(JSArrayBuffer.isJSDirectArrayBuffer(buffer))) {
                        if (!context.getTypedArrayNotDetachedAssumption().isValid() && JSArrayBuffer.isDetachedBuffer(buffer)) {
                            return this.handleDetachedBuffer();
                        }
                        return JSArrayBuffer.getDirectByteLength(buffer);
                    }
                }
                this.errorBranch.enter();
                throw Errors.createTypeErrorArrayBufferExpected();
            }

            private Object handleDetachedBuffer() {
                if (context.isOptionV8CompatibilityMode()) {
                    return 0;
                }
                throw Errors.createTypeErrorDetachedBuffer();
            }
        });
    }

    @Override
    public Shape makeInitialShape(JSContext context, DynamicObject prototype) {
        if (this == HEAP_INSTANCE) {
            Shape initialShape = JSObjectUtil.getProtoChildShape(prototype, HEAP_INSTANCE, context);
            return initialShape;
        }
        assert (this == DIRECT_INSTANCE);
        Shape initialShape = JSObjectUtil.getProtoChildShape(prototype, DIRECT_INSTANCE, context);
        return initialShape;
    }

    public static JSConstructor createConstructor(JSRealm realm) {
        return HEAP_INSTANCE.createConstructorAndPrototype(realm, ArrayBufferFunctionBuiltins.BUILTINS);
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    @Override
    public String getClassName(DynamicObject object) {
        return this.getClassName();
    }

    public static boolean isJSHeapArrayBuffer(Object obj) {
        return obj instanceof JSArrayBufferObject.Heap;
    }

    public static boolean isJSDirectArrayBuffer(Object obj) {
        return obj instanceof JSArrayBufferObject.Direct;
    }

    public static boolean isJSDirectOrSharedArrayBuffer(Object obj) {
        return JSArrayBuffer.isJSDirectArrayBuffer(obj) || JSSharedArrayBuffer.isJSSharedArrayBuffer(obj);
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean isDetachedBuffer(DynamicObject arrayBuffer) {
        assert (JSArrayBuffer.isJSAbstractBuffer(arrayBuffer));
        if (JSArrayBuffer.isJSHeapArrayBuffer(arrayBuffer)) {
            return JSArrayBuffer.getByteArray(arrayBuffer) == null;
        }
        assert (JSArrayBuffer.isJSDirectOrSharedArrayBuffer(arrayBuffer));
        return JSArrayBuffer.getDirectByteBuffer(arrayBuffer) == null;
    }

    @CompilerDirectives.TruffleBoundary
    public static void detachArrayBuffer(DynamicObject arrayBuffer) {
        assert (JSArrayBuffer.isJSAbstractBuffer(arrayBuffer));
        JSObject.getJSContext(arrayBuffer).getTypedArrayNotDetachedAssumption().invalidate("no detached array buffer");
        if (JSArrayBuffer.isJSDirectArrayBuffer(arrayBuffer)) {
            ((JSArrayBufferObject.Direct)arrayBuffer).detachArrayBuffer();
        } else {
            ((JSArrayBufferObject.Heap)arrayBuffer).detachArrayBuffer();
        }
    }

    @Override
    public DynamicObject getIntrinsicDefaultProto(JSRealm realm) {
        return realm.getArrayBufferPrototype();
    }
}

