/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.loaders;

import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.gradle.api.Action;
import org.gradle.tooling.BuildActionExecuter;
import org.gradle.tooling.ConfigurableLauncher;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.model.Model;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gradle.api.ModelFetcher;
import org.netbeans.modules.gradle.loaders.ModelCachingDescriptor;
import org.openide.util.RequestProcessor;

public class ModelCache<T extends Model> {
    static final RequestProcessor RP = new RequestProcessor(ModelCache.class);
    private static final Logger LOG = Logger.getLogger(ModelCache.class.getName());
    private State state = State.FREE;
    final ModelCachingDescriptor<T> descriptor;
    final Project project;
    private CountDownLatch barrier;

    public ModelCache(Project project, ModelCachingDescriptor<T> descriptor) {
        this.project = project;
        this.descriptor = descriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshAndWait() throws InterruptedException {
        ModelCache modelCache = this;
        synchronized (modelCache) {
            if (this.state == State.FREE) {
                this.barrier = new CountDownLatch(1);
                RP.submit(() -> this.load());
            }
        }
        this.barrier.await();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        ModelCache modelCache = this;
        synchronized (modelCache) {
            if (this.state == State.BUSY) {
                throw new IllegalStateException("Chache is BUSY");
            }
            this.state = State.BUSY;
        }
        try {
            List filteredTargets = this.descriptor.getTargets().stream().filter(target -> this.descriptor.needsRefresh((String)target)).collect(Collectors.toList());
            if (!filteredTargets.isEmpty()) {
                ProjectConnection pconn = (ProjectConnection)this.project.getLookup().lookup(ProjectConnection.class);
                ModelFetcher fetcher = new ModelFetcher();
                for (String target2 : filteredTargets) {
                    fetcher.modelAction(target2, this.descriptor.getModelClass(), model -> this.descriptor.onLoad(target2, (Model)model));
                }
                long startTime = System.currentTimeMillis();
                fetcher.fetchModels(pconn, (Action<? super BuildActionExecuter>)((Action)launcher -> this.descriptor.gradleCommandLine().configure((ConfigurableLauncher<?>)launcher)));
                fetcher.awaitTermination(10L, TimeUnit.MINUTES);
                long endTime = System.currentTimeMillis();
                LOG.info("Loaded " + filteredTargets.size() + " targets for " + this.project + " in " + (endTime - startTime));
            }
        }
        catch (Exception exception) {
        }
        finally {
            modelCache = this;
            synchronized (modelCache) {
                this.state = State.FREE;
            }
            this.barrier.countDown();
        }
    }

    public synchronized State getState() {
        return this.state;
    }

    static enum State {
        FREE,
        BUSY;

    }
}

