/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.queries;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.gradle.api.GradleBaseProject;
import org.netbeans.modules.gradle.queries.AbstractProjectChangeAdaptor;
import org.netbeans.spi.project.ProjectContainerProvider;
import org.netbeans.spi.project.SubprojectProvider;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class ProjectContainerProviderImpl
extends AbstractProjectChangeAdaptor
implements SubprojectProvider,
ProjectContainerProvider {
    private static final Logger LOG = Logger.getLogger(ProjectContainerProviderImpl.class.getName());

    public ProjectContainerProviderImpl(Project project) {
        super(project);
    }

    public ProjectContainerProvider.Result getContainedProjects() {
        return new ProjectContainerProvider.Result(this.getSubprojects(), false);
    }

    public Set<? extends Project> getSubprojects() {
        HashSet<Project> ret = null;
        Project root = ProjectUtils.rootOf((Project)this.project);
        GradleBaseProject rgp = GradleBaseProject.get(root);
        GradleBaseProject gbp = GradleBaseProject.get(this.project);
        if (rgp != null && gbp != null) {
            ret = new HashSet<Project>();
            String ourPath = gbp.isRoot() ? ":" : gbp.getPath() + ':';
            for (Map.Entry<String, File> sub : rgp.getSubProjects().entrySet()) {
                FileObject fo;
                String subPath;
                if (sub.getKey().length() <= ourPath.length() || !sub.getKey().startsWith(ourPath) || (subPath = sub.getKey().substring(ourPath.length())).indexOf(58) >= 0 || (fo = FileUtil.toFileObject((File)sub.getValue())) == null) continue;
                try {
                    Project p = ProjectManager.getDefault().findProject(fo);
                    if (p != null) {
                        ret.add(p);
                        continue;
                    }
                    LOG.log(Level.WARNING, "It seems {0} was not identified as a (sub-)project of {1}", new Object[]{fo.getPath(), this.project.toString()});
                }
                catch (IOException | IllegalArgumentException ex) {
                    ErrorManager.getDefault().notify((Throwable)ex);
                }
            }
        }
        return ret != null ? Collections.unmodifiableSet(ret) : Collections.emptySet();
    }
}

