/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.index;

import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.indexing.Context;
import org.netbeans.modules.parsing.spi.indexing.EmbeddingIndexer;
import org.netbeans.modules.parsing.spi.indexing.EmbeddingIndexerFactory;
import org.netbeans.modules.parsing.spi.indexing.Indexable;
import org.netbeans.modules.parsing.spi.indexing.support.IndexDocument;
import org.netbeans.modules.parsing.spi.indexing.support.IndexingSupport;
import org.netbeans.modules.php.editor.NavUtils;
import org.netbeans.modules.php.editor.completion.PhpTypeCompletionProviderWrapper;
import org.netbeans.modules.php.editor.elements.IndexQueryImpl;
import org.netbeans.modules.php.editor.index.IdentifierSignature;
import org.netbeans.modules.php.editor.index.IdentifierSignatureFactory;
import org.netbeans.modules.php.editor.model.ConstantElement;
import org.netbeans.modules.php.editor.model.FileScope;
import org.netbeans.modules.php.editor.model.FunctionScope;
import org.netbeans.modules.php.editor.model.Model;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.NamespaceScope;
import org.netbeans.modules.php.editor.model.TypeScope;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocTypeNode;
import org.netbeans.modules.php.editor.parser.astnodes.Program;
import org.netbeans.modules.php.editor.parser.astnodes.Scalar;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.netbeans.modules.php.project.api.PhpSourcePath;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class PHPIndexer
extends EmbeddingIndexer {
    private static final Logger LOG = Logger.getLogger(PHPIndexer.class.getName());
    private static final List<String> INDEXABLE_EXTENSIONS = FileUtil.getMIMETypeExtensions((String)"text/x-php5");
    public static final String FIELD_BASE = "base";
    public static final String FIELD_EXTEND = "extend";
    public static final String FIELD_CLASS = "clz";
    public static final String FIELD_SUPER_CLASS = "superclz";
    public static final String FIELD_IFACE = "iface";
    public static final String FIELD_SUPER_IFACE = "superiface";
    public static final String FIELD_CONST = "const";
    public static final String FIELD_CLASS_CONST = "clz.const";
    public static final String FIELD_FIELD = "field";
    public static final String FIELD_METHOD = "method";
    public static final String FIELD_CONSTRUCTOR = "constructor";
    public static final String FIELD_INCLUDE = "include";
    public static final String FIELD_IDENTIFIER = "identifier_used";
    public static final String FIELD_IDENTIFIER_DECLARATION = "identifier_declaration";
    public static final String FIELD_NAMESPACE = "ns";
    public static final String FIELD_TRAIT = "trait";
    public static final String FIELD_USED_TRAIT = "usedtrait";
    public static final String FIELD_TRAIT_CONFLICT_RESOLUTION = "traitconf";
    public static final String FIELD_TRAIT_METHOD_ALIAS = "traitmeth";
    public static final String FIELD_VAR = "var";
    public static final String FIELD_TOP_LEVEL = "top";
    private static final List<String> ALL_FIELDS = new LinkedList<String>(Arrays.asList("base", "extend", "clz", "iface", "const", "clz.const", "field", "method", "constructor", "include", "identifier_used", "var", "top", "ns", "trait", "usedtrait", "traitconf", "traitmeth"));

    public static List<String> getAllFields() {
        return new LinkedList<String>(ALL_FIELDS);
    }

    protected void index(Indexable indexable, Parser.Result parserResult, Context context) {
        IndexingSupport support;
        PHPParseResult r = (PHPParseResult)parserResult;
        if (r.getProgram() == null) {
            return;
        }
        FileObject fileObject = r.getSnapshot().getSource().getFileObject();
        assert (r.getDiagnostics().isEmpty() || !PhpSourcePath.FileType.INTERNAL.equals((Object)PhpSourcePath.getFileType((FileObject)fileObject))) : fileObject.getPath();
        IndexQueryImpl.clearNamespaceCache();
        PhpTypeCompletionProviderWrapper.PhpTypeCompletionProvider.getInstance().clearCache();
        try {
            support = IndexingSupport.getInstance((Context)context);
        }
        catch (IOException ex) {
            LOG.log(Level.WARNING, null, ex);
            return;
        }
        Model model = r.getModel(Model.Type.COMMON);
        FileScope fileScope = model.getFileScope();
        for (TypeScope typeScope : ModelUtils.getDeclaredTypes(fileScope)) {
            IndexDocument indexDocument = support.createDocument(indexable);
            typeScope.addSelfToIndex(indexDocument);
            support.addDocument(indexDocument);
        }
        IndexDocument defaultDocument = support.createDocument(indexable);
        for (FunctionScope functionScope : ModelUtils.getDeclaredFunctions(fileScope)) {
            functionScope.addSelfToIndex(defaultDocument);
        }
        for (ConstantElement constantElement : ModelUtils.getDeclaredConstants(fileScope)) {
            constantElement.addSelfToIndex(defaultDocument);
        }
        for (NamespaceScope namespaceScope : fileScope.getDeclaredNamespaces()) {
            namespaceScope.addSelfToIndex(defaultDocument);
        }
        support.addDocument(defaultDocument);
        IndexDocument indexDocument = support.createDocument(indexable);
        Program program = r.getProgram();
        program.accept(new IdentifierVisitor(indexDocument));
        support.addDocument(indexDocument);
    }

    public static final class Factory
    extends EmbeddingIndexerFactory {
        public static final String NAME = "php";
        public static final int VERSION = 32;

        public EmbeddingIndexer createIndexer(Indexable indexable, Snapshot snapshot) {
            if (this.isIndexable(indexable, snapshot)) {
                return new PHPIndexer();
            }
            return null;
        }

        public String getIndexerName() {
            return NAME;
        }

        public int getIndexVersion() {
            return 32;
        }

        private boolean isIndexable(Indexable indexable, Snapshot snapshot) {
            FileObject fileObject = snapshot.getSource().getFileObject();
            return INDEXABLE_EXTENSIONS.contains(fileObject.getExt().toLowerCase());
        }

        public void filesDeleted(Iterable<? extends Indexable> deleted, Context context) {
            try {
                IndexingSupport is = IndexingSupport.getInstance((Context)context);
                for (Indexable indexable : deleted) {
                    is.removeDocuments(indexable);
                }
            }
            catch (IOException ioe) {
                LOG.log(Level.WARNING, null, ioe);
            }
        }

        public void rootsRemoved(Iterable<? extends URL> removedRoots) {
        }

        public void filesDirty(Iterable<? extends Indexable> dirty, Context context) {
            try {
                IndexingSupport is = IndexingSupport.getInstance((Context)context);
                for (Indexable indexable : dirty) {
                    is.markDirtyDocuments(indexable);
                }
            }
            catch (IOException ioe) {
                LOG.log(Level.WARNING, null, ioe);
            }
        }
    }

    private static final class IdentifierVisitor
    extends DefaultVisitor {
        private final IndexDocument identifierDocument;

        public IdentifierVisitor(IndexDocument identifierDocument) {
            this.identifierDocument = identifierDocument;
        }

        @Override
        public void visit(Program node) {
            this.scan(node.getStatements());
            this.scan(node.getComments());
        }

        @Override
        public void visit(Scalar scalar) {
            String stringValue = scalar.getStringValue();
            if (stringValue != null && stringValue.trim().length() > 0 && scalar.getScalarType() == Scalar.Type.STRING && !NavUtils.isQuoted(stringValue)) {
                this.addSignature(IdentifierSignatureFactory.create(stringValue));
            }
            super.visit(scalar);
        }

        @Override
        public void visit(Identifier identifier) {
            this.addSignature(IdentifierSignatureFactory.createIdentifier(identifier));
            super.visit(identifier);
        }

        @Override
        public void visit(PHPDocTypeNode node) {
            this.addSignature(IdentifierSignatureFactory.create(node));
            super.visit(node);
        }

        private void addSignature(IdentifierSignature signature) {
            signature.save(this.identifierDocument);
        }
    }
}

