/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.typinghooks;

import java.util.Arrays;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.lexer.TokenUtilities;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.php.editor.indent.IndentUtils;
import org.netbeans.modules.php.editor.lexer.LexUtilities;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;
import org.netbeans.modules.php.editor.options.OptionsUtils;
import org.netbeans.modules.php.editor.typinghooks.PhpCommentGenerator;
import org.netbeans.modules.php.editor.typinghooks.TypingHooksUtils;
import org.netbeans.spi.editor.typinghooks.TypedBreakInterceptor;

public class PhpTypedBreakInterceptor
implements TypedBreakInterceptor {
    static final boolean CONTINUE_COMMENTS = Boolean.getBoolean("php.cont.comment");
    private static Boolean INSERT_ASTERISK_TO_PHP_COMMENT = null;
    private PhpDocBodyGenerator phpDocBodyGenerator = PhpDocBodyGenerator.NONE;

    static void setInsertAsteriskToPHPComment(Boolean insert) {
        INSERT_ASTERISK_TO_PHP_COMMENT = insert;
    }

    public void insert(TypedBreakInterceptor.MutableContext context) throws BadLocationException {
        int begin;
        boolean insert;
        BaseDocument doc = (BaseDocument)context.getDocument();
        int offset = context.getCaretOffset();
        boolean insertMatching = TypingHooksUtils.isInsertMatchingEnabled();
        int lineBegin = LineDocumentUtils.getLineStart((LineDocument)doc, (int)offset);
        int lineEnd = LineDocumentUtils.getLineEnd((LineDocument)doc, (int)offset);
        if (lineBegin == offset && lineEnd == offset) {
            return;
        }
        TokenSequence<PHPTokenId> ts = LexUtilities.getPHPTokenSequence((Document)doc, offset);
        if (ts == null) {
            return;
        }
        ts.move(offset);
        if (!ts.moveNext() && !ts.movePrevious()) {
            return;
        }
        Token<? extends PHPTokenId> token = ts.token();
        TokenId id = token.id();
        int tokenOffsetOnCaret = ts.offset();
        int[] startOfContext = new int[1];
        PHPTokenId completeIn = insertMatching ? this.findContextForEnd(ts, offset, startOfContext) : null;
        boolean bl = insert = completeIn != null && this.isEndMissing(doc, offset, completeIn);
        if (insert) {
            boolean addSemicolon = PhpTypedBreakInterceptor.canBeAddedSemicolonAfterCloseBrace(completeIn, ts);
            int indent = org.netbeans.modules.editor.indent.api.IndentUtils.lineIndent((Document)doc, (int)org.netbeans.modules.editor.indent.api.IndentUtils.lineStartOffset((Document)doc, (int)startOfContext[0]));
            int afterLastNonWhite = LineDocumentUtils.getLineLastNonWhitespace((LineDocument)doc, (int)offset);
            StringBuilder sb = new StringBuilder("\n");
            if (offset > afterLastNonWhite || id == PHPTokenId.PHP_CLOSETAG || offset < afterLastNonWhite && "?>".equals(doc.getText(afterLastNonWhite - 1, 2))) {
                sb.append("\n");
                sb.append(PhpTypedBreakInterceptor.createIndentString(doc, offset, indent));
            } else {
                String restOfLine = doc.getText(offset, LineDocumentUtils.getLineEnd((LineDocument)doc, (int)afterLastNonWhite) - offset);
                sb.append(restOfLine);
                sb.append("\n");
                sb.append(PhpTypedBreakInterceptor.createIndentString(doc, offset, indent));
                doc.remove(offset, restOfLine.length());
            }
            if (id == PHPTokenId.PHP_CLOSETAG && offset > tokenOffsetOnCaret) {
                token = LexUtilities.findPreviousToken(ts, Arrays.asList(PHPTokenId.PHP_OPENTAG));
                String begin2 = token != null ? token.text().toString() : "<?php";
                sb.append(begin2);
                sb.append(" ");
            }
            if (completeIn == PHPTokenId.PHP_CURLY_OPEN || completeIn == PHPTokenId.PHP_CLASS || completeIn == PHPTokenId.PHP_FUNCTION || completeIn == PHPTokenId.PHP_USE) {
                sb.append("}");
                if (addSemicolon) {
                    sb.append(";");
                }
            } else if (completeIn == PHPTokenId.PHP_TRY) {
                sb.append("} catch (Exception $ex) {\n\n").append(PhpTypedBreakInterceptor.createIndentString(doc, offset, indent)).append("}");
            } else if (completeIn == PHPTokenId.PHP_IF || completeIn == PHPTokenId.PHP_ELSE || completeIn == PHPTokenId.PHP_ELSEIF) {
                sb.append("endif;");
            } else if (completeIn == PHPTokenId.PHP_FOR) {
                sb.append("endfor;");
            } else if (completeIn == PHPTokenId.PHP_FOREACH) {
                sb.append("endforeach;");
            } else if (completeIn == PHPTokenId.PHP_WHILE) {
                sb.append("endwhile;");
            } else if (completeIn == PHPTokenId.PHP_SWITCH) {
                sb.append("endswitch;");
            }
            if (id == PHPTokenId.PHP_CLOSETAG && offset > tokenOffsetOnCaret) {
                sb.append(" ?>");
            }
            if (id == PHPTokenId.PHP_CLOSETAG) {
                sb.append("\n");
            }
            context.setText(sb.toString(), 0, 1, new int[0]);
            return;
        }
        if (id == PHPTokenId.PHP_CURLY_CLOSE || LexUtilities.textEquals(token.text(), ']') || LexUtilities.textEquals(token.text(), ')')) {
            int indent = GsfUtilities.getLineIndent((BaseDocument)doc, (int)offset);
            StringBuilder sb = new StringBuilder("\n");
            if ((LexUtilities.textEquals(token.text(), ')') || LexUtilities.textEquals(token.text(), ']')) && ts.movePrevious()) {
                Token<? extends PHPTokenId> helpToken = LexUtilities.findPrevious(ts, Arrays.asList(PHPTokenId.WHITESPACE, PHPTokenId.PHPDOC_COMMENT, PHPTokenId.PHPDOC_COMMENT_END, PHPTokenId.PHPDOC_COMMENT_START, PHPTokenId.PHP_COMMENT, PHPTokenId.PHP_COMMENT_END, PHPTokenId.PHP_COMMENT_START, PHPTokenId.PHP_LINE_COMMENT));
                if (helpToken.id() == PHPTokenId.PHP_TOKEN && (helpToken.text().charAt(0) == ',' || helpToken.text().charAt(0) == '(' || helpToken.text().charAt(0) == '[') && ts.movePrevious()) {
                    if (helpToken.text().charAt(0) == '[') {
                        sb.append("\n");
                    } else if (helpToken.text().charAt(0) == '(') {
                        sb.append("\n");
                    } else {
                        helpToken = LexUtilities.findPrevious(ts, Arrays.asList(PHPTokenId.WHITESPACE, PHPTokenId.PHPDOC_COMMENT, PHPTokenId.PHPDOC_COMMENT_END, PHPTokenId.PHPDOC_COMMENT_START, PHPTokenId.PHP_COMMENT, PHPTokenId.PHP_COMMENT_END, PHPTokenId.PHP_COMMENT_START, PHPTokenId.PHP_LINE_COMMENT));
                        if (helpToken.id() == PHPTokenId.PHP_ARRAY || helpToken.id() == PHPTokenId.PHP_TOKEN && helpToken.text().charAt(0) == '[') {
                            sb.append("\n");
                        }
                    }
                } else if (helpToken.id() == PHPTokenId.PHP_ATTRIBUTE) {
                    sb.append("\n");
                }
                sb.append(org.netbeans.modules.editor.indent.api.IndentUtils.createIndentString((Document)doc, (int)indent));
            } else {
                LexUtilities.findPreviousToken(ts, Arrays.asList(PHPTokenId.PHP_CURLY_OPEN));
                sb.append("\n");
                sb.append(org.netbeans.modules.editor.indent.api.IndentUtils.createIndentString((Document)doc, (int)GsfUtilities.getLineIndent((BaseDocument)doc, (int)ts.offset())));
            }
            context.setText(sb.toString(), 0, sb.lastIndexOf("\n") != 0 ? sb.lastIndexOf("\n") : sb.toString().length(), new int[0]);
            return;
        }
        if (id == PHPTokenId.WHITESPACE && (begin = Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)offset)) != -1 && offset < begin) {
            ts.move(begin);
            if (ts.moveNext() && ((id = ts.token().id()) == PHPTokenId.PHP_LINE_COMMENT || id == PHPTokenId.PHPDOC_COMMENT_START || id == PHPTokenId.PHP_COMMENT_START)) {
                offset = begin;
            }
        }
        if (id == PHPTokenId.PHP_LINE_COMMENT) {
            Token<? extends PHPTokenId> firstToken;
            int prevBegin;
            boolean continueComment = false;
            int begin3 = LineDocumentUtils.getLineFirstNonWhitespace((LineDocument)doc, (int)offset);
            boolean previousLineWasComment = false;
            int rowStart = LineDocumentUtils.getLineStart((LineDocument)doc, (int)offset);
            if (rowStart > 0 && (prevBegin = LineDocumentUtils.getLineFirstNonWhitespace((LineDocument)doc, (int)(rowStart - 1))) != -1 && (firstToken = LexUtilities.getToken(doc, prevBegin)) != null && firstToken.id() == PHPTokenId.PHP_LINE_COMMENT) {
                previousLineWasComment = true;
            }
            if (previousLineWasComment || offset > begin3) {
                Token<? extends PHPTokenId> firstToken2;
                int nextLineFirst;
                int nextLine;
                Token<? extends PHPTokenId> firstToken3;
                if (ts.offset() + token.length() > offset + 1) {
                    String trailing = doc.getText(offset, LineDocumentUtils.getLineEnd((LineDocument)doc, (int)offset) - offset);
                    if (trailing.trim().length() != 0 && !trailing.startsWith("//")) {
                        continueComment = true;
                    }
                } else if (CONTINUE_COMMENTS && (firstToken3 = LexUtilities.getToken(doc, begin3)) != null && firstToken3.id() == PHPTokenId.PHP_LINE_COMMENT) {
                    continueComment = true;
                }
                if (!continueComment && (nextLine = LineDocumentUtils.getLineEnd((LineDocument)doc, (int)offset) + 1) < doc.getLength() && (nextLineFirst = Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)nextLine)) != -1 && (firstToken2 = LexUtilities.getToken(doc, nextLineFirst)) != null && firstToken2.id() == PHPTokenId.PHP_LINE_COMMENT) {
                    continueComment = true;
                }
            }
            if (continueComment) {
                char c;
                int indent = GsfUtilities.getLineIndent((BaseDocument)doc, (int)offset);
                StringBuilder sb = new StringBuilder("\n");
                sb.append(org.netbeans.modules.editor.indent.api.IndentUtils.createIndentString((Document)doc, (int)indent));
                String commentDelimiter = "//";
                boolean moved = true;
                while (moved && ts.token() != null && ts.token().id() == PHPTokenId.PHP_LINE_COMMENT && !PhpTypedBreakInterceptor.isLineCommentDelimiter((Token<? extends PHPTokenId>)ts.token())) {
                    moved = ts.movePrevious();
                }
                if (PhpTypedBreakInterceptor.isLineCommentDelimiter((Token<? extends PHPTokenId>)ts.token())) {
                    commentDelimiter = ts.token().text().toString();
                }
                sb.append(commentDelimiter);
                int afterHash = begin3 + commentDelimiter.length();
                String line = doc.getText(afterHash, LineDocumentUtils.getLineEnd((LineDocument)doc, (int)afterHash) - afterHash);
                for (int i = 0; i < line.length() && ((c = line.charAt(i)) == ' ' || c == '\t'); ++i) {
                    sb.append(c);
                }
                context.setText(sb.toString(), 0, sb.length(), new int[0]);
                return;
            }
        }
        if (id == PHPTokenId.PHPDOC_COMMENT || id == PHPTokenId.PHPDOC_COMMENT_START && offset > ts.offset() || id == PHPTokenId.PHPDOC_COMMENT_END) {
            Object[] ret = PhpTypedBreakInterceptor.beforeBreakInComments(doc, ts, offset, PHPTokenId.PHPDOC_COMMENT_START, PHPTokenId.PHPDOC_COMMENT, PHPTokenId.PHPDOC_COMMENT_END, context);
            boolean isEmptyComment = (Boolean)ret[1];
            if (isEmptyComment) {
                int indent = GsfUtilities.getLineIndent((BaseDocument)doc, (int)ts.offset());
                this.phpDocBodyGenerator = new PhpDocBodyGeneratorImpl((Integer)ret[0], indent);
            }
            return;
        }
        if (!(id != PHPTokenId.PHP_COMMENT && id != PHPTokenId.PHP_COMMENT_START && id != PHPTokenId.PHP_COMMENT_END || id == PHPTokenId.PHP_COMMENT_START && offset == ts.offset())) {
            PhpTypedBreakInterceptor.beforeBreakInComments(doc, ts, offset, PHPTokenId.PHP_COMMENT_START, PHPTokenId.PHP_COMMENT, PHPTokenId.PHP_COMMENT_END, context);
            return;
        }
        if (OptionsUtils.autoStringConcatination() && this.concatPossibleStringToken(ts, offset, tokenOffsetOnCaret)) {
            char stringDelimiter = PhpTypedBreakInterceptor.extractStringDelimiter(ts);
            String concatString = stringDelimiter + "\n . " + stringDelimiter;
            context.setText(concatString, 1, concatString.length(), new int[]{2, concatString.length() - 1});
        }
    }

    private static String createIndentString(BaseDocument doc, int offset, int previousIndent) {
        return org.netbeans.modules.editor.indent.api.IndentUtils.createIndentString((Document)doc, (int)IndentUtils.countIndent(doc, offset, previousIndent));
    }

    private static boolean isLineCommentDelimiter(Token<? extends PHPTokenId> token) {
        return token != null && token.id() == PHPTokenId.PHP_LINE_COMMENT && (TokenUtilities.textEquals((CharSequence)token.text(), (CharSequence)"//") || TokenUtilities.textEquals((CharSequence)token.text(), (CharSequence)"#"));
    }

    private static boolean canBeAddedSemicolonAfterCloseBrace(PHPTokenId completeIn, TokenSequence<? extends PHPTokenId> ts) {
        return PhpTypedBreakInterceptor.canBeAddedSemicolonAfterGroupUseCloseBrace(completeIn, ts) || PhpTypedBreakInterceptor.canBeAddedSemicolonAfterMatchExpressionCloseBrace(ts);
    }

    private static boolean canBeAddedSemicolonAfterGroupUseCloseBrace(PHPTokenId completeIn, TokenSequence<? extends PHPTokenId> ts) {
        return completeIn == PHPTokenId.PHP_USE && PhpTypedBreakInterceptor.isGroupUseCurlyOpen(ts);
    }

    public void afterInsert(TypedBreakInterceptor.Context context) throws BadLocationException {
        this.phpDocBodyGenerator.generate((BaseDocument)context.getDocument());
        this.phpDocBodyGenerator = PhpDocBodyGenerator.NONE;
    }

    private PHPTokenId findContextForEnd(TokenSequence<? extends PHPTokenId> ts, int offset, int[] startOfContext) {
        if (ts == null) {
            return null;
        }
        if (ts.offset() != offset) {
            ts.move(offset);
            if (!ts.moveNext() && !ts.movePrevious()) {
                return null;
            }
        }
        PHPTokenId result = null;
        PHPTokenId previousToken = null;
        if (ts.movePrevious()) {
            previousToken = (PHPTokenId)ts.token().id();
            ts.moveNext();
        }
        if (previousToken == PHPTokenId.PHPDOC_COMMENT_START || previousToken == PHPTokenId.PHP_COMMENT_START) {
            return null;
        }
        boolean foundQuestionMark = false;
        Token<? extends PHPTokenId> bracketColumnToken = LexUtilities.findPrevious(ts, Arrays.asList(PHPTokenId.PHP_COMMENT, PHPTokenId.PHP_COMMENT_END, PHPTokenId.PHP_COMMENT_START, PHPTokenId.PHPDOC_COMMENT_START, PHPTokenId.PHPDOC_COMMENT, PHPTokenId.PHPDOC_COMMENT_END, PHPTokenId.PHP_LINE_COMMENT, PHPTokenId.WHITESPACE, PHPTokenId.PHP_CLOSETAG));
        if (bracketColumnToken != null && (bracketColumnToken.id() == PHPTokenId.PHP_CURLY_OPEN || bracketColumnToken.id() == PHPTokenId.PHP_TOKEN && TokenUtilities.textEquals((CharSequence)ts.token().text(), (CharSequence)":"))) {
            startOfContext[0] = ts.offset();
            List<PHPTokenId> lookFor = Arrays.asList(PHPTokenId.PHP_CURLY_CLOSE, PHPTokenId.PHP_CLASS, PHPTokenId.PHP_FUNCTION, PHPTokenId.PHP_USE, PHPTokenId.PHP_IF, PHPTokenId.PHP_ELSE, PHPTokenId.PHP_ELSEIF, PHPTokenId.PHP_FOR, PHPTokenId.PHP_FOREACH, PHPTokenId.PHP_TRY, PHPTokenId.PHP_DO, PHPTokenId.PHP_WHILE, PHPTokenId.PHP_TOKEN, PHPTokenId.PHP_SWITCH, PHPTokenId.PHP_CASE, PHPTokenId.PHP_OPENTAG, PHPTokenId.PHP_DEFAULT, PHPTokenId.PHP_MATCH);
            Token<? extends PHPTokenId> keyToken = LexUtilities.findPreviousToken(ts, lookFor);
            while (keyToken.id() == PHPTokenId.PHP_TOKEN) {
                if (TokenUtilities.textEquals((CharSequence)keyToken.text(), (CharSequence)"?")) {
                    foundQuestionMark = true;
                }
                ts.movePrevious();
                keyToken = LexUtilities.findPreviousToken(ts, lookFor);
            }
            if (keyToken.id() == PHPTokenId.PHP_CASE || keyToken.id() == PHPTokenId.PHP_DEFAULT) {
                return null;
            }
            if (bracketColumnToken.id() == PHPTokenId.PHP_CURLY_OPEN) {
                if (keyToken.id() == PHPTokenId.PHP_CLASS || keyToken.id() == PHPTokenId.PHP_TRY) {
                    result = (PHPTokenId)keyToken.id();
                } else if (keyToken.id() == PHPTokenId.PHP_FUNCTION) {
                    Token<? extends PHPTokenId> useToken = PhpTypedBreakInterceptor.findPreviousKeyToken(ts, PHPTokenId.PHP_USE);
                    if (useToken != null) {
                        keyToken = useToken;
                    }
                    result = (PHPTokenId)keyToken.id();
                } else if (keyToken.id() == PHPTokenId.PHP_USE) {
                    Token<? extends PHPTokenId> functionToken = PhpTypedBreakInterceptor.findPreviousKeyToken(ts, PHPTokenId.PHP_FUNCTION);
                    if (functionToken != null) {
                        keyToken = functionToken;
                    }
                    result = (PHPTokenId)keyToken.id();
                } else {
                    result = PHPTokenId.PHP_CURLY_OPEN;
                }
            } else if (bracketColumnToken.id() == PHPTokenId.PHP_TOKEN && TokenUtilities.textEquals((CharSequence)bracketColumnToken.text(), (CharSequence)":") && keyToken.id() != PHPTokenId.PHP_OPENTAG && keyToken.id() != PHPTokenId.PHP_CLASS && keyToken.id() != PHPTokenId.PHP_FUNCTION) {
                result = (PHPTokenId)keyToken.id();
            }
            if (keyToken.id() != PHPTokenId.PHP_CURLY_CLOSE && keyToken.id() != PHPTokenId.PHP_SEMICOLON) {
                startOfContext[0] = ts.offset();
            }
        }
        ts.move(offset);
        if (!ts.moveNext() && !ts.movePrevious()) {
            return null;
        }
        if (foundQuestionMark && result != PHPTokenId.PHP_FUNCTION) {
            return null;
        }
        return result;
    }

    private boolean isEndMissing(BaseDocument doc, int offset, PHPTokenId startTokenId) throws BadLocationException {
        TokenSequence<PHPTokenId> ts = LexUtilities.getPHPTokenSequence((Document)doc, offset);
        if (ts == null) {
            return false;
        }
        ts.move(0);
        if (!ts.moveNext() && !ts.movePrevious()) {
            return false;
        }
        int curlyBalance = 0;
        boolean curlyProcessed = false;
        if (startTokenId == PHPTokenId.PHP_CURLY_OPEN || startTokenId == PHPTokenId.PHP_FUNCTION || startTokenId == PHPTokenId.PHP_CLASS || startTokenId == PHPTokenId.PHP_TRY || startTokenId == PHPTokenId.PHP_USE) {
            boolean unfinishedComment = false;
            do {
                Token token;
                if ((token = ts.token()).id() == PHPTokenId.PHP_CURLY_CLOSE) {
                    --curlyBalance;
                    curlyProcessed = true;
                    continue;
                }
                if (token.id() == PHPTokenId.PHP_CURLY_OPEN || token.id() == PHPTokenId.PHP_TOKEN && TokenUtilities.textEquals((CharSequence)token.text(), (CharSequence)"${")) {
                    ++curlyBalance;
                    curlyProcessed = true;
                    continue;
                }
                if (token.id() == PHPTokenId.PHP_COMMENT_START || token.id() == PHPTokenId.PHPDOC_COMMENT_START) {
                    unfinishedComment = true;
                    continue;
                }
                if (token.id() != PHPTokenId.PHP_COMMENT_END && token.id() != PHPTokenId.PHPDOC_COMMENT_END) continue;
                unfinishedComment = false;
            } while ((curlyBalance != 0 || !curlyProcessed || ts.offset() <= offset) && ts.moveNext());
            if (unfinishedComment) {
                --curlyBalance;
            }
        } else {
            PHPTokenId endTokenId = null;
            if (startTokenId == PHPTokenId.PHP_FOR) {
                endTokenId = PHPTokenId.PHP_ENDFOR;
            } else if (startTokenId == PHPTokenId.PHP_FOREACH) {
                endTokenId = PHPTokenId.PHP_ENDFOREACH;
            } else if (startTokenId == PHPTokenId.PHP_WHILE) {
                endTokenId = PHPTokenId.PHP_ENDWHILE;
            } else if (startTokenId == PHPTokenId.PHP_SWITCH) {
                endTokenId = PHPTokenId.PHP_ENDSWITCH;
            } else if (startTokenId == PHPTokenId.PHP_IF) {
                endTokenId = PHPTokenId.PHP_ENDIF;
            } else if (startTokenId == PHPTokenId.PHP_ELSE || startTokenId == PHPTokenId.PHP_ELSEIF) {
                startTokenId = PHPTokenId.PHP_IF;
                endTokenId = PHPTokenId.PHP_ENDIF;
            }
            ts.move(0);
            if (!ts.moveNext() && !ts.movePrevious()) {
                return false;
            }
            int balance = 0;
            boolean checkAlternativeSyntax = false;
            do {
                Token token;
                if ((token = ts.token()).id() == PHPTokenId.PHP_CURLY_CLOSE) {
                    --curlyBalance;
                    continue;
                }
                if (token.id() == PHPTokenId.PHP_CURLY_OPEN) {
                    ++curlyBalance;
                    checkAlternativeSyntax = false;
                    continue;
                }
                if (token.id() == startTokenId) {
                    checkAlternativeSyntax = true;
                    continue;
                }
                if (token.id() == PHPTokenId.PHP_TOKEN && TokenUtilities.textEquals((CharSequence)token.text(), (CharSequence)":") && checkAlternativeSyntax) {
                    ++balance;
                    checkAlternativeSyntax = false;
                    continue;
                }
                if (token.id() != endTokenId) continue;
                --balance;
            } while (ts.moveNext() && curlyBalance > -1 && balance > -1);
            return balance > 0;
        }
        return curlyBalance > 0;
    }

    private boolean concatPossibleStringToken(TokenSequence<? extends PHPTokenId> ts, int offset, int tokenOffsetOnCaret) {
        Token token;
        assert (ts != null);
        boolean concat = false;
        if (!PhpTypedBreakInterceptor.isPartOfHereOrNowDoc(ts) && (token = ts.token()) != null) {
            concat = PhpTypedBreakInterceptor.concatCurrentStringToken(ts, offset, tokenOffsetOnCaret);
            PHPTokenId id = (PHPTokenId)token.id();
            if (!concat && id != PHPTokenId.PHP_SEMICOLON && ts.movePrevious()) {
                concat = PhpTypedBreakInterceptor.concatCurrentStringToken(ts, offset, tokenOffsetOnCaret);
            }
        }
        return concat;
    }

    private static boolean concatCurrentStringToken(TokenSequence<? extends PHPTokenId> ts, int offset, int tokenOffsetOnCaret) {
        assert (ts != null);
        boolean concat = false;
        Token token = ts.token();
        if (token != null) {
            PHPTokenId id = (PHPTokenId)token.id();
            if (TypingHooksUtils.isStringToken((Token<? extends PHPTokenId>)token) && !PhpTypedBreakInterceptor.isMultiline((Token<? extends PHPTokenId>)token)) {
                boolean bl = concat = offset != tokenOffsetOnCaret || id == PHPTokenId.PHP_ENCAPSED_AND_WHITESPACE && token.length() != 1;
                if (token.length() == 1) {
                    Token followingToken;
                    int original = ts.offset();
                    while (ts.moveNext() && (followingToken = ts.token()) != null) {
                        PHPTokenId followingTokenId = (PHPTokenId)followingToken.id();
                        if (followingTokenId == PHPTokenId.WHITESPACE) continue;
                        concat = !TypingHooksUtils.isStringToken((Token<? extends PHPTokenId>)followingToken) && followingTokenId != PHPTokenId.PHP_CLOSETAG;
                        break;
                    }
                    ts.move(original);
                    ts.moveNext();
                }
            }
        }
        return concat;
    }

    private static boolean isMultiline(Token<? extends PHPTokenId> token) {
        assert (token != null);
        return TokenUtilities.indexOf((CharSequence)token.text(), (int)10) != -1;
    }

    private static boolean isPartOfHereOrNowDoc(TokenSequence<? extends PHPTokenId> ts) {
        boolean result = false;
        int originalOffset = ts.offset();
        Token token = ts.token();
        if (token != null && TypingHooksUtils.isStringToken((Token<? extends PHPTokenId>)token)) {
            while (ts.movePrevious()) {
                token = ts.token();
                if (token == null || TypingHooksUtils.isStringToken((Token<? extends PHPTokenId>)token)) continue;
                PHPTokenId tokenId = (PHPTokenId)token.id();
                if (tokenId == PHPTokenId.PHP_HEREDOC_TAG_START || tokenId == PHPTokenId.PHP_NOWDOC_TAG_START) {
                    result = true;
                    break;
                }
                if (tokenId != PHPTokenId.PHP_HEREDOC_TAG_END && tokenId != PHPTokenId.PHP_NOWDOC_TAG_END) continue;
                break;
            }
        }
        ts.move(originalOffset);
        ts.moveNext();
        return result;
    }

    private static char extractStringDelimiter(TokenSequence<? extends PHPTokenId> ts) {
        assert (ts != null);
        Token token = ts.token();
        PHPTokenId id = (PHPTokenId)token.id();
        if (TypingHooksUtils.isStringToken((Token<? extends PHPTokenId>)token)) {
            return id == PHPTokenId.PHP_ENCAPSED_AND_WHITESPACE ? (char)'\"' : token.text().charAt(0);
        }
        if (ts.movePrevious()) {
            token = ts.token();
            id = (PHPTokenId)token.id();
            ts.moveNext();
            if (TypingHooksUtils.isStringToken((Token<? extends PHPTokenId>)token)) {
                return id == PHPTokenId.PHP_ENCAPSED_AND_WHITESPACE ? (char)'\"' : token.text().charAt(0);
            }
            throw new IllegalArgumentException();
        }
        throw new IllegalArgumentException();
    }

    private static Object[] beforeBreakInComments(BaseDocument doc, TokenSequence<? extends PHPTokenId> ts, int offset, PHPTokenId commentStart, PHPTokenId commentBody, PHPTokenId commentEnd, TypedBreakInterceptor.MutableContext context) throws BadLocationException {
        PHPTokenId id = (PHPTokenId)ts.token().id();
        boolean insertAsterisk = PhpTypedBreakInterceptor.insertAsterisk(commentStart);
        if (id == commentBody || id == commentStart) {
            int newCaretOffset;
            int insertOffset = id == commentStart ? ts.offset() + ts.token().length() : offset;
            if (insertOffset > doc.getLength()) {
                insertOffset = doc.getLength();
            }
            int indent = GsfUtilities.getLineIndent((BaseDocument)doc, (int)ts.offset());
            int afterLastNonWhite = LineDocumentUtils.getLineLastNonWhitespace((LineDocument)doc, (int)insertOffset);
            boolean addClosingTag = !PhpTypedBreakInterceptor.isClosedComment(DocumentUtilities.getText((Document)doc), insertOffset);
            StringBuilder sb = new StringBuilder("\n");
            if (offset > afterLastNonWhite) {
                sb.append(org.netbeans.modules.editor.indent.api.IndentUtils.createIndentString((Document)doc, (int)indent));
                if (insertAsterisk) {
                    sb.append(" * ");
                }
                newCaretOffset = sb.length();
            } else {
                String restOfLine = doc.getText(insertOffset, LineDocumentUtils.getLineEnd((LineDocument)doc, (int)afterLastNonWhite) - insertOffset);
                sb.append(org.netbeans.modules.editor.indent.api.IndentUtils.createIndentString((Document)doc, (int)indent));
                if (insertAsterisk) {
                    sb.append(" * ");
                }
                newCaretOffset = sb.length();
                sb.append(restOfLine);
                doc.remove(insertOffset, restOfLine.length());
            }
            if (addClosingTag) {
                sb.append("\n");
                sb.append(org.netbeans.modules.editor.indent.api.IndentUtils.createIndentString((Document)doc, (int)indent));
                if (insertAsterisk) {
                    sb.append(" */");
                } else {
                    sb.append("*/");
                }
            }
            context.setText(sb.toString(), 0, newCaretOffset, new int[0]);
            return new Object[]{insertOffset + newCaretOffset, addClosingTag};
        }
        if (id == commentEnd) {
            int insertOffset = ts.offset();
            if (ts.movePrevious()) {
                assert (ts.token().id() == commentBody || ts.token().id() == commentStart) : "PHP_COMMENT_END should not be preceeded by " + ((PHPTokenId)ts.token().id()).name();
            } else assert (false) : "PHP_COMMENT_END without PHP_COMMENT or PHP_COMMENT_START";
            int indent = GsfUtilities.getLineIndent((BaseDocument)doc, (int)ts.offset());
            int beforeFirstNonWhite = Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)insertOffset);
            int rowStart = LineDocumentUtils.getLineStart((LineDocument)doc, (int)insertOffset);
            StringBuilder sb = new StringBuilder("\n");
            int newCaretOffset = 1;
            int newCaretOffset2 = insertOffset;
            if (beforeFirstNonWhite >= insertOffset) {
                sb.append(org.netbeans.modules.editor.indent.api.IndentUtils.createIndentString((Document)doc, (int)indent));
                if (insertAsterisk) {
                    sb.append(" * ");
                }
                newCaretOffset = sb.length();
                newCaretOffset2 = rowStart + newCaretOffset;
                sb.append(org.netbeans.modules.editor.indent.api.IndentUtils.createIndentString((Document)doc, (int)indent));
                sb.append(" ");
                doc.remove(rowStart, insertOffset - rowStart);
            } else {
                sb.append(org.netbeans.modules.editor.indent.api.IndentUtils.createIndentString((Document)doc, (int)indent));
                sb.append(" ");
            }
            context.setText(sb.toString(), 0, newCaretOffset, new int[0]);
            return new Object[]{newCaretOffset2, false};
        }
        return new Object[]{-1, false};
    }

    private static boolean insertAsterisk(PHPTokenId commentStart) {
        return commentStart == PHPTokenId.PHPDOC_COMMENT_START || commentStart == PHPTokenId.PHP_COMMENT_START && PhpTypedBreakInterceptor.insertAsteriskToPHPComment();
    }

    private static boolean insertAsteriskToPHPComment() {
        if (INSERT_ASTERISK_TO_PHP_COMMENT != null) {
            return INSERT_ASTERISK_TO_PHP_COMMENT;
        }
        return OptionsUtils.autoCompletionCommentAsterisk();
    }

    private static boolean isClosedComment(CharSequence txt, int pos) {
        int length = txt.length();
        int quotation = 0;
        int simpleQuotation = 0;
        for (int i = pos; i < length; ++i) {
            char c = txt.charAt(i);
            if (c == '*' && i < length - 1 && txt.charAt(i + 1) == '/') {
                char cc;
                if (quotation == 0 && simpleQuotation == 0 && i < length - 2) {
                    return true;
                }
                boolean isClosed = true;
                for (int j = i + 2; j < length && (cc = txt.charAt(j)) != '\n'; ++j) {
                    if (cc == '\"' && j < length - 1 && txt.charAt(j + 1) != '\'') {
                        isClosed = false;
                        break;
                    }
                    if (cc != '\'' || j >= length - 1) continue;
                    isClosed = false;
                    break;
                }
                if (!isClosed) continue;
                return true;
            }
            if (c == '/' && i < length - 1 && txt.charAt(i + 1) == '*') {
                return false;
            }
            if (c == '\n') {
                quotation = 0;
                simpleQuotation = 0;
                continue;
            }
            if (c == '\"' && i < length - 1 && txt.charAt(i + 1) != '\'') {
                ++quotation;
                quotation %= 2;
                continue;
            }
            if (c != '\'' || i >= length - 1) continue;
            ++simpleQuotation;
            simpleQuotation %= 2;
        }
        return false;
    }

    static boolean isEndMissing(BaseDocument doc, int offset, boolean skipJunk, boolean[] insertEndResult, boolean[] insertRBraceResult, int[] startOffsetResult, int[] indentResult, PHPTokenId insertingEnd) throws BadLocationException {
        TokenSequence<PHPTokenId> ts;
        if (startOffsetResult != null) {
            startOffsetResult[0] = Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)offset);
        }
        if ((ts = LexUtilities.getPHPTokenSequence((Document)doc, offset)) == null) {
            return false;
        }
        ts.move(offset);
        if (!ts.moveNext() && !ts.movePrevious()) {
            return false;
        }
        Token token = ts.token();
        int balance = 1;
        boolean endOfFile = false;
        if (insertingEnd == PHPTokenId.PHP_CURLY_CLOSE) {
            while (!(token.id() != PHPTokenId.PHP_CURLY_OPEN && token.id() != PHPTokenId.PHP_CURLY_CLOSE && token.id() != PHPTokenId.WHITESPACE || endOfFile)) {
                if (token.id() == PHPTokenId.PHP_CURLY_OPEN) {
                    ++balance;
                } else if (token.id() == PHPTokenId.PHP_CURLY_CLOSE) {
                    --balance;
                }
                if (ts.moveNext()) {
                    token = ts.token();
                    continue;
                }
                endOfFile = true;
            }
            if (endOfFile && balance == 1) {
                return true;
            }
        }
        return false;
    }

    @CheckForNull
    private static Token<? extends PHPTokenId> findPreviousKeyToken(TokenSequence<? extends PHPTokenId> ts, PHPTokenId id) {
        Token<? extends PHPTokenId> result = null;
        int originalOffset = ts.offset();
        List<PHPTokenId> lookFor = Arrays.asList(PHPTokenId.PHP_SEMICOLON, PHPTokenId.PHP_CURLY_CLOSE, id);
        Token<? extends PHPTokenId> previousToken = LexUtilities.findPreviousToken(ts, lookFor);
        if (previousToken != null && previousToken.id() == id) {
            result = previousToken;
        } else {
            ts.move(originalOffset);
            ts.moveNext();
        }
        return result;
    }

    private static boolean canBeAddedSemicolonAfterMatchExpressionCloseBrace(TokenSequence<? extends PHPTokenId> ts) {
        PHPTokenId tokenId;
        boolean result = false;
        int originalOffset = ts.offset();
        int curlyBalance = 0;
        while (ts.movePrevious() && (tokenId = (PHPTokenId)ts.token().id()) != PHPTokenId.PHP_SEMICOLON) {
            if (tokenId == PHPTokenId.PHP_MATCH && ts.movePrevious()) {
                if (curlyBalance != 1) break;
                List<PHPTokenId> ignores = Arrays.asList(PHPTokenId.PHPDOC_COMMENT_START, PHPTokenId.PHPDOC_COMMENT, PHPTokenId.PHPDOC_COMMENT_END, PHPTokenId.PHP_COMMENT_START, PHPTokenId.PHP_COMMENT, PHPTokenId.PHP_COMMENT_END, PHPTokenId.PHP_LINE_COMMENT, PHPTokenId.WHITESPACE);
                Token<? extends PHPTokenId> token = LexUtilities.findPrevious(ts, ignores);
                if (token.id() == PHPTokenId.PHP_RETURN || token.id() == PHPTokenId.PHP_ECHO) {
                    result = true;
                    break;
                }
                if (token.id() != PHPTokenId.PHP_OPERATOR || !TokenUtilities.textEquals((CharSequence)token.text(), (CharSequence)"=") || !ts.movePrevious() || (token = LexUtilities.findPrevious(ts, ignores)).id() != PHPTokenId.PHP_VARIABLE || !ts.movePrevious() || (token = LexUtilities.findPrevious(ts, ignores)).id() != PHPTokenId.PHP_SEMICOLON && token.id() != PHPTokenId.PHP_CURLY_OPEN && token.id() != PHPTokenId.PHP_CURLY_CLOSE && token.id() != PHPTokenId.PHP_OPENTAG) break;
                result = true;
                break;
            }
            if (tokenId == PHPTokenId.PHP_CURLY_OPEN) {
                ++curlyBalance;
                continue;
            }
            if (tokenId != PHPTokenId.PHP_CURLY_CLOSE) continue;
            --curlyBalance;
        }
        ts.move(originalOffset);
        ts.moveNext();
        return result;
    }

    private static boolean isGroupUseCurlyOpen(TokenSequence<? extends PHPTokenId> ts) {
        boolean result = false;
        int originalOffset = ts.offset();
        while (ts.movePrevious()) {
            PHPTokenId tokenId = (PHPTokenId)ts.token().id();
            if (tokenId == PHPTokenId.WHITESPACE || tokenId == PHPTokenId.PHP_CURLY_OPEN || PhpTypedBreakInterceptor.isComment(tokenId)) continue;
            if (tokenId != PHPTokenId.PHP_NS_SEPARATOR) break;
            result = true;
            break;
        }
        ts.move(originalOffset);
        ts.moveNext();
        return result;
    }

    private static boolean isComment(PHPTokenId tokenId) {
        return tokenId == PHPTokenId.PHP_COMMENT_START || tokenId == PHPTokenId.PHP_COMMENT || tokenId == PHPTokenId.PHP_COMMENT_END || tokenId == PHPTokenId.PHPDOC_COMMENT_START || tokenId == PHPTokenId.PHPDOC_COMMENT || tokenId == PHPTokenId.PHPDOC_COMMENT_END || tokenId == PHPTokenId.PHP_LINE_COMMENT;
    }

    public boolean beforeInsert(TypedBreakInterceptor.Context context) throws BadLocationException {
        return false;
    }

    public void cancelled(TypedBreakInterceptor.Context context) {
    }

    public static class PhpDocFactory
    implements TypedBreakInterceptor.Factory {
        public TypedBreakInterceptor createTypedBreakInterceptor(MimePath mimePath) {
            return new PhpTypedBreakInterceptor();
        }
    }

    public static class PhpFactory
    implements TypedBreakInterceptor.Factory {
        public TypedBreakInterceptor createTypedBreakInterceptor(MimePath mimePath) {
            return new PhpTypedBreakInterceptor();
        }
    }

    private static final class PhpDocBodyGeneratorImpl
    implements PhpDocBodyGenerator {
        private final int offset;
        private final int indent;

        public PhpDocBodyGeneratorImpl(int offset, int indent) {
            this.offset = offset;
            this.indent = indent;
        }

        @Override
        public void generate(BaseDocument baseDocument) {
            PhpCommentGenerator.generateDocTags(baseDocument, this.offset, this.indent);
        }
    }

    private static interface PhpDocBodyGenerator {
        public static final PhpDocBodyGenerator NONE = new PhpDocBodyGenerator(){

            @Override
            public void generate(BaseDocument baseDocument) {
            }
        };

        public void generate(BaseDocument var1);
    }
}

