/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.spi.support.CancelSupport;
import org.netbeans.modules.php.editor.model.FileScope;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.AttributeDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ClassInstanceCreation;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.NamedArgument;
import org.netbeans.modules.php.editor.parser.astnodes.Variadic;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.netbeans.modules.php.editor.verification.Bundle;
import org.netbeans.modules.php.editor.verification.HintErrorRule;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;
import org.openide.filesystems.FileObject;

public class IncorrectNamedArgumentsHintError
extends HintErrorRule {
    private FileObject fileObject;

    public String getDisplayName() {
        return Bundle.IncorrectConstructorPropertyPromotionHintError_displayName();
    }

    @Override
    public void invoke(PHPRuleContext context, List<Hint> hints) {
        PHPParseResult phpParseResult = (PHPParseResult)context.parserResult;
        if (phpParseResult.getProgram() == null) {
            return;
        }
        FileScope fileScope = context.fileScope;
        this.fileObject = phpParseResult.getSnapshot().getSource().getFileObject();
        if (fileScope != null && this.fileObject != null) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            CheckVisitor checkVisitor = new CheckVisitor();
            phpParseResult.getProgram().accept(checkVisitor);
            for (NamedArgument namedArgument : checkVisitor.getDuplicateNames()) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                this.addHint(namedArgument, Bundle.IncorrectNamedArguments_desc_duplicate_name(namedArgument.getParameterName().getName()), hints);
            }
            for (Map.Entry entry : checkVisitor.getCombinedNamedArgumentsWithArgumentUnpacking().entrySet()) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                this.addHint((ASTNode)entry.getKey(), Bundle.IncorrectNamedArguments_desc_combine_named_argument_and_argument_unpacking(), hints);
                this.addHint((ASTNode)entry.getValue(), Bundle.IncorrectNamedArguments_desc_combine_named_argument_and_argument_unpacking(), hints);
            }
            for (Expression expression : checkVisitor.getArgumentsAfterNamedArgument()) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                this.addHint(expression, Bundle.IncorrectNamedArguments_desc_positional_arguments_after_named_argument(), hints);
            }
        }
    }

    private void addHint(ASTNode node, String description, List<Hint> hints) {
        this.addHint(node, description, hints, Collections.emptyList());
    }

    private void addHint(ASTNode node, String description, List<Hint> hints, List<HintFix> fixes) {
        hints.add(new Hint((Rule)this, description, this.fileObject, new OffsetRange(node.getStartOffset(), node.getEndOffset()), fixes, 500));
    }

    private static final class CheckVisitor
    extends DefaultVisitor {
        private final Set<NamedArgument> duplicateNames = new HashSet<NamedArgument>();
        private final Map<NamedArgument, Variadic> combinedNamedArgumentsWithArgumentUnpacking = new HashMap<NamedArgument, Variadic>();
        private final Set<Expression> argumentsAfterNamedArgument = new HashSet<Expression>();

        private CheckVisitor() {
        }

        @Override
        public void visit(FunctionInvocation node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.processArguments(node.getParameters());
            super.visit(node);
        }

        @Override
        public void visit(ClassInstanceCreation node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.processArguments(node.ctorParams());
            super.visit(node);
        }

        @Override
        public void visit(AttributeDeclaration node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.processArguments(node.getParameters());
            super.visit(node);
        }

        private void processArguments(List<Expression> arguments) {
            if (arguments == null) {
                return;
            }
            HashSet<String> names = new HashSet<String>();
            NamedArgument firstNamedArgument = null;
            Variadic variadic = null;
            for (Expression argument : arguments) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                if (argument instanceof NamedArgument) {
                    String name;
                    if (firstNamedArgument == null) {
                        firstNamedArgument = (NamedArgument)argument;
                    }
                    if (names.contains(name = ((NamedArgument)argument).getParameterName().getName())) {
                        this.duplicateNames.add((NamedArgument)argument);
                        continue;
                    }
                    names.add(name);
                    continue;
                }
                if (argument instanceof Variadic) {
                    if (variadic != null) continue;
                    variadic = (Variadic)argument;
                    continue;
                }
                if (firstNamedArgument == null) continue;
                this.argumentsAfterNamedArgument.add(argument);
            }
            if (firstNamedArgument != null && variadic != null) {
                this.combinedNamedArgumentsWithArgumentUnpacking.put(firstNamedArgument, variadic);
            }
        }

        public Set<NamedArgument> getDuplicateNames() {
            return Collections.unmodifiableSet(this.duplicateNames);
        }

        public Map<NamedArgument, Variadic> getCombinedNamedArgumentsWithArgumentUnpacking() {
            return Collections.unmodifiableMap(this.combinedNamedArgumentsWithArgumentUnpacking);
        }

        public Set<Expression> getArgumentsAfterNamedArgument() {
            return Collections.unmodifiableSet(this.argumentsAfterNamedArgument);
        }
    }
}

