/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.nodes.dfa;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.regex.tregex.nodes.dfa.DFACaptureGroupPartialTransition;
import com.oracle.truffle.regex.tregex.nodes.dfa.DFACaptureGroupTrackingData;
import com.oracle.truffle.regex.tregex.nodes.dfa.TRegexDFAExecutorLocals;
import com.oracle.truffle.regex.tregex.nodes.dfa.TRegexDFAExecutorNode;
import com.oracle.truffle.regex.tregex.util.Exceptions;

public final class DFACaptureGroupPartialTransitionDispatchNode
extends Node {
    private static final int EXPLODE_THRESHOLD = 20;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final short[] precedingTransitions;

    public static DFACaptureGroupPartialTransitionDispatchNode create(short[] precedingTransitions) {
        return new DFACaptureGroupPartialTransitionDispatchNode(precedingTransitions);
    }

    private DFACaptureGroupPartialTransitionDispatchNode(short[] precedingTransitions) {
        this.precedingTransitions = precedingTransitions;
    }

    public void applyPartialTransition(TRegexDFAExecutorLocals locals, TRegexDFAExecutorNode executor, short transitionIndex, int partialTransitionIndex, int currentIndex) {
        CompilerAsserts.partialEvaluationConstant((Object)((Object)this));
        if (this.precedingTransitions.length > 20) {
            DFACaptureGroupPartialTransitionDispatchNode.applyPartialTransitionBoundary(executor, locals.getCGData(), transitionIndex, partialTransitionIndex, currentIndex);
        } else {
            this.applyPartialTransitionExploded(locals, executor, transitionIndex, partialTransitionIndex, currentIndex);
        }
    }

    @CompilerDirectives.TruffleBoundary
    private static void applyPartialTransitionBoundary(TRegexDFAExecutorNode executor, DFACaptureGroupTrackingData d, short transitionIndex, int partialTransitionIndex, int currentIndex) {
        executor.getCGTransitions()[transitionIndex].getPartialTransitions()[partialTransitionIndex].apply(executor, d, currentIndex);
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
    private void applyPartialTransitionExploded(TRegexDFAExecutorLocals locals, TRegexDFAExecutorNode executor, short transitionIndex, int partialTransitionIndex, int currentIndex) {
        for (short possibleTransition : this.precedingTransitions) {
            if (transitionIndex != possibleTransition) continue;
            DFACaptureGroupPartialTransition[] partialTransitions = executor.getCGTransitions()[possibleTransition].getPartialTransitions();
            for (int i = 0; i < partialTransitions.length; ++i) {
                CompilerAsserts.partialEvaluationConstant((int)i);
                if (i != partialTransitionIndex) continue;
                partialTransitions[i].apply(executor, locals.getCGData(), currentIndex);
                return;
            }
            throw Exceptions.shouldNotReachHere();
        }
        throw Exceptions.shouldNotReachHere();
    }

    public void applyPreAnchoredFinalTransition(TRegexDFAExecutorLocals locals, TRegexDFAExecutorNode executor, short transitionIndex, int currentIndex) {
        CompilerAsserts.partialEvaluationConstant((Object)((Object)this));
        if (this.precedingTransitions.length > 20) {
            DFACaptureGroupPartialTransitionDispatchNode.applyPreAnchoredFinalTransitionBoundary(executor, locals.getCGData(), transitionIndex, currentIndex);
        } else {
            this.applyPreAnchoredFinalTransitionExploded(locals, executor, transitionIndex, currentIndex);
        }
    }

    @CompilerDirectives.TruffleBoundary
    private static void applyPreAnchoredFinalTransitionBoundary(TRegexDFAExecutorNode executor, DFACaptureGroupTrackingData d, short transitionIndex, int currentIndex) {
        executor.getCGTransitions()[transitionIndex].getTransitionToAnchoredFinalState().applyPreFinalStateTransition(executor, d, currentIndex);
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
    private void applyPreAnchoredFinalTransitionExploded(TRegexDFAExecutorLocals locals, TRegexDFAExecutorNode executor, short transitionIndex, int currentIndex) {
        for (short possibleTransition : this.precedingTransitions) {
            if (transitionIndex != possibleTransition) continue;
            executor.getCGTransitions()[possibleTransition].getTransitionToAnchoredFinalState().applyPreFinalStateTransition(executor, locals.getCGData(), currentIndex);
            return;
        }
        throw Exceptions.shouldNotReachHere();
    }

    public void applyPreFinalTransition(TRegexDFAExecutorLocals locals, TRegexDFAExecutorNode executor, short transitionIndex, int currentIndex) {
        CompilerAsserts.partialEvaluationConstant((Object)((Object)this));
        if (this.precedingTransitions.length > 20) {
            DFACaptureGroupPartialTransitionDispatchNode.applyPreFinalTransitionBoundary(executor, locals.getCGData(), transitionIndex, currentIndex);
        } else {
            this.applyPreFinalTransitionExploded(locals, executor, executor, transitionIndex, currentIndex);
        }
    }

    @CompilerDirectives.TruffleBoundary
    private static void applyPreFinalTransitionBoundary(TRegexDFAExecutorNode executor, DFACaptureGroupTrackingData d, short transitionIndex, int currentIndex) {
        executor.getCGTransitions()[transitionIndex].getTransitionToFinalState().applyPreFinalStateTransition(executor, d, currentIndex);
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
    private void applyPreFinalTransitionExploded(TRegexDFAExecutorLocals locals, TRegexDFAExecutorNode executor, TRegexDFAExecutorNode executorNode, short transitionIndex, int currentIndex) {
        for (short possibleTransition : this.precedingTransitions) {
            if (transitionIndex != possibleTransition) continue;
            executorNode.getCGTransitions()[possibleTransition].getTransitionToFinalState().applyPreFinalStateTransition(executor, locals.getCGData(), currentIndex);
            return;
        }
        throw Exceptions.shouldNotReachHere();
    }
}

