/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javaee.wildfly.config;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.javaee.wildfly.config.EjbDeploymentConfiguration;
import org.netbeans.modules.javaee.wildfly.config.gen.EnterpriseBeans;
import org.netbeans.modules.javaee.wildfly.config.gen.Entity;
import org.netbeans.modules.javaee.wildfly.config.gen.Jboss;
import org.netbeans.modules.javaee.wildfly.config.gen.MessageDestinationRef;
import org.netbeans.modules.javaee.wildfly.config.gen.MessageDriven;
import org.netbeans.modules.javaee.wildfly.config.gen.Session;

final class JBossMsgDestRefModifier {
    JBossMsgDestRefModifier() {
    }

    static void modify(Jboss modifiedJboss, String msgDestRefName, Set beanNames, EjbDeploymentConfiguration.BEAN_TYPE beanType, String destPrefix, String destName) {
        assert (beanNames.size() > 0);
        if (modifiedJboss.getEnterpriseBeans() == null) {
            modifiedJboss.setEnterpriseBeans(new EnterpriseBeans());
        }
        if (beanType == EjbDeploymentConfiguration.BEAN_TYPE.SESSION) {
            JBossMsgDestRefModifier.addSessionMsgDestReference(modifiedJboss, msgDestRefName, beanNames, destPrefix, destName);
        } else if (beanType == EjbDeploymentConfiguration.BEAN_TYPE.ENTITY) {
            JBossMsgDestRefModifier.addEntityMsgDestReference(modifiedJboss, msgDestRefName, beanNames, destPrefix, destName);
        }
    }

    private static void addSessionMsgDestReference(Jboss modifiedJboss, String msgDestRefName, Set sessionNames, String destPrefix, String destName) {
        LinkedList<Session> sesssionsWithoutReference = new LinkedList<Session>();
        EnterpriseBeans eb = modifiedJboss.getEnterpriseBeans();
        Session[] sessions = eb.getSession();
        for (int i = 0; i < sessions.length; ++i) {
            String mdrn;
            int j;
            String ejbName = sessions[i].getEjbName();
            if (!sessionNames.contains(ejbName)) continue;
            sessionNames.remove(ejbName);
            MessageDestinationRef[] msgDestRefs = sessions[i].getMessageDestinationRef();
            for (j = 0; j < msgDestRefs.length && !msgDestRefName.equals(mdrn = msgDestRefs[j].getMessageDestinationRefName()); ++j) {
            }
            if (j != msgDestRefs.length) continue;
            sesssionsWithoutReference.add(sessions[i]);
        }
        for (String sessionName : sessionNames) {
            Session session = new Session();
            session.setEjbName(sessionName);
            session.setJndiName(sessionName);
            eb.addSession(session);
            sesssionsWithoutReference.add(session);
        }
        Iterator it = sesssionsWithoutReference.iterator();
        while (it.hasNext()) {
            MessageDestinationRef mdr = new MessageDestinationRef();
            mdr.setMessageDestinationRefName(msgDestRefName);
            String jndiName = JBossMsgDestRefModifier.getJndiName(destName, destPrefix);
            mdr.setJndiName(jndiName);
            Session session = (Session)((Object)it.next());
            session.addMessageDestinationRef(mdr);
        }
    }

    private static void addEntityMsgDestReference(Jboss modifiedJboss, String msgDestRefName, Set entityNames, String destPrefix, String destName) {
        LinkedList<Entity> entitiesWithoutReference = new LinkedList<Entity>();
        EnterpriseBeans eb = modifiedJboss.getEnterpriseBeans();
        Entity[] entities = eb.getEntity();
        for (int i = 0; i < entities.length; ++i) {
            String mdrn;
            int j;
            String ejbName = entities[i].getEjbName();
            if (!entityNames.contains(ejbName)) continue;
            entityNames.remove(ejbName);
            MessageDestinationRef[] msgDestRefs = entities[i].getMessageDestinationRef();
            for (j = 0; j < msgDestRefs.length && !msgDestRefName.equals(mdrn = msgDestRefs[j].getMessageDestinationRefName()); ++j) {
            }
            if (j != msgDestRefs.length) continue;
            entitiesWithoutReference.add(entities[i]);
        }
        for (String entityName : entityNames) {
            Entity entity = new Entity();
            entity.setEjbName(entityName);
            entity.setJndiName(entityName);
            eb.addEntity(entity);
            entitiesWithoutReference.add(entity);
        }
        Iterator it = entitiesWithoutReference.iterator();
        while (it.hasNext()) {
            MessageDestinationRef mdr = new MessageDestinationRef();
            mdr.setMessageDestinationRefName(msgDestRefName);
            String jndiName = JBossMsgDestRefModifier.getJndiName(destName, destPrefix);
            mdr.setJndiName(jndiName);
            Entity entity = (Entity)((Object)it.next());
            entity.addMessageDestinationRef(mdr);
        }
    }

    static void modifyMsgDrv(Jboss modifiedJboss, String msgDestRefName, Map beans, String destPrefix) {
        assert (beans.size() > 0);
        if (modifiedJboss.getEnterpriseBeans() == null) {
            modifiedJboss.setEnterpriseBeans(new EnterpriseBeans());
        }
        JBossMsgDestRefModifier.addMsgDrvMsgDestReference(modifiedJboss, msgDestRefName, beans, destPrefix);
    }

    private static void addMsgDrvMsgDestReference(Jboss modifiedJboss, String msgDestRefName, Map beans, String destPrefix) {
        LinkedList<MessageDriven> msgdrvsWithoutReference = new LinkedList<MessageDriven>();
        EnterpriseBeans eb = modifiedJboss.getEnterpriseBeans();
        MessageDriven[] msgDrivens = eb.getMessageDriven();
        for (int i = 0; i < msgDrivens.length; ++i) {
            String mdrn;
            int j;
            String ejbName = msgDrivens[i].getEjbName();
            if (!beans.containsKey(ejbName)) continue;
            beans.remove(ejbName);
            MessageDestinationRef[] msgDestRefs = msgDrivens[i].getMessageDestinationRef();
            for (j = 0; j < msgDestRefs.length && !msgDestRefName.equals(mdrn = msgDestRefs[j].getMessageDestinationRefName()); ++j) {
            }
            if (j != msgDestRefs.length) continue;
            msgdrvsWithoutReference.add(msgDrivens[i]);
        }
        for (Map.Entry entry : beans.entrySet()) {
            MessageDriven mdb = new MessageDriven();
            mdb.setEjbName((String)entry.getKey());
            mdb.setDestinationJndiName((String)entry.getValue());
            eb.addMessageDriven(mdb);
            msgdrvsWithoutReference.add(mdb);
        }
        Iterator it = msgdrvsWithoutReference.iterator();
        while (it.hasNext()) {
            MessageDestinationRef mdr = new MessageDestinationRef();
            mdr.setMessageDestinationRefName(msgDestRefName);
            String jndiName = JBossMsgDestRefModifier.getJndiName(msgDestRefName, destPrefix);
            mdr.setJndiName(jndiName);
            MessageDriven mdb = (MessageDriven)((Object)it.next());
            mdb.addMessageDestinationRef(mdr);
        }
    }

    static void modifyMsgDrv(Jboss modifiedJboss, String msgDestRefName, String mdbName, String destPrefix, String destName) {
        if (modifiedJboss.getEnterpriseBeans() == null) {
            modifiedJboss.setEnterpriseBeans(new EnterpriseBeans());
        }
        JBossMsgDestRefModifier.addMsgDrvMsgDestReference(modifiedJboss, msgDestRefName, mdbName, destPrefix, destName);
    }

    private static void addMsgDrvMsgDestReference(Jboss modifiedJboss, String msgDestRefName, String mdbName, String destPrefix, String destName) {
        EnterpriseBeans eb = modifiedJboss.getEnterpriseBeans();
        for (MessageDriven mdb : eb.getMessageDriven()) {
            int j;
            String ejbName = mdb.getEjbName();
            if (!mdbName.equals(ejbName)) continue;
            MessageDestinationRef[] msgDestRefs = mdb.getMessageDestinationRef();
            for (j = 0; j < msgDestRefs.length; ++j) {
                String mdrn = msgDestRefs[j].getMessageDestinationRefName();
                if (!msgDestRefName.equals(mdrn)) continue;
                return;
            }
            if (j != msgDestRefs.length) continue;
            MessageDestinationRef mdr = new MessageDestinationRef();
            mdr.setMessageDestinationRefName(msgDestRefName);
            String jndiName = JBossMsgDestRefModifier.getJndiName(destName, destPrefix);
            mdr.setJndiName(jndiName);
            mdb.addMessageDestinationRef(mdr);
        }
    }

    private static String getJndiName(String destName, String destPrefix) {
        return destPrefix + destName;
    }
}

