/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project.ui;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.j2ee.dd.api.web.WebAppMetadata;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.ConfigurationFilesListener;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelException;
import org.netbeans.modules.web.api.webmodule.WebFrameworks;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.project.ProjectWebModule;
import org.netbeans.modules.web.project.WebProject;
import org.netbeans.modules.web.project.ui.DocBaseNodeFactory;
import org.netbeans.modules.web.project.ui.WebLogicalViewProvider;
import org.netbeans.modules.web.spi.webmodule.WebFrameworkProvider;
import org.netbeans.spi.project.ui.support.NodeFactory;
import org.netbeans.spi.project.ui.support.NodeList;
import org.netbeans.spi.search.SearchInfoDefinition;
import org.netbeans.spi.search.SearchInfoDefinitionFactory;
import org.openide.actions.FindAction;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileStatusListener;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;

public final class ConfFilesNodeFactory
implements NodeFactory {
    public NodeList createNodes(Project p) {
        WebProject project = (WebProject)p.getLookup().lookup(WebProject.class);
        assert (project != null);
        return new ConfFilesNodeList(project);
    }

    private static class ClassPathChangeListener
    implements PropertyChangeListener {
        private ConfFilesChildrenFactory myFactory;

        ClassPathChangeListener(ConfFilesChildrenFactory factory) {
            this.myFactory = factory;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.myFactory.update();
        }
    }

    private static final class NodeComparator
    implements Comparator<FileObject>,
    Serializable {
        private NodeComparator() {
        }

        @Override
        public int compare(FileObject fo1, FileObject fo2) {
            int result = this.compareType(fo1, fo2);
            if (result == 0) {
                result = this.compareNames(fo1, fo2);
            }
            if (result == 0) {
                return fo1.getPath().compareTo(fo2.getPath());
            }
            return result;
        }

        private int compareType(FileObject fo1, FileObject fo2) {
            int folder1 = fo1.isFolder() ? 0 : 1;
            int folder2 = fo2.isFolder() ? 0 : 1;
            return folder1 - folder2;
        }

        private int compareNames(FileObject do1, FileObject do2) {
            return do1.getNameExt().compareTo(do2.getNameExt());
        }
    }

    private static final class ConfFilesChildrenFactory
    extends ChildFactory.Detachable<FileObject> {
        private static final String[] WELL_KNOWN_FILES = new String[]{"web.xml", "webservices.xml", "struts-config.xml", "faces-config.xml", "portlet.xml", "navigator.xml", "managed-beans.xml", "beans.xml"};
        private static final Comparator<FileObject> COMPARATOR = new NodeComparator();
        private final FileChangeListener myWebInfListener = new FileChangeAdapter(){

            public void fileDataCreated(FileEvent fe) {
                if (this.isWellKnownFile(fe.getFile().getNameExt())) {
                    this.refresh(false);
                }
            }

            public void fileRenamed(FileRenameEvent fe) {
                if (myKeys.contains(fe.getFile())) {
                    this.refresh(false);
                } else if (this.isWellKnownFile(fe.getFile().getNameExt())) {
                    this.refresh(false);
                }
            }

            public void fileDeleted(FileEvent fe) {
                if (this.isWellKnownFile(fe.getFile().getNameExt())) {
                    this.refresh(false);
                }
            }
        };
        private final FileChangeListener myAnyFileListener = new FileChangeAdapter(){

            public void fileDataCreated(FileEvent fe) {
                this.refresh(false);
            }

            public void fileFolderCreated(FileEvent fe) {
                this.refresh(false);
            }

            public void fileRenamed(FileRenameEvent fe) {
                this.refresh(false);
            }

            public void fileDeleted(FileEvent fe) {
                this.refresh(false);
            }
        };
        private final ConfigurationFilesListener myServerSpecificFilesListener = new ConfigurationFilesListener(){

            public void fileCreated(FileObject fo) {
                this.refresh(false);
            }

            public void fileDeleted(FileObject fo) {
                this.refresh(false);
            }
        };
        private final ClassPathChangeListener myClassPathListener = new ClassPathChangeListener(this);
        private ProjectWebModule myWebModule;
        private Set<FileObject> myKeys;
        private FileObject myConfDir;
        private FileObject myPersistenceXmlDir;

        private ConfFilesChildrenFactory(ProjectWebModule webModule) {
            this.myWebModule = webModule;
            this.myKeys = Collections.emptySet();
        }

        public static ConfFilesChildrenFactory forProject(Project project) {
            ProjectWebModule pwm = (ProjectWebModule)project.getLookup().lookup(ProjectWebModule.class);
            return new ConfFilesChildrenFactory(pwm);
        }

        void update() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    this.refresh(false);
                }
            });
        }

        protected void removeNotify() {
            this.removeListeners();
        }

        public Node createNodeForKey(FileObject fo) {
            Node node = null;
            try {
                DataObject dataObject = DataObject.find((FileObject)fo);
                node = dataObject.getNodeDelegate().cloneNode();
                if (fo.isFolder()) {
                    DataFolder dataFolder = DataFolder.findFolder((FileObject)fo);
                    node = new FilterNode(node, dataFolder.createNodeChildren((DataFilter)new DocBaseNodeFactory.VisibilityQueryDataFilter(null)));
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
            return node;
        }

        protected boolean createKeys(List<FileObject> keys) {
            boolean result = false;
            this.myKeys = new HashSet<FileObject>();
            if (this.addWellKnownFiles()) {
                result = true;
            }
            if (!result && this.addConfDirectoryFiles()) {
                result = true;
            }
            if (!result && this.addPersistenceXmlDirectoryFiles()) {
                result = true;
            }
            if (!result && this.addServerSpecificFiles()) {
                result = true;
            }
            if (!result && this.addFrameworkFiles()) {
                result = true;
            }
            if (!result && this.addWebFragments()) {
                result = true;
            }
            keys.addAll(this.myKeys);
            Collections.sort(keys, COMPARATOR);
            return true;
        }

        private void removeListeners() {
            this.getWebModule().removeConfigurationFilesListener(this.myServerSpecificFilesListener);
            FileObject webInf = this.getWebModule().getWebInf(true);
            if (webInf != null) {
                this.getWebModule().getWebInf().removeFileChangeListener(this.myWebInfListener);
            }
            if (this.myConfDir != null) {
                this.myConfDir.removeFileChangeListener(this.myAnyFileListener);
            }
            if (this.myPersistenceXmlDir != null) {
                this.myPersistenceXmlDir.removeFileChangeListener(this.myAnyFileListener);
            }
        }

        private boolean addWellKnownFiles() {
            FileObject webInf = this.getWebModule().getWebInf(true);
            if (webInf == null) {
                return false;
            }
            boolean result = false;
            for (int i = 0; i < WELL_KNOWN_FILES.length; ++i) {
                FileObject fo = webInf.getFileObject(WELL_KNOWN_FILES[i]);
                if (fo != null) {
                    this.myKeys.add(fo);
                }
                if (!Thread.interrupted()) continue;
                result = true;
                break;
            }
            webInf.addFileChangeListener(this.myWebInfListener);
            return result;
        }

        private boolean addConfDirectoryFiles() {
            this.myConfDir = this.getWebModule().getConfDir();
            if (this.myConfDir == null) {
                return false;
            }
            boolean result = false;
            FileObject[] children = this.myConfDir.getChildren();
            for (int i = 0; i < children.length; ++i) {
                if (VisibilityQuery.getDefault().isVisible(children[i])) {
                    this.myKeys.add(children[i]);
                }
                if (!Thread.interrupted()) continue;
                result = true;
                break;
            }
            this.myConfDir.addFileChangeListener(this.myAnyFileListener);
            return result;
        }

        private boolean addPersistenceXmlDirectoryFiles() {
            this.myPersistenceXmlDir = this.getWebModule().getPersistenceXmlDir();
            if (this.myPersistenceXmlDir == null || this.myConfDir != null && FileUtil.toFile((FileObject)this.myPersistenceXmlDir).equals(FileUtil.toFile((FileObject)this.myConfDir))) {
                return false;
            }
            boolean result = false;
            FileObject[] children = this.myPersistenceXmlDir.getChildren();
            for (int i = 0; i < children.length; ++i) {
                if (VisibilityQuery.getDefault().isVisible(children[i])) {
                    this.myKeys.add(children[i]);
                }
                if (!Thread.interrupted()) continue;
                result = true;
                break;
            }
            this.myPersistenceXmlDir.addFileChangeListener(this.myAnyFileListener);
            return result;
        }

        private boolean addServerSpecificFiles() {
            FileObject[] files = this.getWebModule().getConfigurationFiles();
            boolean result = false;
            for (int i = 0; i < files.length; ++i) {
                this.myKeys.add(files[i]);
                if (!Thread.interrupted()) continue;
                result = true;
                break;
            }
            this.getWebModule().addConfigurationFilesListener(this.myServerSpecificFilesListener);
            return result;
        }

        private boolean addFrameworkFiles() {
            List providers = WebFrameworks.getFrameworks();
            boolean result = false;
            block0: for (int i = 0; i < providers.size(); ++i) {
                WebModule wm;
                WebFrameworkProvider provider = (WebFrameworkProvider)providers.get(i);
                FileObject wmBase = this.getWebModule().getDocumentBase();
                File[] files = null;
                if (wmBase != null && (wm = WebModule.getWebModule((FileObject)wmBase)) != null) {
                    files = provider.getConfigurationFiles(wm);
                }
                if (files == null) continue;
                for (int j = 0; j < files.length; ++j) {
                    FileObject fo = FileUtil.toFileObject((File)files[j]);
                    if (fo != null) {
                        this.myKeys.add(fo);
                    }
                    if (!Thread.interrupted()) continue;
                    result = true;
                    break block0;
                }
            }
            return result;
        }

        private boolean addWebFragments() {
            try {
                List frags = (List)this.getWebModule().getMetadataModel().runReadAction((MetadataModelAction)new MetadataModelAction<WebAppMetadata, List<FileObject>>(){

                    public List<FileObject> run(WebAppMetadata metadata) throws Exception {
                        return metadata.getFragmentFiles();
                    }
                });
                this.myKeys.addAll(frags);
            }
            catch (MetadataModelException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            FileObject[] roots = this.getWebModule().getSourceRoots();
            if (roots != null) {
                for (FileObject root : roots) {
                    ClassPath cp = this.getWebModule().getClassPathProvider().findClassPath(root, "classpath/compile");
                    if (cp == null) continue;
                    cp.removePropertyChangeListener((PropertyChangeListener)this.myClassPathListener);
                    cp.addPropertyChangeListener((PropertyChangeListener)this.myClassPathListener);
                }
            }
            return Thread.interrupted();
        }

        private ProjectWebModule getWebModule() {
            return this.myWebModule;
        }

        private boolean isWellKnownFile(String name) {
            for (int i = 0; i < WELL_KNOWN_FILES.length; ++i) {
                if (!name.equals(WELL_KNOWN_FILES[i])) continue;
                return true;
            }
            return false;
        }
    }

    private static final class ConfFilesNode
    extends AbstractNode
    implements Runnable,
    FileStatusListener,
    ChangeListener,
    PropertyChangeListener {
        private static final Image CONFIGURATION_FILES_BADGE = ImageUtilities.loadImage((String)"org/netbeans/modules/web/project/ui/resources/config-badge.gif", (boolean)true);
        private Set files;
        private Map<FileSystem, FileStatusListener> fileSystemListeners;
        private RequestProcessor.Task task;
        private final Object privateLock = new Object();
        private boolean iconChange;
        private boolean nameChange;
        private ChangeListener sourcesListener;
        private Map<SourceGroup, PropertyChangeListener> groupsListeners;
        private final Project project;
        private Node iconDelegate;

        public ConfFilesNode(Project prj) {
            this(prj, Children.create((ChildFactory)ConfFilesChildrenFactory.forProject(prj), (boolean)true));
        }

        private ConfFilesNode(Project prj, Children children) {
            super(children, ConfFilesNode.createLookup(prj, children));
            this.project = prj;
            this.setName("configurationFiles");
            this.iconDelegate = DataFolder.findFolder((FileObject)FileUtil.getConfigRoot()).getNodeDelegate();
        }

        private static Lookup createLookup(Project project, Children children) {
            if (project.getProjectDirectory().isValid()) {
                SearchInfoDefinition searchInfo = SearchInfoDefinitionFactory.createSearchInfoBySubnodes((Children)children);
                return Lookups.fixed((Object[])new Object[]{project, searchInfo});
            }
            return Lookups.fixed((Object[])new Object[]{project});
        }

        public Image getIcon(int type) {
            return this.computeIcon(false, type);
        }

        public Image getOpenedIcon(int type) {
            return this.computeIcon(true, type);
        }

        private Image computeIcon(boolean opened, int type) {
            Image image = opened ? this.iconDelegate.getOpenedIcon(type) : this.iconDelegate.getIcon(type);
            image = ImageUtilities.mergeImages((Image)image, (Image)CONFIGURATION_FILES_BADGE, (int)7, (int)7);
            return image;
        }

        public String getDisplayName() {
            return NbBundle.getMessage(ConfFilesNodeFactory.class, (String)"LBL_Node_Config");
        }

        public Action[] getActions(boolean context) {
            return new Action[]{SystemAction.get(FindAction.class)};
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean fireName;
            boolean fireIcon;
            Object object = this.privateLock;
            synchronized (object) {
                fireIcon = this.iconChange;
                fireName = this.nameChange;
                this.iconChange = false;
                this.nameChange = false;
            }
            if (fireIcon) {
                this.fireIconChange();
                this.fireOpenedIconChange();
            }
            if (fireName) {
                this.fireDisplayNameChange(null, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void annotationChanged(FileStatusEvent event) {
            if (this.task == null) {
                this.task = RequestProcessor.getDefault().create((Runnable)this);
            }
            Object object = this.privateLock;
            synchronized (object) {
                if (!this.iconChange && event.isIconChange() || !this.nameChange && event.isNameChange()) {
                    for (FileObject fo : this.files) {
                        if (!event.hasChanged(fo)) continue;
                        this.iconChange |= event.isIconChange();
                        this.nameChange |= event.isNameChange();
                    }
                }
            }
            this.task.schedule(50);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.setProjectFiles(this.project);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.setProjectFiles(this.project);
        }

        protected void setProjectFiles(Project project) {
            Sources sources = ProjectUtils.getSources((Project)project);
            if (this.sourcesListener == null) {
                this.sourcesListener = WeakListeners.change((ChangeListener)this, (Object)sources);
                sources.addChangeListener(this.sourcesListener);
            }
            this.setGroups(Arrays.asList(sources.getSourceGroups("generic")));
        }

        private void setGroups(Collection groups) {
            if (this.groupsListeners != null) {
                for (SourceGroup group : this.groupsListeners.keySet()) {
                    PropertyChangeListener pcl = this.groupsListeners.get(group);
                    group.removePropertyChangeListener(pcl);
                }
            }
            this.groupsListeners = new HashMap<SourceGroup, PropertyChangeListener>();
            HashSet<FileObject> roots = new HashSet<FileObject>();
            for (SourceGroup group : groups) {
                PropertyChangeListener pcl = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)group);
                this.groupsListeners.put(group, pcl);
                group.addPropertyChangeListener(pcl);
                FileObject fo = group.getRootFolder();
                roots.add(fo);
            }
            this.setFiles(roots);
        }

        protected void setFiles(Set files) {
            if (this.fileSystemListeners != null) {
                for (FileSystem fs : this.fileSystemListeners.keySet()) {
                    FileStatusListener fsl = this.fileSystemListeners.get(fs);
                    fs.removeFileStatusListener(fsl);
                }
            }
            this.fileSystemListeners = new HashMap<FileSystem, FileStatusListener>();
            this.files = files;
            if (files == null) {
                return;
            }
            Iterator<Object> it = files.iterator();
            HashSet<FileSystem> hookedFileSystems = new HashSet<FileSystem>();
            while (it.hasNext()) {
                FileObject fo = (FileObject)it.next();
                try {
                    FileSystem fs = fo.getFileSystem();
                    if (hookedFileSystems.contains(fs)) continue;
                    hookedFileSystems.add(fs);
                    FileStatusListener fsl = FileUtil.weakFileStatusListener((FileStatusListener)this, (Object)fs);
                    fs.addFileStatusListener(fsl);
                    this.fileSystemListeners.put(fs, fsl);
                }
                catch (FileStateInvalidException e) {
                    Exceptions.printStackTrace((Throwable)Exceptions.attachMessage((Throwable)e, (String)("Can not get " + fo + " filesystem, ignoring...")));
                }
            }
        }
    }

    private static class ConfFilesNodeList
    implements NodeList<String>,
    PropertyChangeListener {
        private static final String CONF_FILES = "confFiles";
        private final WebProject project;
        private final ChangeSupport changeSupport = new ChangeSupport((Object)this);

        ConfFilesNodeList(WebProject proj) {
            this.project = proj;
            WebLogicalViewProvider logView = (WebLogicalViewProvider)((Object)this.project.getLookup().lookup(WebLogicalViewProvider.class));
            assert (logView != null);
        }

        public List<String> keys() {
            ArrayList<String> result = new ArrayList<String>();
            result.add(CONF_FILES);
            return result;
        }

        public void addChangeListener(ChangeListener l) {
            this.changeSupport.addChangeListener(l);
        }

        public void removeChangeListener(ChangeListener l) {
            this.changeSupport.removeChangeListener(l);
        }

        public Node node(String key) {
            if (CONF_FILES.equals(key)) {
                return new ConfFilesNode(this.project);
            }
            assert (false) : "No node for key: " + key;
            return null;
        }

        public void addNotify() {
        }

        public void removeNotify() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    changeSupport.fireChange();
                }
            });
        }
    }
}

