/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.explorer;

import java.net.URI;
import java.util.Objects;
import org.eclipse.lsp4j.MarkupContent;
import org.netbeans.modules.java.lsp.server.protocol.TextDocumentServiceImpl;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.nodes.Node;

public class TreeItem {
    public CollapsibleState collapsibleState;
    public String command;
    public String contextValue;
    public String description;
    public URI iconUri;
    public int id;
    public String name;
    public String label;
    public String resourceUri;
    public Object tooltip;
    public IconDescriptor iconDescriptor;
    public int iconIndex;

    public TreeItem() {
    }

    static Object html2md(String s) {
        if (s != null && s.startsWith("<html>")) {
            MarkupContent markup = new MarkupContent();
            markup.setKind("markdown");
            markup.setValue(TextDocumentServiceImpl.html2MD(s));
            return markup;
        }
        return s;
    }

    TreeItem(int id, Node n, boolean wasExpanded, String contextValue) {
        FileObject fo;
        this.collapsibleState = n.isLeaf() ? CollapsibleState.None : (wasExpanded ? CollapsibleState.Expanded : CollapsibleState.Collapsed);
        this.contextValue = contextValue;
        this.id = id;
        this.name = n.getName();
        this.label = n.getDisplayName();
        String desc = n.getShortDescription();
        if (!Objects.equals(this.label, desc)) {
            this.tooltip = TreeItem.html2md(desc);
        }
        if ((fo = (FileObject)n.getLookup().lookup(FileObject.class)) != null) {
            this.resourceUri = URLMapper.findURL((FileObject)fo, (int)1).toString();
        }
    }

    public static class IconDescriptor {
        public URI baseUri;
        public String[] composition;
    }

    static enum CollapsibleState {
        None,
        Collapsed,
        Expanded;

    }
}

