/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.console;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.LinkedList;
import org.netbeans.api.debugger.Properties;
import org.netbeans.api.io.Hyperlink;
import org.netbeans.api.io.IOProvider;
import org.netbeans.api.io.InputOutput;
import org.netbeans.api.io.OutputWriter;
import org.netbeans.modules.debugger.jpda.DebuggerConsoleIO;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.openide.util.RequestProcessor;

public class IOManager {
    private final Reference<JPDADebuggerImpl> debuggerRef;
    private final String title;
    private InputOutput debuggerIO = null;
    private OutputWriter debuggerOut;
    private OutputWriter debuggerErr;
    private boolean closed = false;
    private boolean streamsClosed = false;
    private final LinkedList<Text> buffer = new LinkedList();
    private RequestProcessor.Task task;

    public IOManager(JPDADebuggerImpl debugger, String title) {
        this.debuggerRef = new WeakReference<JPDADebuggerImpl>(debugger);
        this.title = title;
        this.init();
    }

    private boolean init() {
        if (IOManager.openDebuggerConsole()) {
            this.debuggerIO = IOProvider.getDefault().getIO(this.title, true);
            this.debuggerOut = this.debuggerIO.getOut();
            this.debuggerErr = this.debuggerIO.getErr();
            return true;
        }
        return false;
    }

    private static boolean openDebuggerConsole() {
        Properties p = Properties.getDefault().getProperties("debugger.options.JPDA");
        return p.getBoolean("OpenDebuggerConsole", true);
    }

    public void println(String text, DebuggerConsoleIO.Line line) {
        this.println(text, line, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(String text, DebuggerConsoleIO.Line line, boolean important) {
        if (text == null) {
            throw new NullPointerException();
        }
        if (!IOManager.openDebuggerConsole()) {
            return;
        }
        Object object = this;
        synchronized (object) {
            if (this.debuggerIO == null) {
                this.init();
            }
        }
        object = this.buffer;
        synchronized (object) {
            this.buffer.addLast(new Text(text, line, important));
            if (this.task == null) {
                this.task = new RequestProcessor("Debugger Output", 1).post(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        ArrayList output;
                        LinkedList linkedList = IOManager.this.buffer;
                        synchronized (linkedList) {
                            output = new ArrayList(IOManager.this.buffer);
                            IOManager.this.buffer.clear();
                        }
                        if (IOManager.this.streamsClosed) {
                            return;
                        }
                        JPDADebuggerImpl debugger = (JPDADebuggerImpl)((Object)IOManager.this.debuggerRef.get());
                        int k = output.size();
                        for (int i = 0; i < k; ++i) {
                            Hyperlink hl;
                            Text t = (Text)output.get(i);
                            if (t.important) {
                                if (t.line != null) {
                                    hl = Hyperlink.from((Runnable)new HyperlinkRunnable(t.line), (boolean)t.important);
                                    IOManager.this.debuggerErr.println(t.text, hl);
                                } else {
                                    IOManager.this.debuggerErr.println(t.text);
                                }
                                IOManager.this.debuggerIO.show();
                                IOManager.this.debuggerErr.flush();
                            } else {
                                if (t.line != null) {
                                    hl = Hyperlink.from((Runnable)new HyperlinkRunnable(t.line), (boolean)t.important);
                                    IOManager.this.debuggerOut.println(t.text, hl);
                                } else {
                                    IOManager.this.debuggerOut.println(t.text);
                                }
                                IOManager.this.debuggerOut.flush();
                            }
                            if (debugger != null) {
                                debugger.actionStatusDisplayCallback(null, t.text);
                            }
                            if (!IOManager.this.closed) continue;
                            IOManager.this.debuggerOut.close();
                            IOManager.this.debuggerErr.close();
                            IOManager.this.streamsClosed = true;
                        }
                    }
                }, 50, 1);
            } else if (this.buffer.size() > 25) {
                this.task.run();
            } else {
                this.task.schedule(50);
            }
        }
    }

    public InputOutput getIO() {
        return this.debuggerIO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeStream() {
        LinkedList<Text> linkedList = this.buffer;
        synchronized (linkedList) {
            this.closed = true;
            if (this.task != null) {
                this.task.schedule(50);
            }
        }
    }

    void close() {
        if (this.debuggerIO != null) {
            this.debuggerIO.close();
        }
    }

    private static class Text {
        private String text;
        private DebuggerConsoleIO.Line line;
        private boolean important;

        private Text(String text, DebuggerConsoleIO.Line line, boolean important) {
            this.text = text;
            this.line = line;
            this.important = important;
        }
    }

    private static final class HyperlinkRunnable
    implements Runnable {
        private final DebuggerConsoleIO.Line line;

        public HyperlinkRunnable(DebuggerConsoleIO.Line line) {
            this.line = line;
        }

        @Override
        public void run() {
            this.line.show();
        }
    }
}

