/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.j2ee.execution;

import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.InstanceRemovedException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ServerInstance;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.maven.api.execute.ExecutionContext;
import org.netbeans.modules.maven.api.execute.ExecutionResultChecker;
import org.netbeans.modules.maven.api.execute.PrerequisitesChecker;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.j2ee.OneTimeDeployment;
import org.netbeans.modules.maven.j2ee.execution.Bundle;
import org.netbeans.modules.maven.j2ee.execution.DeploymentHelper;
import org.netbeans.modules.maven.j2ee.ui.SelectAppServerPanel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;

public class ExecutionChecker
implements ExecutionResultChecker,
PrerequisitesChecker {
    public static final String CLIENTURLPART = "netbeans.deploy.clientUrlPart";
    public static final String DEV_NULL = "DEV-NULL";
    private final Project project;

    public ExecutionChecker(Project prj) {
        this.project = prj;
    }

    public void executionResult(RunConfig config, ExecutionContext res, int resultCode) {
        boolean depl = Boolean.parseBoolean((String)config.getProperties().get("netbeans.deploy"));
        if (depl && resultCode == 0) {
            DeploymentHelper.perform(config, res);
        }
    }

    public boolean checkRunConfig(RunConfig config) {
        J2eeModuleProvider provider;
        if (!this.isSupported(config)) {
            return false;
        }
        boolean depl = Boolean.parseBoolean((String)config.getProperties().get("netbeans.deploy"));
        if (depl && (provider = (J2eeModuleProvider)config.getProject().getLookup().lookup(J2eeModuleProvider.class)) != null) {
            return SelectAppServerPanel.showServerSelectionDialog(this.project, provider, config);
        }
        return true;
    }

    private boolean isSupported(RunConfig config) {
        String serverInstanceID = this.getServerInstanceID();
        if (serverInstanceID == null || serverInstanceID.equals(DEV_NULL)) {
            return true;
        }
        boolean debugmode = DeploymentHelper.isDebugMode(config);
        boolean profilemode = DeploymentHelper.isProfileMode(config);
        ServerInstance serverInstance = Deployment.getDefault().getServerInstance(serverInstanceID);
        try {
            if (serverInstance != null) {
                if (debugmode && !serverInstance.isDebuggingSupported()) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.MSG_Server_No_Debugging(), 2));
                    return false;
                }
                if (profilemode && !serverInstance.isProfilingSupported()) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.MSG_Server_No_Profiling(), 2));
                    return false;
                }
            }
        }
        catch (InstanceRemovedException ex) {
            return true;
        }
        return true;
    }

    private String getServerInstanceID() {
        J2eeModuleProvider moduleProvider = (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class);
        String serverInstanceID = null;
        OneTimeDeployment oneTimeDeployment = (OneTimeDeployment)this.project.getLookup().lookup(OneTimeDeployment.class);
        if (oneTimeDeployment != null) {
            serverInstanceID = oneTimeDeployment.getServerInstanceId();
        }
        if (serverInstanceID == null && moduleProvider != null) {
            serverInstanceID = moduleProvider.getServerInstanceID();
        }
        return serverInstanceID;
    }
}

